/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import lombok.Generated;
import org.xbill.DNS.Address;
import org.xbill.DNS.Utils;

final class IPAddressUtils {
    static final int IPv4 = 1;
    static final int IPv6 = 2;

    static byte[] parseV4(String s) {
        byte[] values = new byte[4];
        int length = s.length();
        int currentOctet = 0;
        int currentValue = 0;
        int numDigits = 0;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                if (numDigits == 3) {
                    return null;
                }
                if (numDigits > 0 && currentValue == 0) {
                    return null;
                }
                ++numDigits;
                currentValue *= 10;
                if ((currentValue += c - 48) <= 255) continue;
                return null;
            }
            if (c == '.') {
                if (currentOctet == 3) {
                    return null;
                }
                if (numDigits == 0) {
                    return null;
                }
                values[currentOctet++] = (byte)currentValue;
                currentValue = 0;
                numDigits = 0;
                continue;
            }
            return null;
        }
        if (currentOctet != 3) {
            return null;
        }
        if (numDigits == 0) {
            return null;
        }
        values[currentOctet] = (byte)currentValue;
        return values;
    }

    static byte[] parseV6(String s) {
        int i;
        int range = -1;
        byte[] data = new byte[16];
        String[] tokens = s.split(":", -1);
        int first = 0;
        int last = tokens.length - 1;
        if (tokens[0].isEmpty()) {
            if (last - first > 0 && tokens[1].isEmpty()) {
                ++first;
            } else {
                return null;
            }
        }
        if (tokens[last].isEmpty()) {
            if (last - first > 0 && tokens[last - 1].isEmpty()) {
                --last;
            } else {
                return null;
            }
        }
        if (last - first + 1 > 8) {
            return null;
        }
        int j = 0;
        for (i = first; i <= last; ++i) {
            if (tokens[i].isEmpty()) {
                if (range >= 0) {
                    return null;
                }
                range = j;
                continue;
            }
            if (tokens[i].indexOf(46) >= 0) {
                if (i < last) {
                    return null;
                }
                if (i > 6) {
                    return null;
                }
                byte[] v4addr = Address.toByteArray(tokens[i], 1);
                if (v4addr == null) {
                    return null;
                }
                for (int k = 0; k < 4; ++k) {
                    data[j++] = v4addr[k];
                }
                break;
            }
            try {
                for (int k = 0; k < tokens[i].length(); ++k) {
                    char c = tokens[i].charAt(k);
                    if (Character.digit(c, 16) >= 0) continue;
                    return null;
                }
                int x = Integer.parseInt(tokens[i], 16);
                if (!Utils.isUInt16(x)) {
                    return null;
                }
                data[j++] = (byte)(x >>> 8);
                data[j++] = (byte)(x & 0xFF);
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (j < 16 && range < 0) {
            return null;
        }
        if (range >= 0) {
            int empty = 16 - j;
            System.arraycopy(data, range, data, range + empty, j - range);
            for (i = range; i < range + empty; ++i) {
                data[i] = 0;
            }
        }
        return data;
    }

    @Generated
    private IPAddressUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

