/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.rsa.host;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.ecf.mgmt.framework.ServiceReferenceMTO;
import org.eclipse.ecf.mgmt.framework.host.AbstractManager;
import org.eclipse.ecf.mgmt.rsa.EndpointDescriptionMTO;
import org.eclipse.ecf.mgmt.rsa.ExportReferenceMTO;
import org.eclipse.ecf.mgmt.rsa.ExportRegistrationMTO;
import org.eclipse.ecf.mgmt.rsa.IRemoteServiceAdminManager;
import org.eclipse.ecf.mgmt.rsa.ImportReferenceMTO;
import org.eclipse.ecf.mgmt.rsa.ImportRegistrationMTO;
import org.eclipse.ecf.mgmt.rsa.RemoteServiceAdminEventMTO;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.ExportRegistration;
import org.osgi.service.remoteserviceadmin.ImportRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminListener;

public class RemoteServiceAdminManager
extends AbstractManager
implements IRemoteServiceAdminManager,
RemoteServiceAdminListener {
    private org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin remoteServiceAdmin;
    private List<RemoteServiceAdmin.RemoteServiceAdminEvent> adminEvents;

    protected void bindRemoteServiceAdmin(RemoteServiceAdmin rsa) {
        this.remoteServiceAdmin = (org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin)rsa;
    }

    protected void unbindRemoteServiceAdmin(RemoteServiceAdmin rsa) {
        this.remoteServiceAdmin = null;
    }

    public void remoteAdminEvent(RemoteServiceAdminEvent event) {
        if (!(event instanceof RemoteServiceAdmin.RemoteServiceAdminEvent)) {
            return;
        }
        this.adminEvents.add((RemoteServiceAdmin.RemoteServiceAdminEvent)event);
    }

    protected void activate(BundleContext context) throws Exception {
        super.activate(context);
        this.adminEvents = Collections.synchronizedList(new ArrayList());
    }

    protected void deactivate() throws Exception {
        this.adminEvents.clear();
        super.deactivate();
    }

    protected RemoteServiceAdminEventMTO createEventMTO(RemoteServiceAdmin.RemoteServiceAdminEvent e) {
        EndpointDescription ed = e.getEndpointDescription();
        return new RemoteServiceAdminEventMTO(e.getType(), e.getSource().getBundleId(), e.getContainerID(), ed == null ? 0L : ed.getRemoteServiceId(), ed == null ? 0L : ed.getServiceId(), ed == null ? null : ed.getProperties(), e.getException());
    }

    protected ExportReferenceMTO createExportReferenceMTO(EndpointDescription ed) {
        return new ExportReferenceMTO(ed.getContainerID(), ed.getRemoteServiceId().longValue(), ed.getServiceId(), ed.getProperties());
    }

    protected ImportReferenceMTO createImportReferenceMTO(EndpointDescription ed) {
        return new ImportReferenceMTO(ed.getContainerID(), ed.getRemoteServiceId().longValue(), ed.getServiceId(), ed.getProperties());
    }

    protected ExportRegistrationMTO createExportRegistrationMTO(ExportRegistration er) {
        Throwable t = er.getException();
        if (t != null) {
            return new ExportRegistrationMTO(t);
        }
        EndpointDescription ed = (EndpointDescription)er.getExportReference().getExportedEndpoint();
        return new ExportRegistrationMTO(ed.getConnectTargetID(), ed.getServiceId(), ed.getServiceId(), ed.getProperties());
    }

    protected ImportRegistrationMTO createImportRegistrationMTO(ImportRegistration ir) {
        Throwable t = ir.getException();
        if (t != null) {
            return new ImportRegistrationMTO(t);
        }
        EndpointDescription ed = (EndpointDescription)ir.getImportReference().getImportedEndpoint();
        return new ImportRegistrationMTO(ed.getConnectTargetID(), ed.getServiceId(), ed.getServiceId(), ed.getProperties());
    }

    protected List<RemoteServiceAdminEvent> getEvents(boolean export) {
        return this.adminEvents.stream().filter(e -> e.getType() == 2 && e.getException() == null && (export && e.getExportReference() != null || !export && e.getImportReference() != null)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteServiceAdminEventMTO[] getRemoteServiceAdminEvents(int[] typeFilters) {
        ArrayList<RemoteServiceAdmin.RemoteServiceAdminEvent> events = new ArrayList<RemoteServiceAdmin.RemoteServiceAdminEvent>();
        List<RemoteServiceAdmin.RemoteServiceAdminEvent> list = this.adminEvents;
        synchronized (list) {
            events.addAll(this.adminEvents);
        }
        List<RemoteServiceAdminEventMTO> results = events.stream().filter(e -> {
            if (typeFilters == null) {
                return false;
            }
            boolean typeFound = false;
            int[] nArray2 = typeFilters;
            int n = typeFilters.length;
            int n2 = 0;
            while (n2 < n) {
                int f = nArray2[n2];
                if (e.getType() == f) {
                    typeFound = true;
                }
                ++n2;
            }
            return typeFound;
        }).map(e -> this.createEventMTO((RemoteServiceAdmin.RemoteServiceAdminEvent)e)).collect(Collectors.toList());
        return results.toArray(new RemoteServiceAdminEventMTO[results.size()]);
    }

    public ExportRegistrationMTO[] getExportedServices() {
        List<ExportRegistrationMTO> results = this.remoteServiceAdmin.getExportedRegistrations().stream().map(ereg -> this.createExportRegistrationMTO((ExportRegistration)ereg)).collect(Collectors.toList());
        return results.toArray(new ExportRegistrationMTO[results.size()]);
    }

    public ImportRegistrationMTO[] getImportedEndpoints() {
        List<ImportRegistrationMTO> results = this.remoteServiceAdmin.getImportedRegistrations().stream().map(ireg -> this.createImportRegistrationMTO((ImportRegistration)ireg)).collect(Collectors.toList());
        return results.toArray(new ImportRegistrationMTO[results.size()]);
    }

    public ExportRegistrationMTO[] exportService(ServiceReferenceMTO serviceReference, Map<String, ?> overridingProperties) {
        ServiceReference sr = this.findServiceReference(serviceReference.getId());
        if (sr == null) {
            return null;
        }
        Collection ers = this.remoteServiceAdmin.exportService(sr, overridingProperties);
        List<ExportRegistrationMTO> results = ers.stream().map(er -> this.createExportRegistrationMTO((ExportRegistration)er)).collect(Collectors.toList());
        return results.toArray(new ExportRegistrationMTO[results.size()]);
    }

    private ServiceReference findServiceReference(long serviceId) {
        ServiceReference[] srs = null;
        try {
            srs = this.getContext().getAllServiceReferences(null, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (srs != null) {
            ServiceReference[] serviceReferenceArray = srs;
            int n = srs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference sr = serviceReferenceArray[n2];
                Long svcId = (Long)sr.getProperty("service.id");
                if (serviceId == svcId) {
                    return sr;
                }
                ++n2;
            }
        }
        return null;
    }

    protected RemoteServiceAdmin.ExportRegistration findExportRegistration(ServiceReference<?> sr) {
        List results = this.select(this.remoteServiceAdmin.getExportedRegistrations(), er -> {
            RemoteServiceAdmin.ExportReference exRef = (RemoteServiceAdmin.ExportReference)er.getExportReference();
            if (exRef == null) {
                return false;
            }
            return sr.equals(exRef.getExportedService());
        });
        return results.size() == 0 ? null : (RemoteServiceAdmin.ExportRegistration)results.get(0);
    }

    protected RemoteServiceAdmin.ImportRegistration findImportRegistration(EndpointDescription ed) {
        List results = this.select(this.remoteServiceAdmin.getImportedRegistrations(), ir -> {
            RemoteServiceAdmin.ImportReference iRef = (RemoteServiceAdmin.ImportReference)ir.getImportReference();
            if (iRef == null) {
                return false;
            }
            return ed.equals((Object)iRef.getImportedEndpoint());
        });
        return results.size() == 0 ? null : (RemoteServiceAdmin.ImportRegistration)results.get(0);
    }

    protected RemoteServiceAdmin.ImportRegistration findImportRegistration(ServiceReference<?> sr) {
        List results = this.select(this.remoteServiceAdmin.getImportedRegistrations(), ir -> {
            RemoteServiceAdmin.ImportReference iRef = (RemoteServiceAdmin.ImportReference)ir.getImportReference();
            if (iRef == null) {
                return false;
            }
            return sr.equals(iRef.getImportedService());
        });
        return results.size() == 0 ? null : (RemoteServiceAdmin.ImportRegistration)results.get(0);
    }

    public EndpointDescriptionMTO updateExport(ExportReferenceMTO exportReference, Map<String, ?> properties) {
        ServiceReference sr = this.findServiceReference(exportReference.getExportedService());
        if (sr == null) {
            return null;
        }
        RemoteServiceAdmin.ExportRegistration exportRegistration = this.findExportRegistration(sr);
        if (exportRegistration == null) {
            return null;
        }
        EndpointDescription updated = (EndpointDescription)exportRegistration.update(properties);
        if (updated == null) {
            return null;
        }
        return new EndpointDescriptionMTO(updated.getProperties());
    }

    public boolean closeExport(ExportReferenceMTO exportReference) {
        ServiceReference sr = this.findServiceReference(exportReference.getExportedService());
        if (sr == null) {
            return false;
        }
        RemoteServiceAdmin.ExportRegistration exportRegistration = this.findExportRegistration(sr);
        if (exportRegistration == null) {
            return false;
        }
        exportRegistration.close();
        return true;
    }

    public ImportRegistrationMTO importService(EndpointDescriptionMTO endpointDescription) {
        ImportRegistration ir = this.remoteServiceAdmin.importService((org.osgi.service.remoteserviceadmin.EndpointDescription)new EndpointDescription(endpointDescription.getProperties()));
        return ir == null ? null : this.createImportRegistrationMTO(ir);
    }

    public boolean updateImport(EndpointDescriptionMTO endpoint) {
        EndpointDescription updateEd = new EndpointDescription(endpoint.getProperties());
        RemoteServiceAdmin.ImportRegistration importRegistration = this.findImportRegistration(updateEd);
        if (importRegistration == null) {
            return false;
        }
        return importRegistration.update((org.osgi.service.remoteserviceadmin.EndpointDescription)updateEd);
    }

    public boolean closeImport(ImportReferenceMTO importReference) {
        ServiceReference sr = this.findServiceReference(importReference.getImportedService());
        if (sr == null) {
            return false;
        }
        RemoteServiceAdmin.ImportRegistration importRegistration = this.findImportRegistration(sr);
        if (importRegistration == null) {
            return false;
        }
        importRegistration.close();
        return true;
    }

    public RemoteServiceAdminEventMTO[] getRemoteServiceAdminEvents() {
        return this.getRemoteServiceAdminEvents(null);
    }
}

