/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.eclipse.ecf.provider.util.IClassLoaderMapper;

public class IdentifiableObjectInputStream
extends ObjectInputStream {
    IClassLoaderMapper mapper;

    public IdentifiableObjectInputStream(IClassLoaderMapper map, InputStream ins) throws IOException {
        super(ins);
        this.mapper = map;
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = this.readUTF();
        if (name == null || this.mapper == null) {
            return super.resolveClass(desc);
        }
        ClassLoader cl = this.mapper.mapNameToClassLoader(name);
        if (cl == null) {
            return super.resolveClass(desc);
        }
        return Class.forName(desc.getName(), true, cl);
    }
}

