/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.AbstractHostContainerSelector;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IHostContainerSelector;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.SelectContainerException;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.osgi.framework.ServiceReference;

public class HostContainerSelector
extends AbstractHostContainerSelector
implements IHostContainerSelector {
    private static final boolean reuseExistingContainers = new Boolean(System.getProperty("org.eclipse.ecf.osgi.services.remoteserviceadmin.HostContainerSelector.reuseExistingContainers", "true"));
    private boolean autoCreateContainer = false;

    public HostContainerSelector(String[] defaultConfigTypes, boolean autoCreateContainer) {
        super(defaultConfigTypes);
        this.autoCreateContainer = autoCreateContainer;
    }

    @Override
    public synchronized IRemoteServiceContainer[] selectHostContainers(ServiceReference serviceReference, Map<String, Object> overridingProperties, String[] serviceExportedInterfaces, String[] serviceExportedConfigs, String[] serviceIntents) throws SelectContainerException {
        Collection rsContainers;
        this.trace("selectHostContainers", "serviceReference=" + String.valueOf(serviceReference) + ",overridingProperties=" + String.valueOf(overridingProperties) + ",exportedInterfaces=" + String.valueOf(serviceExportedInterfaces == null ? Collections.EMPTY_LIST : Arrays.asList(serviceExportedInterfaces)) + ",serviceExportedConfigs=" + String.valueOf(serviceExportedConfigs == null ? Collections.EMPTY_LIST : Arrays.asList(serviceExportedConfigs)) + ",serviceIntents=" + String.valueOf(serviceIntents == null ? Collections.EMPTY_LIST : Arrays.asList(serviceIntents)));
        Collection collection = rsContainers = reuseExistingContainers ? this.selectExistingHostContainers(serviceReference, overridingProperties, serviceExportedInterfaces, serviceExportedConfigs, serviceIntents) : Collections.EMPTY_LIST;
        if (rsContainers.size() == 0 && this.autoCreateContainer) {
            rsContainers = this.createAndConfigureHostContainers(serviceReference, overridingProperties, serviceExportedInterfaces, serviceExportedConfigs, serviceIntents);
            Object target = overridingProperties.get("ecf.endpoint.connecttarget.id");
            if (target != null) {
                Iterator i = rsContainers.iterator();
                while (i.hasNext()) {
                    IContainer container = ((IRemoteServiceContainer)i.next()).getContainer();
                    try {
                        this.connectHostContainer(serviceReference, overridingProperties, container, target);
                    }
                    catch (Exception e) {
                        this.logException("doConnectContainer failure containerID=" + String.valueOf(container.getID()) + " target=" + String.valueOf(target), e);
                    }
                }
            }
        }
        this.trace("selectHostContainers", "rsContainers selected=" + String.valueOf(rsContainers));
        return rsContainers.toArray(new IRemoteServiceContainer[rsContainers.size()]);
    }

    public void close() {
    }
}

