/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.impl;

import ch.ethz.iks.r_osgi.impl.CodeAnalyzer;
import ch.ethz.iks.r_osgi.impl.RemoteOSGiActivator;
import ch.ethz.iks.r_osgi.impl.RemoteOSGiServiceImpl;
import ch.ethz.iks.r_osgi.messages.DeliverServiceMessage;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import org.objectweb.asm.Type;
import org.osgi.framework.ServiceReference;

final class RemoteServiceRegistration {
    public static final String OSGI_ASYNC = "osgi.async";
    public static final String OSGI_BASIC_TIMEOUT = "osgi.basic.timeout";
    public static final long DEFAULT_TIMEOUT = Long.valueOf(System.getProperty("ch.ethz.iks.r_osgi.remoteservice.timeout", "30000"));
    private final ServiceReference reference;
    private final long serviceID;
    private final String[] interfaceNames;
    private final Object serviceObject;
    private final HashMap methodTable;
    private DeliverServiceMessage deliverServiceMessage;

    RemoteServiceRegistration(ServiceReference ref, ServiceReference service) throws ClassNotFoundException {
        block5: {
            this.methodTable = new HashMap(0);
            this.reference = service;
            this.serviceID = (Long)service.getProperty("service.id");
            this.interfaceNames = (String[])service.getProperty("objectClass");
            this.serviceObject = RemoteOSGiActivator.getActivator().getContext().getService(service);
            if (this.serviceObject == null) {
                throw new IllegalStateException("Service is not present.");
            }
            ClassLoader bundleLoader = this.serviceObject.getClass().getClassLoader();
            String[] interfaceNames = (String[])service.getProperty("objectClass");
            int interfaceCount = interfaceNames.length;
            Class[] serviceInterfaces = new Class[interfaceCount];
            int i = 0;
            while (i < interfaceCount) {
                serviceInterfaces[i] = bundleLoader.loadClass(interfaceNames[i]);
                Method[] methods = serviceInterfaces[i].getMethods();
                int j = 0;
                while (j < methods.length) {
                    this.methodTable.put(methods[j].getName() + Type.getMethodDescriptor((Method)methods[j]), methods[j]);
                    ++j;
                }
                ++i;
            }
            Dictionary headers = service.getBundle().getHeaders();
            CodeAnalyzer analyzer = new CodeAnalyzer(bundleLoader, (String)headers.get("Import-Package"), (String)headers.get("Export-Package"));
            try {
                this.deliverServiceMessage = analyzer.analyze(interfaceNames, (String)ref.getProperty("service.remote.smartproxy"), (String[])ref.getProperty("service.remote.injections"), (String)ref.getProperty("service.presentation"));
                this.deliverServiceMessage.setServiceID(((Long)ref.getProperty("service.id")).toString());
            }
            catch (Exception e) {
                if (RemoteOSGiServiceImpl.log == null) break block5;
                RemoteOSGiServiceImpl.log.log(1, "Error during remote service registration", (Throwable)e);
            }
        }
    }

    long getServiceID() {
        return this.serviceID;
    }

    ServiceReference getReference() {
        return this.reference;
    }

    boolean isOSGiAsync() {
        Object o = this.reference.getProperty(OSGI_ASYNC);
        if (o != null) {
            return true;
        }
        String[] serviceIntents = (String[])this.reference.getProperty("service.intents");
        return serviceIntents != null && Arrays.asList(serviceIntents).contains(OSGI_ASYNC);
    }

    long getOSGiTimeout() {
        long timeout = DEFAULT_TIMEOUT;
        Object timeoutval = this.reference.getProperty(OSGI_BASIC_TIMEOUT);
        if (timeoutval != null) {
            if (timeoutval instanceof Number) {
                timeout = ((Number)timeoutval).longValue();
            } else if (timeoutval instanceof String) {
                timeout = Long.valueOf((String)timeoutval);
            }
        }
        return timeout;
    }

    Dictionary getProperties() {
        String[] keys = this.reference.getPropertyKeys();
        Hashtable<String, Object> props = new Hashtable<String, Object>(keys.length);
        int i = 0;
        while (i < keys.length) {
            ((Dictionary)props).put(keys[i], this.reference.getProperty(keys[i]));
            ++i;
        }
        return props;
    }

    String[] getInterfaceNames() {
        return this.interfaceNames;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServiceReference) {
            ServiceReference ref = (ServiceReference)obj;
            return ref.equals(this.reference);
        }
        if (obj instanceof RemoteServiceRegistration) {
            return ((RemoteServiceRegistration)obj).equals(this.reference);
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.serviceID ^ this.serviceID >>> 32);
    }

    Object getServiceObject() {
        return this.serviceObject;
    }

    Method getMethod(String signature) {
        Method method = (Method)this.methodTable.get(signature);
        if (method == null && signature.startsWith("_rosgi")) {
            String newsig = signature.substring(6);
            String firstChar = newsig.substring(0, 1).toLowerCase();
            String correctedSig = newsig.substring(1);
            method = (Method)this.methodTable.get(firstChar + correctedSig);
        }
        return method;
    }

    DeliverServiceMessage getDeliverServiceMessage() {
        return this.deliverServiceMessage;
    }

    public String toString() {
        return "RemoteServiceRegistration{" + this.reference.toString() + "}";
    }
}

