/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsio;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.tools.workbench.mappingsio.FileNotFoundListener;
import org.eclipse.persistence.tools.workbench.mappingsio.ProjectIOManager;
import org.eclipse.persistence.tools.workbench.mappingsio.ReadOnlyFilesException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWNominative;
import org.eclipse.persistence.tools.workbench.mappingsmodel.ProjectSubFileComponentContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

class ProjectWriter {
    private ProjectIOManager ioManager;
    private MWProject project;
    private FileNotFoundListener listener;
    private SubComponentWriter[] subComponentWriters;
    private Collection changes;

    ProjectWriter(ProjectIOManager ioManager, MWProject project, FileNotFoundListener listener) {
        this.ioManager = ioManager;
        this.project = project;
        if (project.getSaveDirectory() == null) {
            throw new NullPointerException("The project's save directory must be set before it is written.");
        }
        this.listener = listener;
    }

    void write() throws ReadOnlyFilesException {
        this.subComponentWriters = this.buildSubComponentWriters();
        this.changes = this.buildProposedChanges();
        this.checkForReadOnlyFiles();
        this.commit();
        this.resetProject();
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.project.getName());
    }

    private SubComponentWriter[] buildSubComponentWriters() {
        return new SubComponentWriter[]{new SubComponentWriter(this.project.getClassRepository()), new SubComponentWriter(this.project.getMetaDataSubComponentContainer()), new SubComponentWriter(this.project.getDescriptorRepository())};
    }

    private Collection buildProposedChanges() {
        ArrayList<Write> proposedChanges = new ArrayList<Write>();
        if (this.project.hasChangedMainProjectSaveFile()) {
            proposedChanges.add(new Write(this.project, this.project.saveFile()));
        }
        for (int i = 0; i < this.subComponentWriters.length; ++i) {
            this.subComponentWriters[i].addChangesTo(proposedChanges);
        }
        return proposedChanges;
    }

    private void checkForReadOnlyFiles() throws ReadOnlyFilesException {
        ArrayList readOnlyFiles = new ArrayList(this.changes.size());
        for (Change change : this.changes) {
            change.addReadOnlyFilesTo(readOnlyFiles);
        }
        if (!readOnlyFiles.isEmpty()) {
            throw new ReadOnlyFilesException(readOnlyFiles);
        }
    }

    private void commit() {
        Iterator stream = this.changes.iterator();
        while (stream.hasNext()) {
            ((Change)stream.next()).commit();
        }
    }

    private void resetProject() {
        this.project.markEntireBranchClean();
        for (int i = 0; i < this.subComponentWriters.length; ++i) {
            this.subComponentWriters[i].resetContainer();
        }
    }

    File baseDirectory() {
        return this.project.getSaveDirectory();
    }

    XMLMarshaller marshaller() {
        return this.ioManager.getMarshaller();
    }

    String defaultFileNameExtension() {
        return this.ioManager.defaultFileNameExtension();
    }

    String subDirectoryNameFor(Object container) {
        return this.ioManager.subDirectoryNameFor(container);
    }

    void fireFileNotFound(File missingFile) {
        this.ioManager.fireFileNotFound(this.listener, missingFile);
    }

    private class Write
    extends Change {
        private Object object;

        Write(Object object, File file) {
            super(file);
            this.object = object;
        }

        void commit() {
            try {
                this.commit2();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void commit2() throws IOException {
            this.checkDirectory();
            if (this.file.exists()) {
                this.file.delete();
            }
            OutputStream stream = null;
            try {
                stream = new BufferedOutputStream(new FileOutputStream(this.file), 2048);
                this.marshaller().marshal(this.object, stream);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }

        private void checkDirectory() {
            File dir = this.file.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                throw new RuntimeException("unable to create directory: " + dir.getAbsolutePath());
            }
        }
    }

    private class Delete
    extends Change {
        Delete(File file) {
            super(file);
        }

        void commit() {
            if (this.file.exists()) {
                this.file.delete();
            } else {
                ProjectWriter.this.fireFileNotFound(this.file);
            }
        }
    }

    private abstract class Change {
        protected File file;

        Change(File file) {
            this.file = file;
        }

        void addReadOnlyFilesTo(Collection readOnlyFiles) {
            if (this.file.exists() && !this.file.canWrite()) {
                readOnlyFiles.add(this.file);
            }
        }

        abstract void commit();

        public String toString() {
            return StringTools.buildToStringFor(this, this.file);
        }

        XMLMarshaller marshaller() {
            return ProjectWriter.this.marshaller();
        }
    }

    private class SubComponentWriter {
        private ProjectSubFileComponentContainer container;

        SubComponentWriter(ProjectSubFileComponentContainer container) {
            this.container = container;
        }

        void addChangesTo(Collection proposedChanges) {
            String ext = ProjectWriter.this.defaultFileNameExtension();
            String subDirectoryName = ProjectWriter.this.subDirectoryNameFor(this.container);
            File subDirectory = new File(ProjectWriter.this.baseDirectory(), subDirectoryName);
            HashSet<String> currentNames = new HashSet<String>();
            HashSet<File> currentFiles = new HashSet<File>();
            Iterator stream = this.container.projectSubFileComponents();
            while (stream.hasNext()) {
                MWModel subComponent = (MWModel)stream.next();
                String subComponentName = ((MWNominative)((Object)subComponent)).getName();
                currentNames.add(subComponentName);
                String subComponentFileName = FileTools.FILE_NAME_ENCODER.encode(subComponentName);
                File subComponentFile = new File(subDirectory, subComponentFileName + ext);
                currentFiles.add(subComponentFile);
                if (!subComponent.isDirtyBranch()) continue;
                proposedChanges.add(new Write(subComponent, subComponentFile));
            }
            Set originalNames = CollectionTools.set(this.container.originalProjectSubFileComponentNames());
            Collection deletedNames = this.calculateDeleted(originalNames, currentNames);
            Iterator stream2 = deletedNames.iterator();
            while (stream2.hasNext()) {
                String deleteFileName = FileTools.FILE_NAME_ENCODER.encode((String)stream2.next());
                File deleteFile = new File(subDirectory, deleteFileName + ext);
                if (currentFiles.contains(deleteFile)) continue;
                proposedChanges.add(new Delete(deleteFile));
            }
        }

        private Collection calculateDeleted(Collection start, Collection end) {
            HashSet deleted = new HashSet(start);
            deleted.removeAll(end);
            return deleted;
        }

        void resetContainer() {
            HashSet<String> currentNames = new HashSet<String>();
            Iterator stream = this.container.projectSubFileComponents();
            while (stream.hasNext()) {
                currentNames.add(((MWNominative)stream.next()).getName());
            }
            this.container.setOriginalProjectSubFileComponentNames(currentNames);
        }
    }
}

