/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.db;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.ProjectSubFileComponentContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWLoginSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWLoginSpecHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalDatabaseFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalTableDescription;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWDatabase
extends MWModel
implements ProjectSubFileComponentContainer {
    private volatile DatabasePlatform databasePlatform;
    public static final String DATABASE_PLATFORM_PROPERTY = "databasePlatform";
    private Collection loginSpecs;
    public static final String LOGIN_SPECS_COLLECTION = "loginSpecs";
    private MWLoginSpecHandle deploymentLoginSpecHandle;
    public static final String DEPLOYMENT_LOGIN_SPEC_PROPERTY = "deploymentLoginSpec";
    private MWLoginSpecHandle developmentLoginSpecHandle;
    public static final String DEVELOPMENT_LOGIN_SPEC_PROPERTY = "developmentLoginSpec";
    private Collection tables;
    public static final String TABLES_COLLECTION = "tables";
    private volatile ExternalDatabase externalDatabase;
    private volatile Driver driver;
    private volatile Connection connection;
    public static final String CONNECTED_PROPERTY = "connected";
    private volatile SchemaManager schemaManager;
    private Collection tableNames;
    private static final String TABLE_NAMES_COLLECTION = "tableNames";
    private static final String SUB_DIRECTORY_NAME = "tables";

    private MWDatabase() {
    }

    public MWDatabase(MWRelationalProject project, DatabasePlatform databasePlatform) {
        super(project);
        this.databasePlatform = databasePlatform;
    }

    public void initialize() {
        super.initialize();
        this.tables = new Vector();
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.loginSpecs = new Vector();
        this.deploymentLoginSpecHandle = new MWLoginSpecHandle(this, MWHandle.NodeReferenceScrubber.NULL_INSTANCE);
        this.developmentLoginSpecHandle = new MWLoginSpecHandle(this, MWHandle.NodeReferenceScrubber.NULL_INSTANCE);
        this.tableNames = new HashSet();
    }

    public DatabasePlatform getDatabasePlatform() {
        return this.databasePlatform;
    }

    public void setDatabasePlatform(DatabasePlatform databasePlatform) {
        if (databasePlatform == null) {
            throw new NullPointerException();
        }
        DatabasePlatform old = this.databasePlatform;
        this.databasePlatform = databasePlatform;
        this.firePropertyChanged(DATABASE_PLATFORM_PROPERTY, old, databasePlatform);
        if (this.attributeValueHasChanged(old, databasePlatform)) {
            this.databasePlatformChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void databasePlatformChanged() {
        Collection collection = this.tables;
        synchronized (collection) {
            Iterator stream = this.tables.iterator();
            while (stream.hasNext()) {
                ((MWTable)stream.next()).databasePlatformChanged();
            }
        }
    }

    public Iterator loginSpecs() {
        return new CloneIterator(this.loginSpecs){

            protected void remove(Object current) {
                MWDatabase.this.removeLoginSpec((MWLoginSpec)current);
            }
        };
    }

    public int loginSpecsSize() {
        return this.loginSpecs.size();
    }

    public MWLoginSpec addLoginSpec(String loginSpecName) {
        this.checkLoginSpecName(loginSpecName);
        return this.addLoginSpec(new MWLoginSpec(this, loginSpecName));
    }

    private MWLoginSpec addLoginSpec(MWLoginSpec loginSpec) {
        this.addItemToCollection(loginSpec, this.loginSpecs, LOGIN_SPECS_COLLECTION);
        if (this.loginSpecs.size() == 1) {
            this.setDeploymentLoginSpec(loginSpec);
            this.setDevelopmentLoginSpec(loginSpec);
        }
        return loginSpec;
    }

    public void removeLoginSpec(MWLoginSpec loginSpec) {
        if (this.removeItemFromCollection(loginSpec, this.loginSpecs, LOGIN_SPECS_COLLECTION)) {
            this.loginSpecRemoved(loginSpec);
        }
    }

    public boolean containsLoginSpecNamed(String loginSpecName) {
        return this.loginSpecNamed(loginSpecName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWLoginSpec loginSpecNamed(String loginSpecName) {
        Collection collection = this.loginSpecs;
        synchronized (collection) {
            for (MWLoginSpec spec : this.loginSpecs) {
                if (!spec.getName().equals(loginSpecName)) continue;
                return spec;
            }
        }
        return null;
    }

    public Iterator loginSpecNames() {
        return new TransformationIterator(this.loginSpecs()){

            protected Object transform(Object next) {
                return ((MWLoginSpec)next).getName();
            }
        };
    }

    public MWLoginSpec getDeploymentLoginSpec() {
        return this.deploymentLoginSpecHandle.getLoginSpec();
    }

    public void setDeploymentLoginSpec(MWLoginSpec loginSpec) {
        MWLoginSpec old = this.deploymentLoginSpecHandle.getLoginSpec();
        this.deploymentLoginSpecHandle.setLoginSpec(loginSpec);
        this.firePropertyChanged(DEPLOYMENT_LOGIN_SPEC_PROPERTY, old, loginSpec);
    }

    public MWLoginSpec getDevelopmentLoginSpec() {
        return this.developmentLoginSpecHandle.getLoginSpec();
    }

    public void setDevelopmentLoginSpec(MWLoginSpec loginSpec) {
        MWLoginSpec old = this.developmentLoginSpecHandle.getLoginSpec();
        this.developmentLoginSpecHandle.setLoginSpec(loginSpec);
        this.firePropertyChanged(DEVELOPMENT_LOGIN_SPEC_PROPERTY, old, loginSpec);
    }

    public Iterator tables() {
        return new CloneIterator(this.tables){

            protected void remove(Object current) {
                MWDatabase.this.removeTable((MWTable)current);
            }
        };
    }

    public int tablesSize() {
        return this.tables.size();
    }

    public MWTable addTable(String shortName) {
        return this.addTable(null, shortName);
    }

    public MWTable addTable(String schema, String shortName) {
        return this.addTable(null, schema, shortName);
    }

    public MWTable addTable(String catalog, String schema, String shortName) {
        this.checkTableName(catalog, schema, shortName, null);
        return this.addTable(new MWTable(this, catalog, schema, shortName));
    }

    public MWTable addTableWithFullyQualifiedName(String fullyQualifiedName) {
        String[] parsedName = (String[])CollectionTools.removeAllOccurrences(fullyQualifiedName.split("\\."), (Object)"");
        if (parsedName.length == 3) {
            return this.addTable(parsedName[0], parsedName[1], parsedName[2]);
        }
        if (parsedName.length == 2) {
            return this.addTable(parsedName[0], parsedName[1]);
        }
        return this.addTable(parsedName[0]);
    }

    private MWTable addTable(MWTable table) {
        this.addItemToCollection(table, this.tables, "tables");
        return table;
    }

    public void removeTable(MWTable table) {
        this.removeNodeFromCollection(table, this.tables, "tables");
    }

    public boolean containsTableNamed(String catalog, String schema, String shortName) {
        return this.tableNamed(catalog, schema, shortName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWTable tableNamed(String catalog, String schema, String shortName) {
        Collection collection = this.tables;
        synchronized (collection) {
            for (MWTable table : this.tables) {
                if (!table.nameMatches(catalog, schema, shortName)) continue;
                return table;
            }
        }
        return null;
    }

    public boolean containsTableNamedIgnoreCase(String catalog, String schema, String shortName) {
        return this.tableNamedIgnoreCase(catalog, schema, shortName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWTable tableNamedIgnoreCase(String catalog, String schema, String shortName) {
        Collection collection = this.tables;
        synchronized (collection) {
            for (MWTable table : this.tables) {
                if (!table.nameMatchesIgnoreCase(catalog, schema, shortName)) continue;
                return table;
            }
        }
        return null;
    }

    public boolean containsTableNamed(String qualifiedName) {
        return this.tableNamed(qualifiedName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWTable tableNamed(String qualifiedName) {
        Collection collection = this.tables;
        synchronized (collection) {
            for (MWTable table : this.tables) {
                if (!table.qualifiedName().equals(qualifiedName)) continue;
                return table;
            }
        }
        return null;
    }

    public Iterator tableNames() {
        return new TransformationIterator(this.tables()){

            protected Object transform(Object next) {
                return ((MWTable)next).getName();
            }
        };
    }

    public MWColumn columnNamed(String qualifiedName) {
        MWTable table = this.tableNamed(MWColumn.parseTableNameFromQualifiedName(qualifiedName));
        if (table == null) {
            return null;
        }
        return table.columnNamed(MWColumn.parseColumnNameFromQualifiedName(qualifiedName));
    }

    private ExternalDatabase getExternalDatabase() {
        if (this.externalDatabase == null) {
            this.externalDatabase = this.buildExternalDatabase();
        }
        return this.externalDatabase;
    }

    private ExternalDatabase buildExternalDatabase() {
        return this.externalDatabaseFactory().buildDatabase(this.connection);
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    private SchemaManager getSchemaManager() {
        if (this.schemaManager == null) {
            throw new IllegalStateException("not connected");
        }
        return this.schemaManager;
    }

    private ExternalDatabaseFactory externalDatabaseFactory() {
        return this.getProject().getSPIManager().getExternalDatabaseFactory();
    }

    boolean supportsIdentityClause() {
        return this.databasePlatform.supportsIdentityClause();
    }

    protected void addTransientAspectNamesTo(Set transientAspectNames) {
        super.addTransientAspectNamesTo(transientAspectNames);
        transientAspectNames.add(CONNECTED_PROPERTY);
    }

    void checkLoginSpecName(String loginSpecName) {
        if (loginSpecName == null || loginSpecName.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (this.containsLoginSpecNamed(loginSpecName)) {
            throw new IllegalArgumentException("duplicate login spec name: " + loginSpecName);
        }
    }

    void checkTableName(String catalog, String schema, String shortName, MWTable table) {
        this.checkTableNameQualifier(catalog);
        this.checkTableNameQualifier(schema);
        if (shortName == null || shortName.length() == 0) {
            throw new IllegalArgumentException();
        }
        MWTable match = this.tableNamed(catalog, schema, shortName);
        if (match != null) {
            throw new IllegalArgumentException("duplicate table name: " + match.qualifiedName());
        }
        MWTable matchIgnoreCase = this.tableNamedIgnoreCase(catalog, schema, shortName);
        if (matchIgnoreCase != null && matchIgnoreCase != table) {
            throw new IllegalArgumentException("duplicate table name: " + matchIgnoreCase.qualifiedName());
        }
    }

    private void checkTableNameQualifier(String qualifier) {
        if (qualifier == null) {
            return;
        }
        if (qualifier.length() == 0) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Collection collection = this.loginSpecs;
        synchronized (collection) {
            children.addAll(this.loginSpecs);
        }
        children.add(this.deploymentLoginSpecHandle);
        children.add(this.developmentLoginSpecHandle);
        collection = this.tables;
        synchronized (collection) {
            children.addAll(this.tables);
        }
    }

    private void loginSpecRemoved(MWLoginSpec loginSpec) {
        if (this.getDeploymentLoginSpec() == loginSpec) {
            this.setDeploymentLoginSpec(null);
        }
        if (this.getDevelopmentLoginSpec() == loginSpec) {
            this.setDevelopmentLoginSpec(null);
        }
    }

    public void nodeRemoved(Node node) {
        if (node.isDescendantOf(this)) {
            super.nodeRemoved(node);
        }
    }

    public void nodeRenamed(Node node) {
        if (node.isDescendantOf(this)) {
            super.nodeRenamed(node);
        }
    }

    void tableRenamed() {
        this.fireCollectionChanged(TABLE_NAMES_COLLECTION);
    }

    public void mappingReplaced(MWMapping oldMapping, MWMapping newMapping) {
    }

    public void descriptorReplaced(MWDescriptor oldDescriptor, MWDescriptor newDescriptor) {
    }

    public void descriptorUnmapped(Collection mappings) {
    }

    public void login() throws SQLException, ClassNotFoundException {
        String password;
        if (this.isConnected()) {
            throw new IllegalStateException("already connected");
        }
        MWLoginSpec loginSpec = this.getDevelopmentLoginSpec();
        if (loginSpec == null) {
            throw new IllegalStateException("missing development login spec");
        }
        try {
            this.driver = loginSpec.buildDriver();
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        String url = loginSpec.getURL();
        if (url == null || url.length() == 0) {
            throw new IllegalStateException("missing database URL");
        }
        Properties props = new Properties();
        String userName = loginSpec.getUserName();
        if (userName != null) {
            props.put("user", userName);
        }
        if ((password = loginSpec.getPassword()) != null) {
            props.put("password", password);
        }
        this.connection = this.driver.connect(url, props);
        this.schemaManager = this.buildSchemaManager();
        this.firePropertyChanged(CONNECTED_PROPERTY, false, true);
    }

    public void logout() throws SQLException {
        if (!this.isConnected()) {
            throw new IllegalStateException("not connected");
        }
        this.connection.close();
        this.schemaManager = null;
        this.connection = null;
        this.driver = null;
        this.externalDatabase = null;
        this.firePropertyChanged(CONNECTED_PROPERTY, true, false);
    }

    private SchemaManager buildSchemaManager() {
        return new SchemaManager(this.buildRuntimeDatabaseSession());
    }

    private DatabaseSession buildRuntimeDatabaseSession() {
        DatabaseSession session = this.buildRuntimeProject().createDatabaseSession();
        session.dontLogMessages();
        session.login();
        return session;
    }

    private Project buildRuntimeProject() {
        return new Project(this.getDevelopmentLoginSpec().buildDevelopmentRuntimeDatabaseLogin());
    }

    Connector buildRuntimeConnector() {
        return new LocalConnectorAdapter(this.connection);
    }

    public Iterator catalogNames() {
        return new ArrayIterator(this.getExternalDatabase().getCatalogNames());
    }

    public Iterator schemaNames() {
        return new ArrayIterator(this.getExternalDatabase().getSchemaNames());
    }

    public Iterator tableTypeNames() {
        return new ArrayIterator(this.getExternalDatabase().getTableTypeNames());
    }

    public Iterator externalTableDescriptions(String catalog, String schemaPattern, String tableNamePattern, String[] types) {
        return new ArrayIterator(this.getExternalDatabase().getTableDescriptions(catalog, schemaPattern, tableNamePattern, types));
    }

    public Iterator externalTableDescriptions() {
        return new ArrayIterator(this.getExternalDatabase().getTableDescriptions());
    }

    public void importQualifiedTablesFor(Collection externalTableDescriptions) {
        for (ExternalTableDescription externalTableDescription : externalTableDescriptions) {
            this.qualifiedTableFor(externalTableDescription).refreshColumns(externalTableDescription.getTable());
        }
        for (ExternalTableDescription externalTableDescription : externalTableDescriptions) {
            this.qualifiedTableFor(externalTableDescription).refreshReferences(externalTableDescription.getTable());
        }
    }

    public void refreshQualifiedTablesFor(Collection externalTableDescriptions) {
        MWTable tableToRefresh;
        for (ExternalTableDescription externalTableDescription : externalTableDescriptions) {
            tableToRefresh = this.tableNamed(externalTableDescription.getQualifiedName());
            if (tableToRefresh == null) {
                tableToRefresh = this.tableNamed(externalTableDescription.getName());
            }
            if (tableToRefresh == null) continue;
            tableToRefresh.refreshColumns(externalTableDescription.getTable());
        }
        for (ExternalTableDescription externalTableDescription : externalTableDescriptions) {
            tableToRefresh = this.tableNamed(externalTableDescription.getQualifiedName());
            if (tableToRefresh == null) {
                tableToRefresh = this.tableNamed(externalTableDescription.getName());
            }
            if (tableToRefresh == null) continue;
            tableToRefresh.refreshReferences(externalTableDescription.getTable());
        }
    }

    private MWTable qualifiedTableFor(ExternalTableDescription externalTableDescription) {
        return this.tableNamedForImport(externalTableDescription.getCatalogName(), externalTableDescription.getSchemaName(), externalTableDescription.getName());
    }

    private MWTable tableNamedForImport(String catalog, String schema, String shortName) {
        MWTable table = this.tableNamed(catalog, schema, shortName);
        if (table == null) {
            table = this.addTable(catalog, schema, shortName);
        }
        return table;
    }

    public void importUnqualifiedTablesFor(Collection externalTableDescriptions) {
        for (ExternalTableDescription externalTableDescription : externalTableDescriptions) {
            this.unqualifiedTableFor(externalTableDescription).refreshColumns(externalTableDescription.getTable());
        }
        for (ExternalTableDescription externalTableDescription : externalTableDescriptions) {
            this.unqualifiedTableFor(externalTableDescription).refreshReferences(externalTableDescription.getTable());
        }
    }

    private MWTable unqualifiedTableFor(ExternalTableDescription externalTableDescription) {
        return this.tableNamedForImport(null, null, externalTableDescription.getName());
    }

    private String runtimePlatformClassName() {
        return this.getDatabasePlatform().getRuntimePlatformClassName();
    }

    public DatabaseLogin buildDeploymentRuntimeDatabaseLogin() {
        MWLoginSpec deploySpec = this.getDeploymentLoginSpec();
        if (deploySpec == null) {
            DatabaseLogin login = new DatabaseLogin();
            login.setPlatformClassName(this.runtimePlatformClassName());
            return login;
        }
        return deploySpec.buildDeploymentRuntimeDatabaseLogin();
    }

    public Iterator runtimeTableDefinitions() {
        return new TransformationIterator(this.tables()){

            protected Object transform(Object next) {
                return ((MWTable)next).buildRuntimeTableDefinition();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateTables() {
        ArrayList tablesCopy;
        Collection collection = this.tables;
        synchronized (collection) {
            tablesCopy = new ArrayList(this.tables);
        }
        this.generateTables(tablesCopy);
    }

    public void generateTables(Collection selectedTables) throws EclipseLinkException {
        this.getSchemaManager().outputDDLToDatabase();
        this.buildTables(selectedTables);
    }

    public String ddlFor(Collection selectedTables) {
        StringWriter writer = new StringWriter(2000);
        this.writeDDLOn(selectedTables, writer);
        return ((Object)writer).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDDLOn(Writer writer) {
        ArrayList tablesCopy;
        Collection collection = this.tables;
        synchronized (collection) {
            tablesCopy = new ArrayList(this.tables);
        }
        this.writeDDLOn(tablesCopy, writer);
    }

    public void writeDDLOn(Collection selectedTables, Writer writer) {
        this.getSchemaManager().outputDDLToWriter(writer);
        this.buildTables(selectedTables);
    }

    private void buildTables(Collection selectedTables) throws EclipseLinkException {
        ArrayList<TableDefinition> runtimeTableDefs = new ArrayList<TableDefinition>(selectedTables.size());
        Iterator stream = selectedTables.iterator();
        while (stream.hasNext()) {
            runtimeTableDefs.add(((MWTable)stream.next()).buildRuntimeTableDefinition());
        }
        SchemaManager sm = this.getSchemaManager();
        Iterator stream2 = runtimeTableDefs.iterator();
        while (stream2.hasNext()) {
            sm.replaceObject((DatabaseObjectDefinition)((TableDefinition)stream2.next()));
        }
        stream2 = runtimeTableDefs.iterator();
        while (stream2.hasNext()) {
            sm.createConstraints((TableDefinition)stream2.next());
        }
    }

    public void toString(StringBuffer sb) {
        sb.append(this.getDatabasePlatform().getName());
        sb.append(" : ");
        sb.append(this.tables.size());
        sb.append(" tables");
    }

    public String displayString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Database (");
        sb.append(this.getDatabasePlatform().getName());
        sb.append(")");
        return sb.toString();
    }

    public Iterator projectSubFileComponents() {
        return this.tables();
    }

    public void setProjectSubFileComponents(Collection subComponents) {
        this.tables = subComponents;
    }

    public Iterator originalProjectSubFileComponentNames() {
        return this.tableNames.iterator();
    }

    public void setOriginalProjectSubFileComponentNames(Collection originalSubComponentNames) {
        this.tableNames = originalSubComponentNames;
    }

    public boolean hasChangedMainProjectSaveFile() {
        if (this.isDirty()) {
            return true;
        }
        Iterator stream = this.children();
        while (stream.hasNext()) {
            if (!this.childHasChangedTheProjectSaveFile(stream.next())) continue;
            return true;
        }
        return false;
    }

    private boolean childHasChangedTheProjectSaveFile(Object child) {
        if (this.tables.contains(child)) {
            return false;
        }
        return ((Node)child).isDirtyBranch();
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWDatabase.class);
        descriptor.addDirectMapping("databasePlatformName", "getDatabasePlatformNameForTopLink", "setDatabasePlatformNameForTopLink", "platform-name/text()");
        XMLCompositeCollectionMapping loginSpecsMapping = new XMLCompositeCollectionMapping();
        loginSpecsMapping.setAttributeName(LOGIN_SPECS_COLLECTION);
        loginSpecsMapping.setGetMethodName("getLoginSpecsForTopLink");
        loginSpecsMapping.setSetMethodName("setLoginSpecsForTopLink");
        loginSpecsMapping.setReferenceClass(MWLoginSpec.class);
        loginSpecsMapping.setXPath("login-infos/login-info");
        descriptor.addMapping((DatabaseMapping)loginSpecsMapping);
        XMLCompositeObjectMapping deploymentLoginSpecMapping = new XMLCompositeObjectMapping();
        deploymentLoginSpecMapping.setAttributeName("deploymentLoginSpecHandle");
        deploymentLoginSpecMapping.setGetMethodName("getDeploymentLoginSpecHandleForTopLink");
        deploymentLoginSpecMapping.setSetMethodName("setDeploymentLoginSpecHandleForTopLink");
        deploymentLoginSpecMapping.setReferenceClass(MWLoginSpecHandle.class);
        deploymentLoginSpecMapping.setXPath("deployment-login-spec-handle");
        descriptor.addMapping((DatabaseMapping)deploymentLoginSpecMapping);
        XMLCompositeObjectMapping developmentLoginSpecMapping = new XMLCompositeObjectMapping();
        developmentLoginSpecMapping.setAttributeName("developmentLoginSpecHandle");
        developmentLoginSpecMapping.setGetMethodName("getDevelopmentLoginSpecHandleForTopLink");
        developmentLoginSpecMapping.setSetMethodName("setDevelopmentLoginSpecHandleForTopLink");
        developmentLoginSpecMapping.setReferenceClass(MWLoginSpecHandle.class);
        developmentLoginSpecMapping.setXPath("development-login-spec-handle");
        descriptor.addMapping((DatabaseMapping)developmentLoginSpecMapping);
        XMLCompositeDirectCollectionMapping tableNamesMapping = new XMLCompositeDirectCollectionMapping();
        tableNamesMapping.setAttributeName(TABLE_NAMES_COLLECTION);
        tableNamesMapping.setGetMethodName("getTableNamesForTopLink");
        tableNamesMapping.setSetMethodName("setTableNamesForTopLink");
        tableNamesMapping.useCollectionClass(HashSet.class);
        tableNamesMapping.setXPath("table-names/name/text()");
        descriptor.addMapping((DatabaseMapping)tableNamesMapping);
        return descriptor;
    }

    private String getDatabasePlatformNameForTopLink() {
        return this.databasePlatform.getName();
    }

    private void setDatabasePlatformNameForTopLink(String databasePlatformName) {
        this.databasePlatform = DatabasePlatformRepository.getDefault().platformNamed(databasePlatformName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getLoginSpecsForTopLink() {
        Collection collection = this.loginSpecs;
        synchronized (collection) {
            return new TreeSet(this.loginSpecs);
        }
    }

    private void setLoginSpecsForTopLink(Collection loginSpecs) {
        this.loginSpecs = loginSpecs;
    }

    private MWLoginSpecHandle getDeploymentLoginSpecHandleForTopLink() {
        return this.deploymentLoginSpecHandle.getLoginSpec() == null ? null : this.deploymentLoginSpecHandle;
    }

    private void setDeploymentLoginSpecHandleForTopLink(MWLoginSpecHandle deploymentLoginSpecHandle) {
        MWHandle.NodeReferenceScrubber scrubber = MWHandle.NodeReferenceScrubber.NULL_INSTANCE;
        this.deploymentLoginSpecHandle = deploymentLoginSpecHandle == null ? new MWLoginSpecHandle(this, scrubber) : deploymentLoginSpecHandle.setScrubber(scrubber);
    }

    private MWLoginSpecHandle getDevelopmentLoginSpecHandleForTopLink() {
        return this.developmentLoginSpecHandle.getLoginSpec() == null ? null : this.developmentLoginSpecHandle;
    }

    private void setDevelopmentLoginSpecHandleForTopLink(MWLoginSpecHandle developmentLoginSpecHandle) {
        MWHandle.NodeReferenceScrubber scrubber = MWHandle.NodeReferenceScrubber.NULL_INSTANCE;
        this.developmentLoginSpecHandle = developmentLoginSpecHandle == null ? new MWLoginSpecHandle(this, scrubber) : developmentLoginSpecHandle.setScrubber(scrubber);
    }

    private Collection getTableNamesForTopLink() {
        ArrayList names = new ArrayList(this.tables.size());
        CollectionTools.addAll(names, this.tableNames());
        return CollectionTools.sort(names, (Comparator)Collator.getInstance());
    }

    private void setTableNamesForTopLink(Collection tableNames) {
        this.tableNames = tableNames;
    }

    private static class LocalConnectorAdapter
    implements Connector {
        private Connection connection;

        LocalConnectorAdapter(Connection connection) {
            this.connection = connection;
        }

        public Connection connect(Properties properties, Session session) {
            return this.connection;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new InternalError();
            }
        }

        public String getConnectionDetails() {
            return "MWDatabase.LocalConnectorAdapter";
        }

        public void toString(PrintWriter writer) {
            writer.print(this.getConnectionDetails());
        }
    }
}

