/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.internal.identitymaps.HardCacheWeakIdentityMap;
import org.eclipse.persistence.internal.identitymaps.NoIdentityMap;
import org.eclipse.persistence.internal.identitymaps.SoftCacheWeakIdentityMap;
import org.eclipse.persistence.internal.identitymaps.SoftIdentityMap;
import org.eclipse.persistence.internal.identitymaps.WeakIdentityMap;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOptionSet;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCacheExpiry;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorCacheExpiry;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWProjectDefaultCacheExpiry;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWDescriptorCachingPolicy
extends MWModel
implements MWCachingPolicy {
    private volatile MWCachingPolicy.CacheCoordinationOption cacheCoordination;
    private static TopLinkOptionSet cacheCoordinationOptions;
    private volatile MWCachingPolicy.CacheIsolationOption cacheIsolation;
    private static TopLinkOptionSet cacheIsolationOptions;
    private volatile CacheTypeHolder cacheTypeHolder;
    public static final String CACHE_TYPE_HOLDER_PROPERTY = "cacheTypeHolder";
    private static TopLinkOptionSet cacheTypeOptions;
    public static final String DESCRIPTOR_INHERITANCE_PROPERTY = "descriptorInheritance";
    private volatile MWCachingPolicy.ExistenceCheckingOption existenceChecking;
    private static TopLinkOptionSet existenceCheckingOptions;
    private volatile CacheSizeHolder cacheSizeHolder;
    public static final String CACHE_SIZE_HOLDER_PROPERTY = "cacheSizeHolder";
    public static final String USE_PROJECT_DEFAULT_CACHE_SIZE_PROPERTY = "useProjectDefaultCacheSize";
    private volatile MWCacheExpiry cacheExpiry;
    public static final String CACHE_EXPIRY_PROPERTY = "cacheExpiry";
    public static final MWCachingPolicy.CacheTypeOption PROJECT_DEFAULT_CACHE_TYPE;

    public static synchronized TopLinkOptionSet cacheTypeOptions() {
        if (cacheTypeOptions == null) {
            ArrayList<MWCachingPolicy.CacheTypeOption> list = new ArrayList<MWCachingPolicy.CacheTypeOption>();
            list.add(PROJECT_DEFAULT_CACHE_TYPE);
            list.add(new MWCachingPolicy.CacheTypeOption("Weak with Soft subcache", "CACHING_POLICY_CACHE_TYPE_WEAK_WITH_SOFT_SUBCACHE", SoftCacheWeakIdentityMap.class.getName()));
            list.add(new MWCachingPolicy.CacheTypeOption("Weak with Hard Subcache", "CACHING_POLICY_CACHE_TYPE_WEAK_WITH_HARD_SUBCACHE", HardCacheWeakIdentityMap.class.getName()));
            list.add(new MWCachingPolicy.CacheTypeOption("Weak", "CACHING_POLICY_CACHE_TYPE_WEAK", WeakIdentityMap.class.getName()));
            list.add(new MWCachingPolicy.CacheTypeOption("Soft", "CACHING_POLICY_CACHE_TYPE_SOFT", SoftIdentityMap.class.getName()));
            list.add(new MWCachingPolicy.CacheTypeOption("Full", "CACHING_POLICY_CACHE_TYPE_FULL", FullIdentityMap.class.getName()));
            list.add(new MWCachingPolicy.CacheTypeOption("None", "CACHING_POLICY_CACHE_TYPE_NONE", NoIdentityMap.class.getName()));
            cacheTypeOptions = new TopLinkOptionSet(list);
        }
        return cacheTypeOptions;
    }

    public static synchronized TopLinkOptionSet existenceCheckingOptions() {
        if (existenceCheckingOptions == null) {
            ArrayList<MWCachingPolicy.ExistenceCheckingOption> list = new ArrayList<MWCachingPolicy.ExistenceCheckingOption>();
            list.add(new MWCachingPolicy.ExistenceCheckingOption("DEFAULT", "CACHING_POLICY_DEFAULT_VALUE", 0));
            list.add(new MWCachingPolicy.ExistenceCheckingOption("Check cache", "CACHING_POLICY_EXISTENCE_CHECKING_CHECK_CACHE", 3));
            list.add(new MWCachingPolicy.ExistenceCheckingOption("Check database", "CACHING_POLICY_EXISTENCE_CHECKING_CHECK_DATABASE", 4));
            list.add(new MWCachingPolicy.ExistenceCheckingOption("Assume existence", "CACHING_POLICY_EXISTENCE_CHECKING_ASSUME_EXISTENCE", 2));
            list.add(new MWCachingPolicy.ExistenceCheckingOption("Assume non-existence", "CACHING_POLICY_EXISTENCE_CHECKING_ASSUME_NON_EXISTENCE", 1));
            existenceCheckingOptions = new TopLinkOptionSet(list);
        }
        return existenceCheckingOptions;
    }

    public static synchronized TopLinkOptionSet cacheCoordinationOptions() {
        if (cacheCoordinationOptions == null) {
            ArrayList<MWCachingPolicy.CacheCoordinationOption> list = new ArrayList<MWCachingPolicy.CacheCoordinationOption>();
            list.add(new MWCachingPolicy.CacheCoordinationOption("DEFAULT", "CACHING_POLICY_DEFAULT_VALUE", 0));
            list.add(new MWCachingPolicy.CacheCoordinationOption("None", "CACHING_POLICY_CACHE_COORDINATION_NONE", 4));
            list.add(new MWCachingPolicy.CacheCoordinationOption("Synchronize Changes", "CACHING_POLICY_CACHE_COORDINATION_SYNCHRONIZE_CHANGES", 1));
            list.add(new MWCachingPolicy.CacheCoordinationOption("Synchronize Changes and New Objects", "CACHING_POLICY_CACHE_COORDINATION_SYNCHRONIZE_CHANGES_AND_NEW_OBJECTS", 3));
            list.add(new MWCachingPolicy.CacheCoordinationOption("Invalidate Changed Objects", "CACHING_POLICY_CACHE_COORDINATION_INVALIDATE_CHANGED_OBJECTS", 2));
            cacheCoordinationOptions = new TopLinkOptionSet(list);
        }
        return cacheCoordinationOptions;
    }

    public static synchronized TopLinkOptionSet cacheIsolationOptions() {
        if (cacheIsolationOptions == null) {
            ArrayList<MWCachingPolicy.CacheIsolationOption> list = new ArrayList<MWCachingPolicy.CacheIsolationOption>();
            list.add(new MWCachingPolicy.CacheIsolationOption("DEFAULT", "CACHING_POLICY_DEFAULT_VALUE"));
            list.add(new MWCachingPolicy.CacheIsolationOption("Isolated", "CACHING_POLICY_CACHE_ISOLATION_ISOLATED"));
            list.add(new MWCachingPolicy.CacheIsolationOption("Shared", "CACHING_POLICY_CACHE_ISOLATION_SHARED"));
            cacheIsolationOptions = new TopLinkOptionSet(list);
        }
        return cacheIsolationOptions;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWDescriptorCachingPolicy.class);
        XMLDirectMapping cacheSizeMapping = new XMLDirectMapping();
        cacheSizeMapping.setAttributeName(CACHE_SIZE_HOLDER_PROPERTY);
        cacheSizeMapping.setGetMethodName("getCacheSizeForTopLink");
        cacheSizeMapping.setSetMethodName("setCacheSizeForTopLink");
        cacheSizeMapping.setXPath("cache-size/text()");
        cacheSizeMapping.setNullValue((Object)new Integer(-1));
        descriptor.addMapping((DatabaseMapping)cacheSizeMapping);
        XMLDirectMapping cacheTypeMapping = (XMLDirectMapping)descriptor.addDirectMapping(CACHE_TYPE_HOLDER_PROPERTY, "getCacheTypeForTopLink", "setCacheTypeForTopLink", "cache-type/text()");
        ObjectTypeConverter cacheTypeConverter = new ObjectTypeConverter();
        MWDescriptorCachingPolicy.cacheTypeOptions().addConversionValuesForTopLinkTo(cacheTypeConverter);
        cacheTypeMapping.setConverter((Converter)cacheTypeConverter);
        cacheTypeMapping.setNullValue((Object)MWDescriptorCachingPolicy.cacheTypeOptions().topLinkOptionForMWModelOption("DEFAULT"));
        ObjectTypeConverter existenceCheckingConverter = new ObjectTypeConverter();
        MWDescriptorCachingPolicy.existenceCheckingOptions().addConversionValuesForTopLinkTo(existenceCheckingConverter);
        XMLDirectMapping existenceCheckingMapping = new XMLDirectMapping();
        existenceCheckingMapping.setAttributeName("existenceChecking");
        existenceCheckingMapping.setXPath("existence-checking/text()");
        existenceCheckingMapping.setNullValue((Object)MWDescriptorCachingPolicy.existenceCheckingOptions().topLinkOptionForMWModelOption("DEFAULT"));
        existenceCheckingMapping.setConverter((Converter)existenceCheckingConverter);
        descriptor.addMapping((DatabaseMapping)existenceCheckingMapping);
        ObjectTypeConverter cacheCoordinationConverter = new ObjectTypeConverter();
        MWDescriptorCachingPolicy.cacheCoordinationOptions().addConversionValuesForTopLinkTo(cacheCoordinationConverter);
        XMLDirectMapping cacheCoordinationMapping = new XMLDirectMapping();
        cacheCoordinationMapping.setAttributeName("cacheCoordination");
        cacheCoordinationMapping.setXPath("cache-coordination/text()");
        cacheCoordinationMapping.setConverter((Converter)cacheCoordinationConverter);
        cacheCoordinationMapping.setNullValue((Object)MWDescriptorCachingPolicy.cacheCoordinationOptions().topLinkOptionForMWModelOption("DEFAULT"));
        descriptor.addMapping((DatabaseMapping)cacheCoordinationMapping);
        ObjectTypeConverter cacheIsolationConverter = new ObjectTypeConverter();
        MWDescriptorCachingPolicy.cacheIsolationOptions().addConversionValuesForTopLinkTo(cacheIsolationConverter);
        XMLDirectMapping cacheIsolationMapping = new XMLDirectMapping();
        cacheIsolationMapping.setAttributeName("cacheIsolation");
        cacheIsolationMapping.setXPath("cache-isolation/text()");
        cacheIsolationMapping.setConverter((Converter)cacheIsolationConverter);
        cacheIsolationMapping.setNullValue((Object)MWDescriptorCachingPolicy.cacheIsolationOptions().topLinkOptionForMWModelOption("DEFAULT"));
        descriptor.addMapping((DatabaseMapping)cacheIsolationMapping);
        XMLCompositeObjectMapping cacheExpiryMapping = new XMLCompositeObjectMapping();
        cacheExpiryMapping.setAttributeName(CACHE_EXPIRY_PROPERTY);
        cacheExpiryMapping.setReferenceClass(MWDescriptorCacheExpiry.class);
        cacheExpiryMapping.setGetMethodName("getCacheExpiryForTopLink");
        cacheExpiryMapping.setSetMethodName("setCacheExpiryForTopLink");
        cacheExpiryMapping.setXPath("cache-expiry");
        descriptor.addMapping((DatabaseMapping)cacheExpiryMapping);
        return descriptor;
    }

    private MWDescriptorCachingPolicy() {
    }

    public MWDescriptorCachingPolicy(MWTransactionalPolicy parent) {
        super(parent);
    }

    protected void initialize() {
        super.initialize();
        this.cacheSizeHolder = new CacheSizeHolderImpl();
        this.cacheTypeHolder = new CacheTypeHolderImpl();
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.cacheCoordination = (MWCachingPolicy.CacheCoordinationOption)MWDescriptorCachingPolicy.cacheCoordinationOptions().topLinkOptionForMWModelOption("DEFAULT");
        this.cacheIsolation = (MWCachingPolicy.CacheIsolationOption)MWDescriptorCachingPolicy.cacheIsolationOptions().topLinkOptionForMWModelOption("DEFAULT");
        this.existenceChecking = (MWCachingPolicy.ExistenceCheckingOption)MWDescriptorCachingPolicy.existenceCheckingOptions().topLinkOptionForMWModelOption("DEFAULT");
        this.cacheExpiry = new MWProjectDefaultCacheExpiry(this);
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.cacheExpiry);
    }

    public void initializeFrom(MWCachingPolicy otherPolicy) {
        this.setCacheCoordination(otherPolicy.getCacheCoordination());
        this.setCacheIsolation(otherPolicy.getCacheIsolation());
        this.setCacheSize(otherPolicy.getCacheSize());
        this.setCacheType(otherPolicy.getCacheType());
        this.setExistenceChecking(otherPolicy.getExistenceChecking());
    }

    public MWMappingDescriptor getOwningDescriptor() {
        return (MWMappingDescriptor)((MWTransactionalPolicy)this.getParent()).getParent();
    }

    public MWCachingPolicy.ExistenceCheckingOption getExistenceChecking() {
        return this.existenceChecking;
    }

    public void setExistenceChecking(MWCachingPolicy.ExistenceCheckingOption newExistenceChecking) {
        MWCachingPolicy.ExistenceCheckingOption old = this.existenceChecking;
        this.existenceChecking = newExistenceChecking;
        this.firePropertyChanged("existenceChecking", old, this.existenceChecking);
    }

    public void setExistenceChecking(String existenceChecking) {
        this.setExistenceChecking((MWCachingPolicy.ExistenceCheckingOption)MWDescriptorCachingPolicy.existenceCheckingOptions().topLinkOptionForMWModelOption(existenceChecking));
    }

    public MWCachingPolicy.CacheCoordinationOption getCacheCoordination() {
        return this.cacheCoordination;
    }

    public void setCacheCoordination(MWCachingPolicy.CacheCoordinationOption cacheCoordination) {
        MWCachingPolicy.CacheCoordinationOption oldCacheCoordination = this.cacheCoordination;
        this.cacheCoordination = cacheCoordination;
        this.firePropertyChanged("cacheCoordination", oldCacheCoordination, cacheCoordination);
    }

    public MWCachingPolicy.CacheIsolationOption getCacheIsolation() {
        return this.cacheIsolation;
    }

    public void setCacheIsolation(MWCachingPolicy.CacheIsolationOption cacheIsolation) {
        MWCachingPolicy.CacheIsolationOption oldCacheIsolation = this.cacheIsolation;
        this.cacheIsolation = cacheIsolation;
        this.firePropertyChanged("cacheIsolation", oldCacheIsolation, cacheIsolation);
        if (cacheIsolation.getMWModelOption() == "Isolated") {
            this.setCacheCoordination((MWCachingPolicy.CacheCoordinationOption)MWDescriptorCachingPolicy.cacheCoordinationOptions().topLinkOptionForMWModelOption("None"));
        } else if (cacheIsolation.getMWModelOption() == "DEFAULT") {
            this.setCacheCoordination((MWCachingPolicy.CacheCoordinationOption)MWDescriptorCachingPolicy.cacheCoordinationOptions().topLinkOptionForMWModelOption("DEFAULT"));
        }
    }

    public CacheTypeHolder getCacheTypeHolder() {
        return this.cacheTypeHolder;
    }

    public MWCachingPolicy.CacheTypeOption getCacheType() {
        return this.cacheTypeHolder.getCacheType();
    }

    public void setCacheType(MWCachingPolicy.CacheTypeOption cacheType) {
        MWCachingPolicy.CacheTypeOption oldCacheType = this.cacheTypeHolder.getCacheType();
        this.cacheTypeHolder.setCacheType(cacheType);
        this.firePropertyChanged("cacheType", oldCacheType, cacheType);
    }

    public void setCacheType(String cacheTypeString) {
        this.setCacheType((MWCachingPolicy.CacheTypeOption)MWDescriptorCachingPolicy.cacheTypeOptions().topLinkOptionForMWModelOption(cacheTypeString));
    }

    private void setCacheTypeHolder(CacheTypeHolder cacheTypeHolder) {
        CacheTypeHolder old = this.cacheTypeHolder;
        this.cacheTypeHolder = cacheTypeHolder;
        this.firePropertyChanged(CACHE_TYPE_HOLDER_PROPERTY, old, this.cacheTypeHolder);
    }

    public boolean usesProjectDefaultCacheSize() {
        return this.cacheSizeHolder.usesProjectDefaultCacheSize();
    }

    public void setUseProjectDefaultCacheSize(boolean useProjectDefaultCacheSize) {
        boolean old = this.cacheSizeHolder.usesProjectDefaultCacheSize();
        this.cacheSizeHolder.setUseProjectDefaultCacheSize(useProjectDefaultCacheSize);
        this.firePropertyChanged(USE_PROJECT_DEFAULT_CACHE_SIZE_PROPERTY, old, this.cacheSizeHolder.usesProjectDefaultCacheSize());
    }

    public void setDontUseProjectDefaultCacheSize(int size) {
        this.setCacheSize(size);
        this.firePropertyChanged(USE_PROJECT_DEFAULT_CACHE_SIZE_PROPERTY, true, false);
    }

    public CacheSizeHolder getCacheSizeHolder() {
        return this.cacheSizeHolder;
    }

    public int getCacheSize() {
        return this.cacheSizeHolder.getCacheSize();
    }

    public void setCacheSize(int cacheSize) {
        int oldCacheSize = this.cacheSizeHolder.getCacheSize();
        this.cacheSizeHolder.setCacheSize(cacheSize);
        this.firePropertyChanged("cacheSize", oldCacheSize, cacheSize);
    }

    private void setCacheSizeHolder(CacheSizeHolder cacheSize) {
        CacheSizeHolder old = this.cacheSizeHolder;
        this.cacheSizeHolder = cacheSize;
        this.firePropertyChanged(CACHE_SIZE_HOLDER_PROPERTY, old, this.cacheSizeHolder);
    }

    public MWCacheExpiry getCacheExpiry() {
        return this.cacheExpiry;
    }

    public void setCacheExpiry(MWCacheExpiry cacheExpiry) {
        MWCacheExpiry old = this.cacheExpiry;
        this.cacheExpiry = cacheExpiry;
        this.firePropertyChanged(CACHE_EXPIRY_PROPERTY, old, this.cacheExpiry);
    }

    public void setUseProjectDefaultCacheExpiry(boolean projectCacheExpiry) {
        if (projectCacheExpiry) {
            this.setCacheExpiry(new MWProjectDefaultCacheExpiry(this));
        } else if (this.getCacheExpiry() instanceof MWProjectDefaultCacheExpiry) {
            this.setCacheExpiry(new MWDescriptorCacheExpiry(this));
        }
    }

    public void descriptorInheritanceChanged() {
        if (this.isRootDescriptor()) {
            if (this.cacheSizeHolder instanceof NullCacheSizeHolder) {
                this.setCacheSizeHolder(new CacheSizeHolderImpl());
            }
            if (this.cacheTypeHolder instanceof NullCacheTypeHolder) {
                this.setCacheTypeHolder(new CacheTypeHolderImpl());
            }
        } else {
            if (!(this.cacheSizeHolder instanceof NullCacheSizeHolder)) {
                this.setCacheSizeHolder(new NullCacheSizeHolder());
            }
            if (!(this.cacheTypeHolder instanceof NullCacheTypeHolder)) {
                this.setCacheTypeHolder(new NullCacheTypeHolder());
            }
        }
        this.firePropertyChanged(DESCRIPTOR_INHERITANCE_PROPERTY, null);
    }

    public boolean isRootDescriptor() {
        MWDescriptor descriptor = null;
        Iterator i = this.getOwningDescriptor().inheritanceHierarchy();
        while (i.hasNext()) {
            descriptor = (MWDescriptor)i.next();
        }
        return this.getOwningDescriptor() == descriptor;
    }

    public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        MWCachingPolicy projectCachingPolicy = this.getProject().getDefaultsPolicy().getCachingPolicy();
        if (this.existenceChecking.getMWModelOption() == "DEFAULT") {
            runtimeDescriptor.getQueryManager().getDoesExistQuery().setExistencePolicy(((Integer)projectCachingPolicy.getExistenceChecking().getTopLinkModelOption()).intValue());
        } else {
            this.existenceChecking.setMWOptionOnTopLinkObject(runtimeDescriptor);
        }
        this.cacheTypeHolder.adjustRuntimeDescriptor(runtimeDescriptor);
        this.cacheSizeHolder.adjustRuntimeDescriptor(runtimeDescriptor);
        if (this.cacheCoordination.getMWModelOption() == "DEFAULT") {
            runtimeDescriptor.setCacheSynchronizationType(((Integer)projectCachingPolicy.getCacheCoordination().getTopLinkModelOption()).intValue());
        } else {
            this.cacheCoordination.setMWOptionOnTopLinkObject(runtimeDescriptor);
        }
        if (this.cacheIsolation.getMWModelOption() == "DEFAULT") {
            runtimeDescriptor.setIsIsolated(projectCachingPolicy.getCacheIsolation().getMWModelOption() == "Isolated");
        } else {
            this.cacheIsolation.setMWOptionOnTopLinkObject(runtimeDescriptor);
        }
        this.cacheExpiry.adjustRuntimeDescriptor(runtimeDescriptor);
    }

    private MWDescriptorCacheExpiry getCacheExpiryForTopLink() {
        return (MWDescriptorCacheExpiry)this.cacheExpiry.getPersistedPolicy();
    }

    private void setCacheExpiryForTopLink(MWDescriptorCacheExpiry policy) {
        this.cacheExpiry = policy != null ? policy : new MWProjectDefaultCacheExpiry(this);
    }

    public MWCachingPolicy getPersistedPolicy() {
        return this;
    }

    private int getCacheSizeForTopLink() {
        return this.cacheSizeHolder.getCacheSizeForTopLink();
    }

    private void setCacheSizeForTopLink(int cacheSize) {
        this.cacheSizeHolder = new CacheSizeHolderImpl();
        this.cacheSizeHolder.setCacheSizeForTopLink(cacheSize);
    }

    private MWCachingPolicy.CacheTypeOption getCacheTypeForTopLink() {
        return this.cacheTypeHolder.getCacheTypeForTopLink();
    }

    private void setCacheTypeForTopLink(MWCachingPolicy.CacheTypeOption cacheType) {
        this.cacheTypeHolder = new CacheTypeHolderImpl();
        this.cacheTypeHolder.setCacheTypeForTopLink(cacheType);
    }

    public void postProjectBuild() {
        super.postProjectBuild();
        if (!this.isRootDescriptor()) {
            this.cacheSizeHolder = new NullCacheSizeHolder();
            this.cacheTypeHolder = new NullCacheTypeHolder();
        }
    }

    static {
        PROJECT_DEFAULT_CACHE_TYPE = new MWCachingPolicy.CacheTypeOption("DEFAULT", "CACHING_POLICY_DEFAULT_VALUE", null);
    }

    private class CacheTypeHolderImpl
    implements CacheTypeHolder {
        private MWCachingPolicy.CacheTypeOption cacheType = (MWCachingPolicy.CacheTypeOption)MWDescriptorCachingPolicy.cacheTypeOptions().topLinkOptionForMWModelOption("DEFAULT");

        private CacheTypeHolderImpl() {
        }

        public boolean typeCanBeSet() {
            return true;
        }

        public MWCachingPolicy.CacheTypeOption getCacheType() {
            return this.cacheType;
        }

        public void setCacheType(MWCachingPolicy.CacheTypeOption cacheType) {
            this.cacheType = cacheType;
        }

        public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
            if (this.cacheType.getMWModelOption() == "DEFAULT") {
                runtimeDescriptor.setIdentityMapClass(ClassTools.classForName((String)MWDescriptorCachingPolicy.this.getProject().getDefaultsPolicy().getCachingPolicy().getCacheType().getTopLinkModelOption()));
            } else {
                this.cacheType.setMWOptionOnTopLinkObject(runtimeDescriptor);
            }
        }

        public MWCachingPolicy.CacheTypeOption getCacheTypeForTopLink() {
            return this.cacheType;
        }

        public void setCacheTypeForTopLink(MWCachingPolicy.CacheTypeOption cacheType) {
            this.cacheType = cacheType;
        }
    }

    private class NullCacheTypeHolder
    implements CacheTypeHolder {
        private NullCacheTypeHolder() {
        }

        public boolean typeCanBeSet() {
            return false;
        }

        public MWCachingPolicy.CacheTypeOption getCacheType() {
            MWDescriptor rootDescriptor = MWDescriptorCachingPolicy.this.getOwningDescriptor().getInheritancePolicy().getRootDescriptor();
            return rootDescriptor.getTransactionalPolicy().getCachingPolicy().getCacheType();
        }

        public void setCacheType(MWCachingPolicy.CacheTypeOption arg0) {
        }

        public void adjustRuntimeDescriptor(ClassDescriptor arg0) {
        }

        public MWCachingPolicy.CacheTypeOption getCacheTypeForTopLink() {
            return null;
        }

        public void setCacheTypeForTopLink(MWCachingPolicy.CacheTypeOption cacheType) {
        }
    }

    public static interface CacheTypeHolder {
        public boolean typeCanBeSet();

        public MWCachingPolicy.CacheTypeOption getCacheType();

        public void setCacheType(MWCachingPolicy.CacheTypeOption var1);

        public void adjustRuntimeDescriptor(ClassDescriptor var1);

        public MWCachingPolicy.CacheTypeOption getCacheTypeForTopLink();

        public void setCacheTypeForTopLink(MWCachingPolicy.CacheTypeOption var1);
    }

    private class CacheSizeHolderImpl
    implements CacheSizeHolder {
        private volatile int cacheSize = -1;
        private volatile transient boolean useProjectDefaultCacheSize = true;
        public static final String USE_PROJECT_DEFAULT_CACHE_SIZE_PROPERTY = "useProjectDefaultCacheSize";

        public boolean sizeCanBeSet() {
            return true;
        }

        public boolean usesProjectDefaultCacheSize() {
            return this.useProjectDefaultCacheSize;
        }

        public void setUseProjectDefaultCacheSize(boolean useProjectDefaultCacheSize) {
            boolean old = this.useProjectDefaultCacheSize;
            this.useProjectDefaultCacheSize = useProjectDefaultCacheSize;
            if (old != this.useProjectDefaultCacheSize) {
                if (this.useProjectDefaultCacheSize) {
                    this.cacheSize = -1;
                } else if (this.cacheSize == -1) {
                    this.setCacheSize(MWDescriptorCachingPolicy.this.getProject().getDefaultsPolicy().getCachingPolicy().getCacheSize());
                }
            }
            MWDescriptorCachingPolicy.this.firePropertyChanged("useProjectDefaultCacheSize", old, this.useProjectDefaultCacheSize);
        }

        public void setDontUseProjectDefaultCacheSize(int size) {
            this.setCacheSize(size);
            MWDescriptorCachingPolicy.this.firePropertyChanged("useProjectDefaultCacheSize", true, false);
        }

        public int getCacheSize() {
            return this.cacheSize;
        }

        public void setCacheSize(int cacheSize) {
            int oldCacheSize = this.cacheSize;
            this.cacheSize = cacheSize;
            if (oldCacheSize != this.cacheSize && oldCacheSize == -1) {
                this.setUseProjectDefaultCacheSize(false);
            }
            MWDescriptorCachingPolicy.this.firePropertyChanged("cacheSize", oldCacheSize, cacheSize);
        }

        public int getCacheSizeForTopLink() {
            if (this.useProjectDefaultCacheSize) {
                return -1;
            }
            return this.cacheSize;
        }

        public void setCacheSizeForTopLink(int cacheSize) {
            this.useProjectDefaultCacheSize = cacheSize == -1;
            this.cacheSize = cacheSize;
        }

        public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
            if (this.usesProjectDefaultCacheSize()) {
                runtimeDescriptor.setIdentityMapSize(MWDescriptorCachingPolicy.this.getProject().getDefaultsPolicy().getCachingPolicy().getCacheSize());
            } else {
                runtimeDescriptor.setIdentityMapSize(this.getCacheSize());
            }
        }
    }

    private class NullCacheSizeHolder
    implements CacheSizeHolder {
        private NullCacheSizeHolder() {
        }

        public boolean sizeCanBeSet() {
            return false;
        }

        public boolean usesProjectDefaultCacheSize() {
            MWDescriptor rootDescriptor = MWDescriptorCachingPolicy.this.getOwningDescriptor().getInheritancePolicy().getRootDescriptor();
            return rootDescriptor.getTransactionalPolicy().getCachingPolicy().usesProjectDefaultCacheSize();
        }

        public void setUseProjectDefaultCacheSize(boolean arg0) {
        }

        public int getCacheSize() {
            MWDescriptor rootDescriptor = MWDescriptorCachingPolicy.this.getOwningDescriptor().getInheritancePolicy().getRootDescriptor();
            return rootDescriptor.getTransactionalPolicy().getCachingPolicy().getCacheSize();
        }

        public void setCacheSize(int arg0) {
        }

        public int getCacheSizeForTopLink() {
            return -1;
        }

        public void setCacheSizeForTopLink(int arg0) {
        }

        public void adjustRuntimeDescriptor(ClassDescriptor arg0) {
        }
    }

    public static interface CacheSizeHolder {
        public boolean sizeCanBeSet();

        public boolean usesProjectDefaultCacheSize();

        public void setUseProjectDefaultCacheSize(boolean var1);

        public int getCacheSize();

        public void setCacheSize(int var1);

        public int getCacheSizeForTopLink();

        public void setCacheSizeForTopLink(int var1);

        public void adjustRuntimeDescriptor(ClassDescriptor var1);
    }
}

