/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.ReturningPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWReturningPolicyInsertFieldReturnOnlyFlag;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWReturningPolicy
extends MWAbstractDescriptorPolicy {
    private Collection insertFieldReturnOnlyFlags;
    public static final String INSERT_FIELD_RETURN_ONLY_FLAGS_COLLECTION = "insertFieldReturnOnlyFlags";
    public static final String UPDATE_FIELDS_COLLECTION = "updateFields";

    protected MWReturningPolicy() {
    }

    protected MWReturningPolicy(MWMappingDescriptor parent) {
        super(parent);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.insertFieldReturnOnlyFlags = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Collection collection = this.insertFieldReturnOnlyFlags;
        synchronized (collection) {
            children.addAll(this.insertFieldReturnOnlyFlags);
        }
    }

    public Iterator insertFieldReturnOnlyFlags() {
        return new CloneIterator(this.insertFieldReturnOnlyFlags){

            protected void remove(Object current) {
                MWReturningPolicy.this.removeInsertFieldReturnOnlyFlag((MWReturningPolicyInsertFieldReturnOnlyFlag)current);
            }
        };
    }

    public int insertFieldReturnOnlyFlagsSize() {
        return this.insertFieldReturnOnlyFlags.size();
    }

    public void addInsertFieldReadOnlyFlag(MWReturningPolicyInsertFieldReturnOnlyFlag insertFieldReturnOnlyFlag) {
        this.addItemToCollection(insertFieldReturnOnlyFlag, this.insertFieldReturnOnlyFlags, INSERT_FIELD_RETURN_ONLY_FLAGS_COLLECTION);
    }

    public void removeInsertFieldReturnOnlyFlag(MWReturningPolicyInsertFieldReturnOnlyFlag insertFieldReturnOnlyFlag) {
        this.removeItemFromCollection(insertFieldReturnOnlyFlag, this.insertFieldReturnOnlyFlags, INSERT_FIELD_RETURN_ONLY_FLAGS_COLLECTION);
    }

    public Iterator insertFields() {
        return new TransformationIterator(this.insertFieldReturnOnlyFlags()){

            protected Object transform(Object next) {
                return ((MWReturningPolicyInsertFieldReturnOnlyFlag)next).getField();
            }
        };
    }

    public abstract Iterator updateFields();

    public abstract int updateFieldsSize();

    public abstract void removeUpdateField(MWDataField var1);

    public boolean isActive() {
        return true;
    }

    public MWDescriptorPolicy getPersistedPolicy() {
        return this;
    }

    protected void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        this.checkTypeIndicatorField(problems);
        this.checkOptimisticLockingField(problems);
        this.checkReturningFieldIsmapped(problems);
    }

    private void checkTypeIndicatorField(List newProblems) {
        MWClassIndicatorPolicy classIndicatorPolicy = this.getOwningDescriptor().getInheritancePolicy().getClassIndicatorPolicy();
        if (classIndicatorPolicy.getType() == "fieldClassIndicatorPolicy") {
            MWDataField classIndicatorField = ((MWClassIndicatorFieldPolicy)classIndicatorPolicy).getField();
            if (CollectionTools.contains(this.updateFields(), (Object)classIndicatorField)) {
                newProblems.add(this.buildProblem("0334", classIndicatorField.fieldName()));
            }
            if (CollectionTools.contains(this.insertFields(), (Object)classIndicatorField)) {
                newProblems.add(this.buildProblem("0335", classIndicatorField.fieldName()));
            }
        }
    }

    private void checkOptimisticLockingField(List newProblems) {
        MWLockingPolicy lockingPolicy = this.getOwningDescriptor().getLockingPolicy();
        MWDataField lockingField = lockingPolicy.getVersionLockField();
        if (lockingField != null) {
            if (CollectionTools.contains(this.updateFields(), (Object)lockingField)) {
                newProblems.add(this.buildProblem("0337", lockingField.fieldName()));
            }
            if (CollectionTools.contains(this.insertFields(), (Object)lockingField)) {
                newProblems.add(this.buildProblem("0336", lockingField.fieldName()));
            }
        }
    }

    private void checkReturningFieldIsmapped(List newProblems) {
        MWDataField field;
        Iterator stream = this.updateFields();
        while (stream.hasNext()) {
            field = (MWDataField)stream.next();
            if (!this.getOwningDescriptor().allWritableMappingsForField(field).isEmpty()) continue;
            newProblems.add(this.buildProblem("0340", field.fieldName()));
        }
        stream = this.insertFields();
        while (stream.hasNext()) {
            field = (MWDataField)stream.next();
            if (!this.getOwningDescriptor().allWritableMappingsForField(field).isEmpty()) continue;
            newProblems.add(this.buildProblem("0341", field.fieldName()));
        }
    }

    public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        ReturningPolicy returningPolicy = new ReturningPolicy();
        runtimeDescriptor.setReturningPolicy(returningPolicy);
        Iterator stream = this.insertFieldReturnOnlyFlags();
        while (stream.hasNext()) {
            ((MWReturningPolicyInsertFieldReturnOnlyFlag)stream.next()).adjustRuntimeReturningPolicy(returningPolicy);
        }
        stream = this.updateFields();
        while (stream.hasNext()) {
            returningPolicy.addFieldForUpdate(((MWDataField)stream.next()).runtimeField());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getInsertFieldReturnOnlyFlagsForTopLink() {
        Collection collection = this.insertFieldReturnOnlyFlags;
        synchronized (collection) {
            return new TreeSet(this.insertFieldReturnOnlyFlags);
        }
    }

    private void setInsertFieldReturnOnlyFlagsForTopLink(Collection insertFieldReturnOnlyFlags) {
        this.insertFieldReturnOnlyFlags = insertFieldReturnOnlyFlags;
    }
}

