/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.handles;

import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWReferenceHandle
extends MWHandle {
    private volatile MWReference reference;
    private volatile String referenceTableName;
    private volatile String referenceName;

    private MWReferenceHandle() {
    }

    public MWReferenceHandle(MWModel parent, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
    }

    public MWReferenceHandle(MWModel parent, MWReference reference, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
        this.reference = reference;
    }

    public MWReference getReference() {
        return this.reference;
    }

    public void setReference(MWReference reference) {
        this.reference = reference;
    }

    protected Node node() {
        return this.getReference();
    }

    public MWReferenceHandle setScrubber(MWHandle.NodeReferenceScrubber scrubber) {
        this.setScrubberInternal(scrubber);
        return this;
    }

    public void resolveReferenceHandles() {
        MWTable table;
        super.resolveReferenceHandles();
        if (this.referenceTableName != null && this.referenceName != null && (table = this.getDatabase().tableNamed(this.referenceTableName)) != null) {
            this.reference = table.referenceNamed(this.referenceName);
        }
        this.referenceTableName = null;
        this.referenceName = null;
    }

    public int compareTo(Object o) {
        return this.reference.compareTo(((MWReferenceHandle)o).reference);
    }

    public void toString(StringBuffer sb) {
        if (this.reference == null) {
            sb.append("null");
        } else {
            this.reference.toString(sb);
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWReferenceHandle.class);
        descriptor.addDirectMapping("referenceTableName", "getReferenceTableNameForTopLink", "setReferenceTableNameForTopLink", "reference-table-name/text()");
        descriptor.addDirectMapping("referenceName", "getReferenceNameForTopLink", "setReferenceNameForTopLink", "reference-name/text()");
        return descriptor;
    }

    private String getReferenceTableNameForTopLink() {
        return this.reference == null ? null : this.reference.getSourceTable().getName();
    }

    private void setReferenceTableNameForTopLink(String referenceTableName) {
        this.referenceTableName = referenceTableName;
    }

    private String getReferenceNameForTopLink() {
        return this.reference == null ? null : this.reference.getName();
    }

    private void setReferenceNameForTopLink(String referenceName) {
        this.referenceName = referenceName;
    }
}

