/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWFieldTransformerAssociation;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformationMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalTransformationMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWRelationalFieldTransformerAssociation
extends MWFieldTransformerAssociation {
    private MWColumnHandle columnHandle;

    private MWRelationalFieldTransformerAssociation() {
    }

    MWRelationalFieldTransformerAssociation(MWRelationalTransformationMapping parent) {
        super(parent);
    }

    MWRelationalFieldTransformerAssociation(MWRelationalTransformationMapping parent, MWColumn column, MWClass fieldTransformerClass) {
        super((MWTransformationMapping)parent, fieldTransformerClass);
        this.setColumn(column);
    }

    MWRelationalFieldTransformerAssociation(MWRelationalTransformationMapping parent, MWColumn databaseField, MWMethod fieldTransformerMethod) {
        super((MWTransformationMapping)parent, fieldTransformerMethod);
        this.setColumn(databaseField);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.columnHandle = new MWColumnHandle(this, this.buildColumnScrubber());
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.columnHandle);
    }

    private MWHandle.NodeReferenceScrubber buildColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWRelationalFieldTransformerAssociation.this.setColumn(null);
            }

            public String toString() {
                return "MWRelationalFieldTransformerAssociation.buildColumnScrubber()";
            }
        };
    }

    public MWColumn getColumn() {
        return this.columnHandle.getColumn();
    }

    public void setColumn(MWColumn column) {
        MWColumn old = this.columnHandle.getColumn();
        this.columnHandle.setColumn(column);
        this.firePropertyChanged("field", old, column);
    }

    protected void setFieldTransformer(MWTransformer fieldTransformer) {
        super.setFieldTransformer(fieldTransformer);
        this.getProject().recalculateAggregatePathsToColumn(this.getParentDescriptor());
    }

    public String fieldName() {
        if (this.relationalDescriptor().isAggregateDescriptor()) {
            return this.getFieldTransformer().fieldNameForRuntime();
        }
        return super.fieldName();
    }

    public MWDataField getField() {
        return this.getColumn();
    }

    MWRelationalTransformationMapping relationalTransformationMapping() {
        return (MWRelationalTransformationMapping)this.getParent();
    }

    MWRelationalDescriptor relationalDescriptor() {
        return this.relationalTransformationMapping().getParentRelationalDescriptor();
    }

    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        if (!this.relationalDescriptor().isAggregateDescriptor() && this.getColumn() == null) {
            currentProblems.add(this.buildProblem("0528"));
        }
    }

    public boolean duplicateField(MWColumn field) {
        if (field == null) {
            return false;
        }
        ListIterator stream = this.relationalTransformationMapping().fieldTransformerAssociations();
        while (stream.hasNext()) {
            MWRelationalFieldTransformerAssociation association = (MWRelationalFieldTransformerAssociation)stream.next();
            if (association == this || association.getColumn() != field) continue;
            return true;
        }
        return false;
    }

    protected DatabaseField runtimeField() {
        if (this.relationalDescriptor().isAggregateDescriptor()) {
            return new DatabaseField(this.getMapping().getName() + "->" + this.getFieldTransformer().fieldNameForRuntime());
        }
        return super.runtimeField();
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWRelationalFieldTransformerAssociation.class);
        descriptor.getInheritancePolicy().setParentClass(MWFieldTransformerAssociation.class);
        XMLCompositeObjectMapping columnHandleMapping = new XMLCompositeObjectMapping();
        columnHandleMapping.setAttributeName("columnHandle");
        columnHandleMapping.setGetMethodName("getColumnHandleForTopLink");
        columnHandleMapping.setSetMethodName("setColumnHandleForTopLink");
        columnHandleMapping.setReferenceClass(MWColumnHandle.class);
        columnHandleMapping.setXPath("column-handle");
        descriptor.addMapping((DatabaseMapping)columnHandleMapping);
        return descriptor;
    }

    private MWColumnHandle getColumnHandleForTopLink() {
        return this.columnHandle.getColumn() == null ? null : this.columnHandle;
    }

    private void setColumnHandleForTopLink(MWColumnHandle columnHandle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildColumnScrubber();
        this.columnHandle = columnHandle == null ? new MWColumnHandle(this, scrubber) : columnHandle.setScrubber(scrubber);
    }
}

