/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.platform.database.oracle.NCharacter;
import org.eclipse.persistence.platform.database.oracle.NClob;
import org.eclipse.persistence.platform.database.oracle.NString;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWConverterMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTypeConversionConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public final class MWRelationalTypeConversionConverter
extends MWTypeConversionConverter {
    private static final Class[] N_TYPE_CLASSES = new Class[]{NCharacter.class, NString.class, NClob.class};
    private static final String[] ORACLE_SPECIFIC_TYPE_NAMES = new String[]{"oracle.sql.TIMESTAMP", "oracle.sql.TIMESTAMPLTZ", "oracle.sql.TIMESTAMPTZ"};

    private MWRelationalTypeConversionConverter() {
    }

    protected MWRelationalTypeConversionConverter(MWConverterMapping parent) {
        super(parent);
    }

    public MWRelationalTypeConversionConverter(MWConverterMapping parent, Map legacyValueMap) {
        super(parent);
        this.legacyInitialize(legacyValueMap);
    }

    public Set getBasicTypes() {
        Set types = super.getBasicTypes();
        this.addNTypeDatabaseTypeDeclarationsTo(types);
        this.addOracleSpecificDatabaseTypeDeclarationsTo(types);
        return types;
    }

    private Iterator nTypes() {
        return new TransformationIterator(new ArrayIterator(N_TYPE_CLASSES)){

            protected Object transform(Object next) {
                return MWRelationalTypeConversionConverter.this.typeFor((Class)next);
            }
        };
    }

    private void addNTypeDatabaseTypeDeclarationsTo(Collection typeDeclarations) {
        Iterator stream = this.nTypes();
        while (stream.hasNext()) {
            typeDeclarations.add(new MWTypeDeclaration((MWModel)this, (MWClass)stream.next()));
        }
    }

    private Iterator oracleSpecificTypes() {
        return new TransformationIterator(new ArrayIterator(ORACLE_SPECIFIC_TYPE_NAMES)){

            protected Object transform(Object next) {
                return MWRelationalTypeConversionConverter.this.typeNamed((String)next);
            }
        };
    }

    private void addOracleSpecificDatabaseTypeDeclarationsTo(Collection typeDeclarations) {
        Iterator stream = this.oracleSpecificTypes();
        while (stream.hasNext()) {
            typeDeclarations.add(new MWTypeDeclaration((MWModel)this, (MWClass)stream.next()));
        }
    }

    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        if (this.getDataType() != null) {
            this.checkNType(currentProblems);
            this.checkOracleSpecificType(currentProblems);
        }
    }

    private void checkNType(List currentProblems) {
        if (this.dataTypeIsNType() && !this.getDatabase().getDatabasePlatform().containsDatabaseTypeNamed("NCHAR")) {
            currentProblems.add(this.buildProblem("0545"));
        }
    }

    private void checkOracleSpecificType(List currentProblems) {
        if (this.dataTypeIsOracleSpecificType() && !this.getDatabase().getDatabasePlatform().containsDatabaseTypeNamed("TIMESTAMP WITH LOCAL TIME ZONE")) {
            currentProblems.add(this.buildProblem("0546"));
        }
    }

    private boolean dataTypeIsNType() {
        return CollectionTools.contains(this.nTypes(), (Object)this.getDataType().getType());
    }

    private boolean dataTypeIsOracleSpecificType() {
        return CollectionTools.contains(this.oracleSpecificTypes(), (Object)this.getDataType().getType());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWRelationalTypeConversionConverter.class);
        descriptor.getInheritancePolicy().setParentClass(MWTypeConversionConverter.class);
        return descriptor;
    }
}

