/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.eis.mappings.EISOneToOneMapping;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWEisDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWProxyIndirectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWEisReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlFieldPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml.MWEisInteraction;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml.MWEisQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWEisOneToOneMapping
extends MWEisReferenceMapping
implements MWProxyIndirectionMapping {
    private volatile boolean useDescriptorReadObjectInteraction;
    public static final String USE_DESCRIPTOR_READ_OBJECT_INTERACTION_PROPERTY = "useDescriptorReadObjectInteraction";

    private MWEisOneToOneMapping() {
    }

    public MWEisOneToOneMapping(MWEisDescriptor parent, MWClassAttribute attribute, String name) {
        super(parent, attribute, name);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.useDescriptorReadObjectInteraction = true;
    }

    protected void initialize(MWClassAttribute attribute, String name) {
        super.initialize(attribute, name);
        if (!this.getInstanceVariable().isValueHolder() && this.getInstanceVariable().getType().isInterface()) {
            this.indirectionType = "proxy-indirection";
        }
    }

    protected boolean requiresSelectionInteraction() {
        return false;
    }

    public boolean usesDescriptorReadObjectInteraction() {
        return this.useDescriptorReadObjectInteraction;
    }

    public void setUseDescriptorReadObjectInteraction(boolean useDescriptorReadObjectInteraction) {
        boolean old = this.useDescriptorReadObjectInteraction;
        this.useDescriptorReadObjectInteraction = useDescriptorReadObjectInteraction;
        if (old != useDescriptorReadObjectInteraction) {
            this.firePropertyChanged(USE_DESCRIPTOR_READ_OBJECT_INTERACTION_PROPERTY, old, useDescriptorReadObjectInteraction);
            this.setSelectionInteraction(useDescriptorReadObjectInteraction ? null : new MWEisInteraction(this));
        }
    }

    private MWEisInteraction referenceDescriptorReadInteraction() {
        return this.referenceRootEisDescriptor() == null ? null : ((MWEisQueryManager)this.referenceRootEisDescriptor().getQueryManager()).getReadObjectInteraction();
    }

    public boolean sourceFieldMayUseCollectionXpath() {
        return false;
    }

    public boolean usesProxyIndirection() {
        return this.getIndirectionType() == "proxy-indirection";
    }

    public void setUseProxyIndirection() {
        this.setIndirectionType("proxy-indirection");
    }

    protected void initializeOn(MWMapping newMapping) {
        newMapping.initializeFromMWEisOneToOneMapping(this);
    }

    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.checkFieldPairs(newProblems);
        this.checkReferenceDescriptorReadInteraction(newProblems);
        this.checkFieldPairsAndReadInteractionArguments(newProblems);
        this.addUsesIndirectionWhileMaintainsBiDirectionalRelationship(newProblems);
    }

    private void checkFieldPairs(List newProblems) {
        if (this.isReadOnly() && this.getSelectionInteraction() == null || this.xmlFieldPairsSize() == 0) {
            newProblems.add(this.buildProblem("0610"));
        }
    }

    private void checkReferenceDescriptorReadInteraction(List newProblems) {
        if (this.usesDescriptorReadObjectInteraction() && this.referenceRootEisDescriptor() != null && this.referenceDescriptorReadInteraction().getFunctionName() == null) {
            newProblems.add(this.buildProblem("0611"));
        }
    }

    private void checkFieldPairsAndReadInteractionArguments(List newProblems) {
        if (!this.usesDescriptorReadObjectInteraction() || this.referenceDescriptorReadInteraction() == null) {
            return;
        }
        ListIterator stream = this.referenceDescriptorReadInteraction().inputArguments();
        while (stream.hasNext()) {
            String argumentFieldName = ((MWEisInteraction.ArgumentPair)stream.next()).getArgumentFieldName();
            if (this.hasCorrespondingTargetKey(argumentFieldName)) continue;
            newProblems.add(this.buildProblem("0612", argumentFieldName));
        }
    }

    private void addUsesIndirectionWhileMaintainsBiDirectionalRelationship(List newProblems) {
        if (this.maintainsBidirectionalRelationship() && this.usesNoIndirection()) {
            newProblems.add(this.buildProblem("0468"));
        }
    }

    private boolean hasCorrespondingTargetKey(String argumentFieldName) {
        ListIterator stream = this.xmlFieldPairs();
        while (stream.hasNext()) {
            MWXmlField targetField = ((MWXmlFieldPair)stream.next()).getTargetXmlField();
            if (targetField == null || !targetField.getXpath().equals(argumentFieldName)) continue;
            return true;
        }
        return false;
    }

    protected DatabaseMapping buildRuntimeMapping() {
        return new EISOneToOneMapping();
    }

    public DatabaseMapping runtimeMapping() {
        EISOneToOneMapping mapping = (EISOneToOneMapping)super.runtimeMapping();
        ListIterator stream = this.xmlFieldPairs();
        while (stream.hasNext()) {
            ((MWXmlFieldPair)stream.next()).addRuntimeForeignKeyField(mapping);
        }
        if (this.usesProxyIndirection()) {
            mapping.setIndirectionPolicy((IndirectionPolicy)new ProxyIndirectionPolicy());
        }
        return mapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWEisOneToOneMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWEisReferenceMapping.class);
        XMLDirectMapping useDescriptorReadObjectInteractionMapping = (XMLDirectMapping)descriptor.addDirectMapping(USE_DESCRIPTOR_READ_OBJECT_INTERACTION_PROPERTY, "use-descriptor-read-object-interaction/text()");
        useDescriptorReadObjectInteractionMapping.setNullValue((Object)Boolean.FALSE);
        return descriptor;
    }
}

