/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.eis.EISConnectionSpec;
import org.eclipse.persistence.eis.EISLogin;
import org.eclipse.persistence.internal.security.JCEEncryptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWProperty;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWEisLoginSpec
extends MWModel {
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    private volatile String userName;
    public static final String USER_NAME_PROPERTY = "userName";
    private volatile String password;
    public static final String PASSWORD_PROPERTY = "password";
    private volatile boolean savePassword;
    public static final String SAVE_PASSWORD_PROPERTY = "savePassword";
    private MWClassHandle connectionSpecClassHandle;
    public static final String CONNECTION_SPEC_CLASS_PROPERTY = "connectionSpecClass";
    private volatile String connectionFactoryUrl;
    public static final String CONNECTION_FACTORY_URL_PROPERTY = "connectionFactoryUrl";
    private volatile Collection properties;
    public static final String PROPERTY_COLLECTION = "property";
    private volatile String j2cAdapterName;
    public static String J2C_ADAPTER_NAME_PROPERTY = "j2cAdapter";
    public static String AQ_ADAPTER_NAME = "Oracle AQ";
    public static String JMS_ADAPTER_NAME = "JMS";
    public static String XML_FILE_ADAPTER_NAME = "XML File";
    public static String DEFAULT_ADAPTER_NAME = AQ_ADAPTER_NAME;
    public static String[] j2cAdapterNames = new String[]{AQ_ADAPTER_NAME, JMS_ADAPTER_NAME, XML_FILE_ADAPTER_NAME};
    public static final String J2C_ADAPTER_NAMES_COLLECTION = "j2cAdapterNames";
    public static String JMS_ADAPTER_CLASS_NAME = "org.eclipse.persistence.eis.adapters.jms.JMSPlatform";
    public static String ORACLE_AQ_ADAPTER_CLASS_NAME = "org.eclipse.persistence.eis.adapters.aq.AQPlatform";
    public static String XML_FILE_ADAPTER_CLASS_NAME = "org.eclipse.persistence.eis.adapters.xmlfile.XMLFilePlatform";
    public static final String PLATFORM_PREFERENCE = "eis platform";
    public static final String PLATFORM_PREFERENCE_DEFAULT = AQ_ADAPTER_NAME;
    private static transient JCEEncryptor ENCRYPTOR;

    private static JCEEncryptor getEncryptor() {
        if (ENCRYPTOR == null) {
            try {
                ENCRYPTOR = new JCEEncryptor();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return ENCRYPTOR;
    }

    private MWEisLoginSpec() {
    }

    MWEisLoginSpec(MWEisProject newProject, String j2cAdapterName) {
        super(newProject);
        this.initialize(j2cAdapterName);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.connectionSpecClassHandle = new MWClassHandle(this, this.buildConnectionSpecClassScrubber());
        this.savePassword = false;
        this.properties = new Vector();
    }

    protected void initialize(String j2cAdapterName) {
        this.j2cAdapterName = j2cAdapterName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged(NAME_PROPERTY, old, name);
        if (this.attributeValueHasChanged(old, name)) {
            this.getProject().nodeRenamed(this);
        }
    }

    public String getConnectionFactoryURL() {
        return this.connectionFactoryUrl;
    }

    public void setConnectionFactoryURL(String url) {
        String old = this.connectionFactoryUrl;
        this.connectionFactoryUrl = url;
        this.firePropertyChanged(CONNECTION_FACTORY_URL_PROPERTY, old, url);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        String old = this.userName;
        this.userName = userName;
        this.firePropertyChanged(USER_NAME_PROPERTY, old, userName);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        String old = this.password;
        this.password = password;
        this.firePropertyChanged(PASSWORD_PROPERTY, old, password);
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean savePassword) {
        boolean old = this.savePassword;
        this.savePassword = savePassword;
        this.firePropertyChanged(SAVE_PASSWORD_PROPERTY, old, savePassword);
    }

    public MWClass getConnectionSpecClass() {
        return this.connectionSpecClassHandle.getType();
    }

    public void setConnectionSpecClass(MWClass newConnectionSpecClass) {
        MWClass old = this.getConnectionSpecClass();
        this.connectionSpecClassHandle.setType(newConnectionSpecClass);
        this.firePropertyChanged(CONNECTION_SPEC_CLASS_PROPERTY, old, this.connectionSpecClassHandle.getType());
    }

    public Collection getProperties() {
        return this.properties;
    }

    public Iterator properties() {
        return this.getProperties().iterator();
    }

    public int propertySize() {
        return this.getProperties().size();
    }

    protected void removeAllProperties() {
        Vector copy = new Vector(this.properties);
        Iterator iter = copy.iterator();
        while (iter.hasNext()) {
            this.removeProperty((MWProperty)iter.next());
        }
    }

    public MWProperty addProperty(String key, String value) {
        MWProperty property = new MWProperty(this);
        property.setKey(key);
        property.setValue(value);
        this.addItemToCollection(property, this.getProperties(), PROPERTY_COLLECTION);
        return property;
    }

    public void removeProperty(MWProperty property) {
        this.removeItemFromCollection(property, this.getProperties(), PROPERTY_COLLECTION);
    }

    public String getJ2CAdapterName() {
        return this.j2cAdapterName;
    }

    public void setJ2CAdapterName(String newValue) {
        String oldValue = this.j2cAdapterName;
        this.j2cAdapterName = newValue;
        this.firePropertyChanged(J2C_ADAPTER_NAME_PROPERTY, oldValue, newValue);
    }

    public static Iterator j2CAdapterNames() {
        return CollectionTools.iterator(j2cAdapterNames);
    }

    public static Collection getJ2CAdapterNames() {
        return CollectionTools.collection(j2cAdapterNames);
    }

    public static int j2CAdapterNamesSize() {
        return j2cAdapterNames.length;
    }

    private String encryptedPassword() {
        return this.password == null ? null : MWEisLoginSpec.getEncryptor().encryptPassword(this.password);
    }

    public void toString(StringBuffer sb) {
        sb.append(this.name);
    }

    public String displayString() {
        return this.name;
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.connectionSpecClassHandle);
    }

    private MWHandle.NodeReferenceScrubber buildConnectionSpecClassScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWEisLoginSpec.this.setConnectionSpecClass(null);
            }

            public String toString() {
                return "MWEisLoginSpec.buildConnectionSpecClassScrubber()";
            }
        };
    }

    public DatasourceLogin buildRuntimeLogin() {
        EISLogin eisLogin = new EISLogin();
        if (this.getJ2CAdapterName().equals(AQ_ADAPTER_NAME)) {
            eisLogin.setPlatformClassName(ORACLE_AQ_ADAPTER_CLASS_NAME);
        } else if (this.getJ2CAdapterName().equals(JMS_ADAPTER_NAME)) {
            eisLogin.setPlatformClassName(JMS_ADAPTER_CLASS_NAME);
        } else if (this.getJ2CAdapterName().equals(XML_FILE_ADAPTER_NAME)) {
            eisLogin.setPlatformClassName(XML_FILE_ADAPTER_CLASS_NAME);
        } else {
            throw new UnsupportedOperationException("The j2cAdapterName is not valid");
        }
        MWClass connectionSpecType = this.getConnectionSpecClass();
        if (connectionSpecType != null) {
            eisLogin.setConnectionSpec(this.newInstance(connectionSpecType));
        }
        eisLogin.setConnectionFactoryURL(this.getConnectionFactoryURL());
        String userName = this.getUserName();
        if (userName != null) {
            eisLogin.setUserName(userName);
        }
        String password = this.getPassword();
        if (this.savePassword && password != null) {
            eisLogin.setPassword(password);
        }
        for (MWProperty property : this.getProperties()) {
            eisLogin.setProperty(property.getKey(), (Object)property.getValue());
        }
        return eisLogin;
    }

    private EISConnectionSpec newInstance(MWClass connectionSpecType) {
        try {
            return (EISConnectionSpec)ClassTools.newInstance(connectionSpecType.getName(), this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Collection getPropertiesForTopLink() {
        return this.getProperties();
    }

    public void setPropertiesForTopLink(Collection properties) {
        this.properties = properties == null ? new Vector() : properties;
    }

    public String getJ2CAdapterNameForTopLink() {
        return this.j2cAdapterName;
    }

    public void setJ2CAdapterNameForTopLink(String newValue) {
        if (newValue == null) {
            newValue = DEFAULT_ADAPTER_NAME;
        }
        this.j2cAdapterName = newValue;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWEisLoginSpec.class);
        descriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        descriptor.addDirectMapping("j2cAdapterName", "getJ2CAdapterNameForTopLink", "setJ2CAdapterNameForTopLink", "j2c-adapter-name/text()");
        descriptor.addDirectMapping(USER_NAME_PROPERTY, "user-name/text()");
        descriptor.addDirectMapping(PASSWORD_PROPERTY, "getPasswordForTopLink", "setPasswordForTopLink", "password/text()");
        descriptor.addDirectMapping(CONNECTION_FACTORY_URL_PROPERTY, "connection-factory-url/text()");
        ((XMLDirectMapping)descriptor.addDirectMapping(SAVE_PASSWORD_PROPERTY, "save-password/text()")).setNullValue((Object)Boolean.FALSE);
        XMLCompositeObjectMapping connectionSpecClassHandleMapping = new XMLCompositeObjectMapping();
        connectionSpecClassHandleMapping.setAttributeName("connectionSpecClassHandle");
        connectionSpecClassHandleMapping.setGetMethodName("getConnectionSpecClassHandleForTopLink");
        connectionSpecClassHandleMapping.setSetMethodName("setConnectionSpecClassHandleForTopLink");
        connectionSpecClassHandleMapping.setReferenceClass(MWClassHandle.class);
        connectionSpecClassHandleMapping.setXPath("connection-spec-class-handle");
        descriptor.addMapping((DatabaseMapping)connectionSpecClassHandleMapping);
        XMLCompositeCollectionMapping propertiesMapping = new XMLCompositeCollectionMapping();
        propertiesMapping.setReferenceClass(MWProperty.class);
        propertiesMapping.setAttributeName("properties");
        propertiesMapping.setGetMethodName("getPropertiesForTopLink");
        propertiesMapping.setSetMethodName("setPropertiesForTopLink");
        propertiesMapping.setXPath(PROPERTY_COLLECTION);
        descriptor.addMapping((DatabaseMapping)propertiesMapping);
        return descriptor;
    }

    private String getPasswordForTopLink() {
        return this.savePassword ? this.encryptedPassword() : null;
    }

    private void setPasswordForTopLink(String password) {
        this.password = password == null ? null : MWEisLoginSpec.getEncryptor().decryptPassword(password);
    }

    private MWClassHandle getConnectionSpecClassHandleForTopLink() {
        return this.connectionSpecClassHandle.getType() == null ? null : this.connectionSpecClassHandle;
    }

    private void setConnectionSpecClassHandleForTopLink(MWClassHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildConnectionSpecClassScrubber();
        this.connectionSpecClassHandle = handle == null ? new MWClassHandle(this, scrubber) : handle.setScrubber(scrubber);
    }
}

