/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalForeignKeyColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc.JDBCExternalColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc.JDBCExternalForeignKey;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class JDBCExternalForeignKeyColumnPair
implements ExternalForeignKeyColumnPair {
    private final JDBCExternalForeignKey foreignKey;
    private final ExternalColumn sourceColumn;
    private final ExternalColumn targetColumn;

    JDBCExternalForeignKeyColumnPair(JDBCExternalForeignKey foreignKey, ResultSet resultSet) {
        this.foreignKey = foreignKey;
        this.sourceColumn = this.columnNamed(this.stringFrom(resultSet, 8));
        this.targetColumn = this.buildLocalColumn(this.stringFrom(resultSet, 4));
    }

    private String stringFrom(ResultSet resultSet, int colIndex) {
        try {
            return this.trim(resultSet.getString(colIndex));
        }
        catch (SQLException ex) {
            return null;
        }
    }

    private String trim(String s) {
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() == 0 ? null : s;
    }

    public ExternalColumn getSourceColumn() {
        return this.sourceColumn;
    }

    public ExternalColumn getTargetColumn() {
        return this.targetColumn;
    }

    private JDBCExternalColumn columnNamed(String columnName) {
        return this.foreignKey.columnNamed(columnName);
    }

    private ExternalColumn buildLocalColumn(String columnName) {
        return columnName == null ? null : new TargetColumn(columnName);
    }

    private String sourceColumnName() {
        return this.sourceColumn == null ? null : this.sourceColumn.getName();
    }

    private String targetColumnName() {
        return this.targetColumn == null ? null : this.targetColumn.getName();
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.sourceColumnName() + "=>" + this.targetColumnName());
    }

    private static class TargetColumn
    implements ExternalColumn {
        private final String name;

        TargetColumn(String name) {
            if (name == null) {
                throw new NullPointerException();
            }
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getJDBCTypeCode() {
            throw new UnsupportedOperationException();
        }

        public String getTypeName() {
            throw new UnsupportedOperationException();
        }

        public int getSize() {
            throw new UnsupportedOperationException();
        }

        public int getScale() {
            throw new UnsupportedOperationException();
        }

        public boolean isNullable() {
            throw new UnsupportedOperationException();
        }

        public boolean isPrimaryKey() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return StringTools.buildToStringFor(this, this.name);
        }
    }
}

