/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalConstructor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader.CLExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader.CLExternalConstructor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader.CLExternalField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader.CLExternalMethod;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class CLExternalClass
implements ExternalClass {
    private final Class javaClass;
    private final CLExternalClassDescription classDescription;

    CLExternalClass(Class javaClass, CLExternalClassDescription classDescription) {
        this.javaClass = javaClass;
        this.classDescription = classDescription;
    }

    public ExternalClassDescription[] getDeclaredClasses() {
        return this.buildClassDescriptionArray(this.javaClass.getDeclaredClasses());
    }

    public ExternalConstructor[] getDeclaredConstructors() {
        return this.buildConstructorArray(this.javaClass.getDeclaredConstructors());
    }

    public ExternalField[] getDeclaredFields() {
        return this.buildFieldArray(this.javaClass.getDeclaredFields());
    }

    public ExternalMethod[] getDeclaredMethods() {
        return this.buildMethodArray(this.javaClass.getDeclaredMethods());
    }

    public ExternalClassDescription getDeclaringClass() {
        return this.classDescriptionFor(this.javaClass.getDeclaringClass());
    }

    public ExternalClassDescription[] getInterfaces() {
        return this.buildClassDescriptionArray(this.javaClass.getInterfaces());
    }

    public int getModifiers() {
        return this.javaClass.getModifiers();
    }

    public String getName() {
        return this.javaClass.getName();
    }

    public ExternalClassDescription getSuperclass() {
        return this.classDescriptionFor(this.javaClass.getSuperclass());
    }

    public boolean isInterface() {
        return this.javaClass.isInterface();
    }

    public boolean isPrimitive() {
        return this.javaClass.isPrimitive();
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.getName());
    }

    ExternalClassDescription classDescriptionFor(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return this.classDescription.classDescriptionFor(clazz);
    }

    private ExternalClassDescription[] buildClassDescriptionArray(Class[] classes) {
        ExternalClassDescription[] classDescriptions = new ExternalClassDescription[classes.length];
        int i = classes.length;
        while (i-- > 0) {
            classDescriptions[i] = this.classDescriptionFor(classes[i]);
        }
        return classDescriptions;
    }

    private ExternalConstructor[] buildConstructorArray(Constructor[] constructors) {
        ExternalConstructor[] externalConstructors = new ExternalConstructor[constructors.length];
        int i = constructors.length;
        while (i-- > 0) {
            externalConstructors[i] = new CLExternalConstructor(constructors[i], this);
        }
        return externalConstructors;
    }

    private ExternalField[] buildFieldArray(Field[] fields) {
        ExternalField[] externalFields = new ExternalField[fields.length];
        int i = fields.length;
        while (i-- > 0) {
            externalFields[i] = new CLExternalField(fields[i], this);
        }
        return externalFields;
    }

    private ExternalMethod[] buildMethodArray(Method[] methods) {
        ExternalMethod[] externalMethods = new ExternalMethod[methods.length];
        int i = methods.length;
        while (i-- > 0) {
            externalMethods[i] = new CLExternalMethod(methods[i], this);
        }
        return externalMethods;
    }
}

