/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsmodel;

import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.workbench.platformsmodel.CorruptXMLException;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCType;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCTypeRepository;
import org.eclipse.persistence.tools.workbench.platformsmodel.JavaTypeDeclaration;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.XMLTools;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class DatabaseType
extends AbstractNodeModel {
    private String name;
    public static final String NAME_PROPERTY = "name";
    private JDBCType jdbcType;
    public static final String JDBC_TYPE_PROPERTY = "jdbcType";
    private boolean allowsSize;
    public static final String ALLOWS_SIZE_PROPERTY = "allowsSize";
    private boolean requiresSize;
    public static final String REQUIRES_SIZE_PROPERTY = "requiresSize";
    private int initialSize;
    public static final String INITIAL_SIZE_PROPERTY = "initialSize";
    private boolean allowsSubSize;
    public static final String ALLOWS_SUB_SIZE_PROPERTY = "allowsSubSize";
    private boolean allowsNull;
    public static final String ALLOWS_NULL_PROPERTY = "allowsNull";

    DatabaseType(DatabasePlatform platform, org.w3c.dom.Node node) throws CorruptXMLException {
        super(platform);
        this.read(node);
    }

    DatabaseType(DatabasePlatform platform, String name) {
        super(platform);
        this.name = name;
        this.jdbcType = this.jdbcTypeRepository().getDefaultJDBCType();
    }

    protected void initialize() {
        super.initialize();
        this.allowsSize = true;
        this.requiresSize = false;
        this.initialSize = 0;
        this.allowsSubSize = false;
        this.allowsNull = true;
    }

    public DatabasePlatform getPlatform() {
        return (DatabasePlatform)this.getParent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.getPlatform().checkDatabaseTypeName(name);
        String old = this.name;
        this.name = name;
        this.firePropertyChanged(NAME_PROPERTY, old, name);
    }

    public JDBCType getJDBCType() {
        return this.jdbcType;
    }

    public void setJDBCType(JDBCType jdbcType) {
        if (jdbcType == null) {
            throw new NullPointerException();
        }
        JDBCType old = this.jdbcType;
        this.jdbcType = jdbcType;
        this.firePropertyChanged(JDBC_TYPE_PROPERTY, old, jdbcType);
    }

    public boolean allowsSize() {
        return this.allowsSize;
    }

    public void setAllowsSize(boolean allowsSize) {
        boolean old = this.allowsSize;
        this.allowsSize = allowsSize;
        this.firePropertyChanged(ALLOWS_SIZE_PROPERTY, old, allowsSize);
        if (!allowsSize) {
            this.setAllowsSubSize(false);
            this.setRequiresSize(false);
        }
    }

    public boolean requiresSize() {
        return this.requiresSize;
    }

    public void setRequiresSize(boolean requiresSize) {
        boolean old = this.requiresSize;
        this.requiresSize = requiresSize;
        this.firePropertyChanged(REQUIRES_SIZE_PROPERTY, old, requiresSize);
        if (requiresSize) {
            this.setAllowsSize(true);
        } else {
            this.setInitialSize(0);
        }
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("initial size must be greater than or equal to zero" + initialSize);
        }
        int old = this.initialSize;
        this.initialSize = initialSize;
        this.firePropertyChanged(INITIAL_SIZE_PROPERTY, old, initialSize);
        if (initialSize != 0) {
            this.setRequiresSize(true);
        }
    }

    public boolean allowsSubSize() {
        return this.allowsSubSize;
    }

    public void setAllowsSubSize(boolean allowsSubSize) {
        boolean old = this.allowsSubSize;
        this.allowsSubSize = allowsSubSize;
        this.firePropertyChanged(ALLOWS_SUB_SIZE_PROPERTY, old, allowsSubSize);
        if (allowsSubSize) {
            this.setAllowsSize(true);
        }
    }

    public boolean allowsNull() {
        return this.allowsNull;
    }

    public void setAllowsNull(boolean allowsNull) {
        boolean old = this.allowsNull;
        this.allowsNull = allowsNull;
        this.firePropertyChanged(ALLOWS_NULL_PROPERTY, old, allowsNull);
    }

    public JavaTypeDeclaration javaTypeDeclaration() {
        return this.jdbcTypeRepository().javaTypeDeclarationFor(this.getJDBCType());
    }

    private DatabasePlatformRepository platformRepository() {
        return this.getPlatform().getRepository();
    }

    private JDBCTypeRepository jdbcTypeRepository() {
        return this.platformRepository().getJDBCTypeRepository();
    }

    private JDBCType jdbcTypeNamed(String jdbcTypeName) {
        return this.jdbcTypeRepository().jdbcTypeNamed(jdbcTypeName);
    }

    public Iterator jdbcTypes() {
        return this.jdbcTypeRepository().jdbcTypes();
    }

    public int jdbcTypesSize() {
        return this.jdbcTypeRepository().jdbcTypesSize();
    }

    protected void addProblemsTo(List currentProblems) {
        if (this.requiresSize() && this.getInitialSize() == 0) {
            currentProblems.add(this.buildProblem("003", this.getPlatform().getName(), this.getName()));
        }
        super.addProblemsTo(currentProblems);
    }

    public void nodeRemoved(Node node) {
        super.nodeRemoved(node);
        if (this.jdbcType == node) {
            this.setJDBCType(this.jdbcTypeRepository().getDefaultJDBCType());
        }
    }

    void cloneFrom(DatabaseType originalType) {
        this.setComment(originalType.getComment());
        this.setJDBCType(originalType.getJDBCType());
        this.setAllowsSize(originalType.allowsSize());
        this.setRequiresSize(originalType.requiresSize());
        this.setInitialSize(originalType.getInitialSize());
        this.setAllowsSubSize(originalType.allowsSubSize());
        this.setAllowsNull(originalType.allowsNull());
    }

    private void read(org.w3c.dom.Node node) throws CorruptXMLException {
        if (node == null) {
            throw this.buildCorruptXMLException("missing node");
        }
        this.name = XMLTools.childTextContent(node, NAME_PROPERTY, null);
        if (this.name == null || this.name.length() == 0) {
            throw this.buildCorruptXMLException("name is required");
        }
        ClassTools.setFieldValue(this, "comment", XMLTools.childTextContent(node, "comment", ""));
        String jdbcTypeName = XMLTools.childTextContent(node, "jdbc-type", null);
        try {
            this.jdbcType = this.jdbcTypeNamed(jdbcTypeName);
        }
        catch (IllegalArgumentException ex) {
            throw this.buildCorruptXMLException(ex);
        }
        this.allowsSize = XMLTools.childBooleanContent(node, "allows-size", false);
        this.requiresSize = XMLTools.childBooleanContent(node, "requires-size", false);
        if (!this.allowsSize && this.requiresSize) {
            throw this.buildCorruptXMLException("size cannot be required when it is not allowed");
        }
        this.initialSize = XMLTools.childIntContent(node, "initial-size", 0);
        if (!this.requiresSize && this.initialSize != 0) {
            throw this.buildCorruptXMLException("initial size cannot be specified when size is not required");
        }
        this.allowsSubSize = XMLTools.childBooleanContent(node, "allows-sub-size", false);
        if (!this.allowsSize && this.allowsSubSize) {
            throw this.buildCorruptXMLException("sub-size cannot be allowed when size is not allowed");
        }
        this.allowsNull = XMLTools.childBooleanContent(node, "allows-null", false);
    }

    private CorruptXMLException buildCorruptXMLException(String message) {
        return new CorruptXMLException(message + " (" + this.corruptXMLLocation() + ")");
    }

    private CorruptXMLException buildCorruptXMLException(Throwable t) {
        return new CorruptXMLException(this.corruptXMLLocation(), t);
    }

    private String corruptXMLLocation() {
        return this.getPlatform().getName() + ":" + this.name;
    }

    void write(org.w3c.dom.Node node) {
        XMLTools.addSimpleTextNode(node, NAME_PROPERTY, this.name);
        XMLTools.addSimpleTextNode(node, "comment", (String)ClassTools.getFieldValue(this, "comment"), "");
        XMLTools.addSimpleTextNode(node, "jdbc-type", this.jdbcType.getName());
        XMLTools.addSimpleTextNode(node, "allows-size", this.allowsSize, false);
        XMLTools.addSimpleTextNode(node, "requires-size", this.requiresSize, false);
        XMLTools.addSimpleTextNode(node, "initial-size", this.initialSize, 0);
        XMLTools.addSimpleTextNode(node, "allows-sub-size", this.allowsSubSize, false);
        XMLTools.addSimpleTextNode(node, "allows-null", this.allowsNull, false);
    }

    public String displayString() {
        return this.name;
    }

    public void toString(StringBuffer sb) {
        sb.append(this.name);
    }
}

