/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.util.List;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassFile;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.InnerClassesAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class InnerClass {
    private InnerClassesAttribute pool;
    private short innerClassInfoIndex;
    private short outerClassInfoIndex;
    private short innerClassNameIndex;
    private short innerClassAccessFlags;
    public static final short ACC_SYNTHETIC = 4096;
    public static final short ACC_ANNOTATION = 8192;
    public static final short ACC_ENUM = 16384;
    private static final String ANONYMOUS = "<anonymous>";
    private static final String NOT_APPLICABLE = "<N/A>";

    InnerClass(ClassFileDataInputStream stream, InnerClassesAttribute pool) throws IOException {
        this.pool = pool;
        this.initialize(stream);
    }

    void initialize(ClassFileDataInputStream stream) throws IOException {
        this.innerClassInfoIndex = stream.readU2();
        this.outerClassInfoIndex = stream.readU2();
        this.innerClassNameIndex = stream.readU2();
        this.innerClassAccessFlags = stream.readU2();
    }

    public String displayString() {
        StringWriter sw = new StringWriter(1000);
        IndentingPrintWriter writer = new IndentingPrintWriter(sw);
        this.displayStringOn(writer);
        return sw.toString();
    }

    public void displayStringOn(IndentingPrintWriter writer) {
        writer.println(this.innerClassName());
        writer.indent();
        writer.print("inner class info name: ");
        writer.println(this.innerClassInfoName());
        writer.print("outer class info name: ");
        writer.println(this.outerClassInfoName());
        writer.print("inner class name: ");
        writer.println(this.innerClassName());
        writer.print("modifier string: ");
        writer.println(this.modifierString());
        writer.undent();
    }

    boolean isNamed(short nameIndex) {
        return this.innerClassInfoIndex == nameIndex;
    }

    public boolean isNamed(String name) {
        return this.innerClassInfoName().equals(name);
    }

    String declaringClassName() {
        short index = this.outerClassInfoIndex;
        return index == 0 ? null : this.className(index);
    }

    void addDeclaredMemberClassTo(List memberClassNames) {
        if (this.isSynthetic()) {
            return;
        }
        short classNameIndex = this.classFile().getDeclaration().getThisClassIndex();
        if (this.outerClassInfoIndex == classNameIndex) {
            memberClassNames.add(this.innerClassInfoName());
        }
    }

    public String innerClassInfoName() {
        return this.className(this.innerClassInfoIndex);
    }

    public String outerClassInfoName() {
        short index = this.outerClassInfoIndex;
        return index == 0 ? NOT_APPLICABLE : this.className(index);
    }

    private String className(short index) {
        return this.constantPool().getClassConstant(index).name();
    }

    public String innerClassName() {
        short index = this.innerClassNameIndex;
        return index == 0 ? ANONYMOUS : this.constantPool().getUTF8String(index);
    }

    public String modifierString() {
        return Modifier.toString(this.innerClassAccessFlags);
    }

    public ConstantPool constantPool() {
        return this.pool.constantPool();
    }

    public ClassFile classFile() {
        return this.pool.classFile();
    }

    public boolean isSynthetic() {
        return (this.innerClassAccessFlags & 0x1000) != 0;
    }

    public boolean isAnnotation() {
        return (this.innerClassAccessFlags & 0x2000) != 0;
    }

    public boolean isEnum() {
        return (this.innerClassAccessFlags & 0x4000) != 0;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public InnerClassesAttribute getPool() {
        return this.pool;
    }

    public short getInnerClassInfoIndex() {
        return this.innerClassInfoIndex;
    }

    public short getOuterClassInfoIndex() {
        return this.outerClassInfoIndex;
    }

    public short getInnerClassNameIndex() {
        return this.innerClassNameIndex;
    }

    public short getInnerClassAccessFlags() {
        return this.innerClassAccessFlags;
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.innerClassName() + ')';
    }
}

