/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class SourceDebugExtensionAttribute
extends Attribute {
    private byte[] debugExtension;

    public SourceDebugExtensionAttribute(ClassFileDataInputStream stream, short nameIndex, AttributePool pool) throws IOException {
        super(stream, nameIndex, pool);
    }

    void initializeInfo(ClassFileDataInputStream stream) throws IOException {
        int length = this.getLength();
        this.debugExtension = new byte[length];
        stream.read(this.debugExtension);
    }

    void displayInfoStringOn(IndentingPrintWriter writer) {
        this.writeHexStringOn(this.debugExtension, writer);
        writer.println();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public byte[] getDebugExtension() {
        return this.debugExtension;
    }

    void toString(StringBuffer sb) {
        this.appendHexStringTo(this.debugExtension, sb);
    }
}

