/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile.descriptor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.FieldType;

public class ArrayType
extends FieldType {
    private FieldType componentType;

    ArrayType(Reader reader) throws IOException {
        this.componentType = FieldType.createFieldType(reader);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public int arrayDepth() {
        return this.componentType.arrayDepth() + 1;
    }

    public String elementTypeName() {
        return this.componentType.elementTypeName();
    }

    public String javaName() {
        StringBuffer sb = new StringBuffer();
        this.appendArrayJavaNameTo(sb);
        return sb.toString();
    }

    public Class javaClass() throws ClassNotFoundException {
        return Class.forName(this.javaName());
    }

    public void appendDeclarationTo(StringBuffer sb) {
        this.componentType.appendDeclarationTo(sb);
        sb.append("[]");
    }

    public void printDeclarationOn(PrintWriter writer) {
        this.componentType.printDeclarationOn(writer);
        writer.print("[]");
    }

    public String internalName() {
        StringBuffer sb = new StringBuffer();
        this.appendArrayInternalNameTo(sb);
        return sb.toString();
    }

    void appendArrayJavaNameTo(StringBuffer sb) {
        sb.append('[');
        this.componentType.appendArrayJavaNameTo(sb);
    }

    void appendArrayInternalNameTo(StringBuffer sb) {
        sb.append('[');
        this.componentType.appendArrayInternalNameTo(sb);
    }
}

