/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.platform.database.oracle.publisher.MethodFilter;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.ProcedureMethod;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlTypeWithMethods;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.FieldInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.MethodInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ParamInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ResultInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.UserArguments;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewCache;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewRow;
import org.eclipse.persistence.platform.database.oracle.publisher.visit.PublisherVisitor;

public class SqlPackageType
extends SqlTypeWithMethods {
    protected String m_synonymOwner;
    protected String m_synonymName;
    protected String[] m_executeNames;
    protected ParamInfoValues m_paramInfoValues;
    private ResultInfoValues m_resultInfoValues;

    @Override
    public boolean isPackage() {
        return true;
    }

    public SqlPackageType(SqlName sqlName, SqlType parentType, MethodFilter signatureFilter, SqlReflector reflector) throws SQLException {
        super(sqlName, 1999, true, parentType, signatureFilter, reflector);
    }

    public SqlPackageType(SqlName sqlName, List<ProcedureMethod> methods, SqlReflector reflector) throws SQLException {
        super(sqlName, 1999, true, null, null, reflector);
        this.m_methods = methods;
    }

    @Override
    protected List<FieldInfo> getFieldInfo() {
        return null;
    }

    public String getSynonymName() {
        return this.m_synonymName;
    }

    public String[] getExecuteNames() {
        return this.m_executeNames;
    }

    public boolean hasSecurityAttributes() {
        return this.m_synonymName != null || this.m_executeNames.length > 0;
    }

    @Override
    protected MethodInfo[] getMethodInfo(String schema, String name) throws SQLException {
        String[] keys = null;
        Object[] values = null;
        if (this.m_methodFilter != null && this.m_methodFilter.isSingleMethod()) {
            keys = new String[]{"OWNER", "PACKAGE_NAME", "OBJECT_NAME", "DATA_LEVEL"};
            values = new Object[]{schema, name, this.m_methodFilter.getSingleMethodName(), 0};
        } else {
            keys = new String[]{"OWNER", "PACKAGE_NAME", "DATA_LEVEL"};
            values = new Object[]{schema, name, 0};
        }
        Iterator<ViewRow> iter = this.m_viewCache.getRows("ALL_ARGUMENTS", new String[0], keys, values, new String[0]);
        MethodInfo[] minfo = MethodInfo.groupBy(iter);
        return minfo;
    }

    @Override
    protected ResultInfo getResultInfo(String schema, String name, String methodName, String methodNo) throws SQLException {
        if (this.m_resultInfoValues == null || !this.m_resultInfoValues.matches(schema, name)) {
            this.m_resultInfoValues = new ResultInfoValues(schema, name, this.m_methodFilter, this.m_viewCache);
        }
        return this.m_resultInfoValues.get(methodName, methodNo);
    }

    @Override
    protected ParamInfo[] getParamInfo(String schema, String name, String methodName, String methodNo) throws SQLException {
        if (this.m_paramInfoValues == null || !this.m_paramInfoValues.matches(schema, name)) {
            this.m_paramInfoValues = new ParamInfoValues(schema, name, this.m_methodFilter, this.m_viewCache);
        }
        return this.m_paramInfoValues.get(methodName, methodNo);
    }

    @Override
    public void accept(PublisherVisitor v) {
        v.visit(this);
    }

    private static class ParamInfoValues
    extends InfoValues {
        public ParamInfoValues(String schema, String name, MethodFilter methodFilter, ViewCache viewCache) throws SQLException {
            super(schema, name);
            String[] keys = null;
            Object[] values = null;
            if (methodFilter != null && methodFilter.isSingleMethod()) {
                keys = new String[]{"OWNER", "PACKAGE_NAME", "OBJECT_NAME", "DATA_LEVEL"};
                values = new Object[]{schema, name, methodFilter.getSingleMethodName(), 0};
            } else {
                keys = new String[]{"OWNER", "PACKAGE_NAME", "DATA_LEVEL"};
                values = new Object[]{schema, name, 0};
            }
            Iterator<ViewRow> iter = viewCache.getRows("ALL_ARGUMENTS", new String[0], keys, values, new String[0]);
            ArrayList<ViewRow> viewRows = new ArrayList<ViewRow>();
            while (iter.hasNext()) {
                UserArguments item = (UserArguments)iter.next();
                if (item.ARGUMENT_NAME == null) continue;
                viewRows.add(item);
            }
            UserArguments.orderByPosition(viewRows);
            for (int i = 0; i < viewRows.size(); ++i) {
                UserArguments item = (UserArguments)viewRows.get(i);
                String key = ParamInfoValues.makeKey(item.OBJECT_NAME, item.OVERLOAD);
                ArrayList<UserArguments> v = (ArrayList<UserArguments>)this.m_ht.get(key);
                if (v == null) {
                    v = new ArrayList<UserArguments>();
                    this.m_ht.put(key, v);
                }
                v.add(item);
            }
        }

        public ParamInfo[] get(String method, String method_no) throws SQLException {
            ArrayList v = (ArrayList)this.m_ht.get(ParamInfoValues.makeKey(method, method_no));
            if (v == null) {
                v = new ArrayList();
            }
            return ParamInfo.getParamInfo(v);
        }
    }

    private static class InfoValues {
        protected String m_schema;
        protected String m_name;
        protected Map<String, ArrayList<ViewRow>> m_ht;

        public InfoValues(String schema, String name) throws SQLException {
            this.m_schema = schema;
            this.m_name = name;
            this.m_ht = new HashMap<String, ArrayList<ViewRow>>();
        }

        protected static String makeKey(String method, String method_no) {
            return "" + method + "/" + method_no;
        }

        public boolean matches(String schema, String name) {
            return (schema == null ? this.m_schema == null : schema.equals(this.m_schema)) && (name == null ? this.m_name != null : name.equals(this.m_name));
        }
    }

    private static class ResultInfoValues
    extends InfoValues {
        public ResultInfoValues(String schema, String name, MethodFilter methodFilter, ViewCache viewCache) throws SQLException {
            super(schema, name);
            String[] keys = null;
            Object[] values = null;
            if (methodFilter != null && methodFilter.isSingleMethod()) {
                keys = new String[]{"OWNER", "PACKAGE_NAME", "OBJECT_NAME", "DATA_LEVEL", "POSITION"};
                values = new Object[]{schema, name, methodFilter.getSingleMethodName(), 0, 0};
            } else {
                keys = new String[]{"OWNER", "PACKAGE_NAME", "DATA_LEVEL", "POSITION"};
                values = new Object[]{schema, name, 0, 0};
            }
            Iterator<ViewRow> iter = viewCache.getRows("ALL_ARGUMENTS", new String[0], keys, values, new String[0]);
            while (iter.hasNext()) {
                UserArguments item = (UserArguments)iter.next();
                String key = ResultInfoValues.makeKey(item.OBJECT_NAME, item.OVERLOAD);
                if (this.m_ht.get(key) != null) continue;
                ArrayList<UserArguments> itemWrapper = new ArrayList<UserArguments>();
                itemWrapper.add(item);
                this.m_ht.put(key, itemWrapper);
            }
        }

        public ResultInfo get(String method_name, String method_no) throws SQLException {
            ArrayList row = (ArrayList)this.m_ht.get(ResultInfoValues.makeKey(method_name, method_no));
            ResultInfo rinfo = null;
            rinfo = new ResultInfo((UserArguments)row.get(0));
            return rinfo;
        }
    }
}

