/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.ant.taskdefs;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.eclipse.persistence.tools.workbench.ant.AntExtensionBundle;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultStringRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.StringRepository;

public abstract class ProjectTask
extends Task {
    private CommandlineJava commandline;
    private AntClassLoader classLoader;
    private String userClasspath;
    protected StringRepository stringRepository;

    protected ProjectTask() {
        this.initialize();
    }

    protected void initialize() {
        this.classLoader = null;
        this.userClasspath = "";
        this.stringRepository = new DefaultStringRepository(AntExtensionBundle.class);
    }

    protected void preExecute() throws BuildException {
    }

    public void execute() throws BuildException {
        this.preExecute();
    }

    protected int execute(Object[] args) throws BuildException {
        try {
            this.log(this.stringRepository.getString("usingSysProperties", System.getProperties().toString()), 3);
            this.createClassLoader();
            if (this.classLoader != null) {
                this.classLoader.setThreadContextLoader();
            }
            TaskRunner runner = new TaskRunner((ClassLoader)this.classLoader);
            int n = runner.execute(args);
            return n;
        }
        catch (InvocationTargetException ie) {
            this.log(ie.getTargetException().toString(), 0);
            throw new BuildException(ie.getTargetException());
        }
        catch (Throwable e) {
            Throwable t = e.getCause() == null ? e : e.getCause();
            this.log(t.toString(), 0);
            throw new BuildException(t);
        }
        finally {
            if (this.classLoader != null) {
                this.classLoader.resetThreadContextLoader();
            }
        }
    }

    protected abstract String getProjectRunnerClassName();

    protected CommandlineJava getCommandline() {
        if (this.commandline == null) {
            this.commandline = new CommandlineJava();
        }
        return this.commandline;
    }

    public Path createClasspath() {
        return this.getCommandline().createClasspath(this.getProject()).createPath();
    }

    private void createClassLoader() {
        Path commandlineClasspath = this.getCommandline().getClasspath();
        if (commandlineClasspath != null && this.classLoader == null) {
            Path classpath = (Path)commandlineClasspath.clone();
            if (this.userClasspath.length() > 0) {
                Path path = new Path(this.getProject(), this.userClasspath);
                classpath.append(path);
            }
            this.classLoader = this.getProject().createClassLoader(classpath);
            this.classLoader.setParentFirst(false);
            this.classLoader.addJavaLibraries();
            this.log(this.stringRepository.getString("usingClasspath", this.classLoader.getClasspath()), 3);
        }
    }

    public void setClasspath(Path s) {
        this.createClasspath().append(s);
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    protected String getUserClasspath() {
        return this.userClasspath;
    }

    protected void setUserClasspath(String userClasspath) {
        this.userClasspath = userClasspath;
    }

    private class TaskRunner {
        private Object mappingsRunner;
        protected StringRepository stringRepository;

        private TaskRunner(ClassLoader classLoader) {
            this.initialize(classLoader);
        }

        private void initialize(ClassLoader classLoader) {
            this.stringRepository = new DefaultStringRepository(AntExtensionBundle.class);
            this.mappingsRunner = this.loadMappingsRunner(classLoader);
        }

        private Object loadMappingsRunner(ClassLoader classLoader) {
            Class<?> mappingRunnerClass = null;
            Object runner = null;
            try {
                mappingRunnerClass = Class.forName(ProjectTask.this.getProjectRunnerClassName(), true, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(this.stringRepository.getString("errorWhileExporting", ProjectTask.this.getProjectRunnerClassName()), e);
            }
            try {
                runner = mappingRunnerClass.newInstance();
            }
            catch (InstantiationException ie) {
                throw new RuntimeException(this.stringRepository.getString("instantiationExceptionAtInstantiation", mappingRunnerClass.getName()), ie);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(this.stringRepository.getString("illegalAccessExceptionAtInstantiation", mappingRunnerClass.getName()), iae);
            }
            return runner;
        }

        private int execute(Object[] args) throws InvocationTargetException {
            Integer result;
            Method task = null;
            try {
                Class[] parameters = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] == null) {
                        throw new IllegalArgumentException(this.stringRepository.getString("executeMethodCannotBeNull"));
                    }
                    parameters[i] = args[i].getClass();
                }
                task = this.mappingsRunner.getClass().getMethod("execute", parameters);
                if (task.getReturnType().isAssignableFrom(Integer.class)) {
                    throw new RuntimeException(this.stringRepository.getString("expectIntegerReturningType", task.getName()));
                }
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(this.stringRepository.getString("executeMethodNotFound", this.mappingsRunner.getClass().getName()), e);
            }
            try {
                result = (Integer)task.invoke(this.mappingsRunner, args);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(this.stringRepository.getString("illegalArgumentExceptionAtInvocation", task.getName()), e);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(this.stringRepository.getString("illegalAccessExceptionAtInvocation", task.getName()), iae);
            }
            return result;
        }
    }
}

