/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.app;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ComponentDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ComponentGroupDescription;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationListIterator;

public class ButtonGroupDescription
implements ComponentGroupDescription {
    private List buttons = new ArrayList();

    public void add(ComponentDescription menuItem) {
        this.buttons.add(menuItem);
    }

    public void remove(ComponentDescription menuItem) {
        this.buttons.remove(menuItem);
    }

    public ListIterator components() {
        return new TransformationListIterator(this.buttons.listIterator()){

            protected Object transform(Object next) {
                return ((ComponentDescription)next).component();
            }
        };
    }

    public boolean hasComponents() {
        return this.buttons.size() > 0;
    }

    public Iterator actions() {
        ArrayList<Iterator> actionIterators = new ArrayList<Iterator>();
        for (ComponentDescription menuItem : this.buttons) {
            actionIterators.add(menuItem.actions());
        }
        return new CompositeIterator(actionIterators);
    }

    public void updateOn(Collection frameworkActions) {
        for (ComponentDescription description : new ArrayList(this.buttons)) {
            description.updateOn(frameworkActions);
            this.postUpdateOnActions(description, frameworkActions);
        }
    }

    protected void postUpdateOnActions(ComponentDescription button, Collection frameworkActions) {
        boolean containsAllActions = true;
        Iterator buttonActions = button.actions();
        while (buttonActions.hasNext()) {
            boolean containsGivenAction = false;
            FrameworkAction menuItemAction = (FrameworkAction)buttonActions.next();
            Iterator frameworkActionsIter = frameworkActions.iterator();
            while (frameworkActionsIter.hasNext() && !containsGivenAction) {
                FrameworkAction frameworkAction = (FrameworkAction)frameworkActionsIter.next();
                if (!frameworkAction.getClassification().equals(menuItemAction.getClassification())) continue;
                containsGivenAction = true;
            }
            containsAllActions &= containsGivenAction;
        }
        if (!containsAllActions) {
            this.remove(button);
        }
    }
}

