/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.app.EditorNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;

abstract class AbstractEditorView {
    private WorkbenchContext context;
    private ValueModel nodeHolder;
    EditorNode node;
    private PropertyChangeListener nodeListener;
    private Component propertiesPage;
    private JPanel panel;

    AbstractEditorView(ValueModel nodeHolder, WorkbenchContext context) {
        if (nodeHolder == null) {
            throw new NullPointerException();
        }
        this.nodeHolder = nodeHolder;
        this.node = (EditorNode)this.nodeHolder.getValue();
        this.nodeListener = this.buildNodeListener();
        nodeHolder.addPropertyChangeListener("value", this.nodeListener);
        this.context = context;
        this.propertiesPage = this.node.propertiesPage(null);
    }

    private PropertyChangeListener buildNodeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                AbstractEditorView.this.nodeChanged((EditorNode)e.getNewValue());
            }
        };
    }

    Component getComponent() {
        if (this.panel == null) {
            this.panel = this.buildPanel();
            this.installNewPropertiesPage();
        }
        return this.panel;
    }

    ResourceRepository resourceRepository() {
        return this.context.getApplicationContext().getResourceRepository();
    }

    Component getPropertiesPage() {
        return this.propertiesPage;
    }

    private JPanel buildPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(BorderFactory.createEtchedBorder());
        result.setMinimumSize(new Dimension(0, 0));
        JLabel label = this.buildLabel();
        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, result.getBackground().brighter()), BorderFactory.createMatteBorder(0, 0, 1, 0, result.getBackground().darker())), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        label.setLabelFor(result);
        result.add((Component)label, "First");
        return result;
    }

    abstract JLabel buildLabel();

    void nodeChanged(EditorNode newNode) {
        this.node.releasePropertiesPage(this.propertiesPage);
        this.node = newNode;
        Component newPropertiesPage = this.node.propertiesPage(this.context);
        if (newPropertiesPage != this.propertiesPage) {
            this.panel.remove(this.propertiesPage);
            this.propertiesPage = newPropertiesPage;
            this.installNewPropertiesPage();
        }
    }

    void installNewPropertiesPage() {
        this.panel.add(this.propertiesPage, "Center");
        if (this.panel.isVisible()) {
            this.panel.revalidate();
            this.panel.repaint();
        }
    }

    void close() {
        this.nodeHolder.removePropertyChangeListener("value", this.nodeListener);
    }
}

