/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkNodeManager;

final class WorkbenchSaveAsAction
extends AbstractFrameworkAction {
    private FrameworkNodeManager nodeManager;
    private TreeSelectionListener treeSelectionListener;
    private WindowListener windowListener;

    WorkbenchSaveAsAction(WorkbenchContext context, FrameworkNodeManager nodeManager) {
        super(context);
        this.nodeManager = nodeManager;
    }

    protected void initialize() {
        super.initialize();
        this.initializeTextAndMnemonic("file.saveAs");
        this.initializeIcon("file.saveAs");
        this.initializeToolTipText("file.saveAs.toolTipText");
        this.initializeAccelerator("file.saveAs.ACCELERATOR");
        this.treeSelectionListener = this.buildTreeSelectionListener();
        this.windowListener = this.buildWorkbenchWindowListener();
        this.currentWindow().addWindowListener(this.windowListener);
        this.navigatorSelectionModel().addTreeSelectionListener(this.treeSelectionListener);
        this.updateEnabledState();
    }

    private WindowListener buildWorkbenchWindowListener() {
        return new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                WorkbenchSaveAsAction.this.workbenchWindowClosed();
            }
        };
    }

    private TreeSelectionListener buildTreeSelectionListener() {
        return new TreeSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(TreeSelectionEvent e) {
                WorkbenchSaveAsAction workbenchSaveAsAction = WorkbenchSaveAsAction.this;
                synchronized (workbenchSaveAsAction) {
                    WorkbenchSaveAsAction.this.update();
                }
            }
        };
    }

    protected void execute() {
        ApplicationNode[] projectNodes = this.selectedProjectNodes();
        int i = projectNodes.length;
        while (i-- > 0) {
            this.nodeManager.saveAs(projectNodes[i], this.getWorkbenchContext());
        }
    }

    void update() {
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        this.setEnabled(this.selectedProjectNodes().length > 0);
    }

    void workbenchWindowClosed() {
        this.navigatorSelectionModel().removeTreeSelectionListener(this.treeSelectionListener);
        this.currentWindow().removeWindowListener(this.windowListener);
    }
}

