/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.resources;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.persistence.tools.workbench.framework.resources.MissingMnemonicException;
import org.eclipse.persistence.tools.workbench.framework.resources.MnemonicRepository;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class DefaultMnemonicRepository
implements MnemonicRepository {
    private ResourceBundle resourceBundle;

    public DefaultMnemonicRepository(String resourceClassName) {
        this.initialize(resourceClassName);
    }

    public DefaultMnemonicRepository(Class resourceClass) {
        this(resourceClass.getName());
    }

    protected void initialize(String resourceClassName) {
        this.resourceBundle = ResourceBundle.getBundle(resourceClassName);
    }

    public boolean hasMnemonic(String key) {
        return key == null || CollectionTools.contains(this.resourceBundle.getKeys(), (Object)key);
    }

    public int getMnemonic(String key) {
        if (key == null) {
            return -1;
        }
        String string = this.getString(key);
        int index = string.indexOf(38);
        if (index == -1 || index == string.length() - 1) {
            return -1;
        }
        return Character.toUpperCase(string.charAt(index + 1));
    }

    public int getMnemonicIndex(String key) {
        return this.getString(key).indexOf(38);
    }

    protected String getString(String key) {
        try {
            return this.resourceBundle.getString(key);
        }
        catch (MissingResourceException ex) {
            if (ex.getKey().equals(key)) {
                throw new MissingMnemonicException("Missing mnemonic: " + key, key);
            }
            throw ex;
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.resourceBundle.getClass().getName());
    }
}

