/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.chooser;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionAdapter;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionNode;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionNodeContainer;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionPackageNode;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractTreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public final class ClassDescriptionPackagePoolNode
extends AbstractTreeNodeValueModel
implements Displayable,
ClassDescriptionNodeContainer {
    private Object value = new Object();
    private String name;
    private ListValueModel packageNodesHolder;
    private ListValueModel sortedPackageNodesHolder;
    private Icon packageIcon;
    private Icon classIcon;
    private Collator collator;

    public ClassDescriptionPackagePoolNode(String name, Iterator userClassDescriptions, ClassDescriptionAdapter adapter, WorkbenchContext context) {
        this(name, userClassDescriptions, adapter, Collections.EMPTY_SET, context);
    }

    public ClassDescriptionPackagePoolNode(String name, Iterator userClassDescriptions, ClassDescriptionAdapter adapter, Collection excludedUserClassDescriptions, WorkbenchContext context) {
        this.name = name;
        this.packageIcon = context.getApplicationContext().getResourceRepository().getIcon("package");
        this.classIcon = context.getApplicationContext().getResourceRepository().getIcon("class.public");
        this.collator = Collator.getInstance();
        this.initialize(userClassDescriptions, adapter, excludedUserClassDescriptions);
    }

    private void initialize(Iterator userClassDescriptions, ClassDescriptionAdapter adapter, Collection excludedUserClassDescriptions) {
        this.packageNodesHolder = new SimpleListValueModel(new ArrayList(1000));
        this.addUserClassDescriptions(userClassDescriptions, adapter, excludedUserClassDescriptions);
        this.removeEmptyPackageNodes();
        this.sortedPackageNodesHolder = new SortedListValueModelAdapter(this.packageNodesHolder);
    }

    private void addUserClassDescriptions(Iterator userClassDescriptions, ClassDescriptionAdapter adapter, Collection excludedUserClassDescriptions) {
        HashMap packageNodeNames = new HashMap(1000);
        while (userClassDescriptions.hasNext()) {
            Object userClassDescription = userClassDescriptions.next();
            if (excludedUserClassDescriptions.contains(userClassDescription)) continue;
            this.addClassNode(new ClassDescriptionNode(userClassDescription, adapter), packageNodeNames);
        }
    }

    private void removeEmptyPackageNodes() {
        List emptyPackageNodes = CollectionTools.list((Iterator)this.emptyPackageNodes());
        Iterator stream = emptyPackageNodes.iterator();
        while (stream.hasNext()) {
            this.removePackageNode((ClassDescriptionPackageNode)stream.next());
        }
    }

    private Iterator emptyPackageNodes() {
        return new FilteringIterator(this.packageNodes()){

            public boolean accept(Object next) {
                return ((ClassDescriptionPackageNode)next).isEmpty();
            }
        };
    }

    ListIterator packageNodes() {
        return (ListIterator)this.packageNodesHolder.getValue();
    }

    int packageNodesSize() {
        return this.packageNodesHolder.size();
    }

    void addClassNode(ClassDescriptionNode classNode) {
        this.addClassNode(classNode, null);
    }

    void addClassNode(ClassDescriptionNode classNode, Map packageNodeNames) {
        this.getPackageNodeFor(classNode, packageNodeNames).addClassNode(classNode);
    }

    void removeClassNode(ClassDescriptionNode classNode) {
        ClassDescriptionPackageNode packageNode = this.getPackageNodeFor(classNode, null);
        packageNode.removeClassNode(classNode);
        if (packageNode.isEmpty()) {
            this.removePackageNode(packageNode);
        }
    }

    private void removePackageNode(ClassDescriptionPackageNode packageNode) {
        this.packageNodesHolder.removeItem(this.indexOfPackageNode(packageNode));
        packageNode.setPoolNode(null);
    }

    private int indexOfPackageNode(ClassDescriptionPackageNode packageNode) {
        int size = this.packageNodesHolder.size();
        for (int i = 0; i < size; ++i) {
            if (this.packageNodesHolder.getItem(i) != packageNode) continue;
            return i;
        }
        return -1;
    }

    private ClassDescriptionPackageNode getPackageNodeFor(ClassDescriptionNode classNode, Map packageNodeNames) {
        ClassDescriptionPackageNode packageNode = null;
        ListIterator stream = this.packageNodes();
        while (stream.hasNext()) {
            ClassDescriptionPackageNode next = (ClassDescriptionPackageNode)stream.next();
            if (!classNode.belongsInPackageNode(next)) continue;
            packageNode = next;
            break;
        }
        if (packageNode == null) {
            ClassDescriptionPackageNode prev;
            packageNode = classNode.buildPackageNode(this);
            if (packageNodeNames != null && (prev = packageNodeNames.put(packageNode.getName(), packageNode)) != null) {
                prev.setDisplaysAdditionalInfo(true);
                packageNode.setDisplaysAdditionalInfo(true);
            }
            this.packageNodesHolder.addItem(this.packageNodesHolder.size(), packageNode);
        }
        return packageNode;
    }

    Icon getPackageIcon() {
        return this.packageIcon;
    }

    Icon getClassIcon() {
        return this.classIcon;
    }

    Collator getCollator() {
        return this.collator;
    }

    public Object getValue() {
        return this.value;
    }

    public TreeNodeValueModel getParent() {
        return null;
    }

    public ListValueModel getChildrenModel() {
        return this.sortedPackageNodesHolder;
    }

    protected void engageValue() {
    }

    protected void disengageValue() {
    }

    public void addClassDescriptionNodesTo(Collection classDescriptionNodes) {
        ListIterator stream = this.packageNodes();
        while (stream.hasNext()) {
            ((ClassDescriptionPackageNode)stream.next()).addClassDescriptionNodesTo(classDescriptionNodes);
        }
    }

    public int compareTo(Object o) {
        return DEFAULT_COMPARATOR.compare(this, o);
    }

    public String displayString() {
        return this.name;
    }

    public Icon icon() {
        return null;
    }

    Iterator classNodes() {
        return new CompositeIterator((Iterator)new TransformationIterator(this.packageNodes()){

            protected Object transform(Object next) {
                return ((ClassDescriptionPackageNode)next).classNodes();
            }
        });
    }

    Iterator userClassDescriptions() {
        return new TransformationIterator(this.classNodes()){

            protected Object transform(Object next) {
                return ((ClassDescriptionNode)next).getUserClassDescription();
            }
        };
    }

    public void toString(StringBuffer sb) {
        sb.append(this.name);
    }
}

