/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.chooser;

import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClasspathClassDescription;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public class ClasspathClassDescriptionRepository
implements ClassDescriptionRepository {
    protected Classpath classpath;

    public ClasspathClassDescriptionRepository(String classpath) {
        this.classpath = new Classpath(classpath);
    }

    public Iterator classDescriptions() {
        return new CompositeIterator(this.entriesClassDescriptions());
    }

    protected Iterator entriesClassDescriptions() {
        return new TransformationIterator(this.classpathEntries()){

            protected Object transform(Object next) {
                return this.classDescriptionsFor((Classpath.Entry)next);
            }

            private Iterator classDescriptionsFor(final Classpath.Entry entry) {
                return new TransformationIterator(entry.classNamesStream(ClasspathClassDescriptionRepository.this.classNameFilter())){

                    protected Object transform(Object next) {
                        return new ClasspathClassDescription((String)next, entry.fileName());
                    }
                };
            }
        };
    }

    protected Iterator classpathEntries() {
        return new ArrayIterator((Object[])this.classpath.getEntries());
    }

    protected Filter classNameFilter() {
        return Filter.NULL_INSTANCE;
    }

    public void refreshClassDescriptions() {
    }
}

