/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import javax.swing.tree.TreeModel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WindowWorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManager;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.ComponentAligner;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExpandablePane;
import org.eclipse.persistence.tools.workbench.uitools.swing.TriStateCheckBox;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.string.BidiStringConverter;

public abstract class AbstractDialog
extends JDialog
implements SwingConstants {
    private WorkbenchContext context;
    protected AbstractPanel container;
    private JPanel customButtonPanel;
    private JPanel rightButtonPanel;
    private Action okAction;
    private Action cancelAction;
    private Action helpAction;
    private Map buttons;
    private boolean built = false;
    private boolean wasConfirmed;

    protected AbstractDialog(WorkbenchContext context) {
        this(context, (String)null);
    }

    protected AbstractDialog(WorkbenchContext context, String title) {
        super((Frame)context.getCurrentWindow(), title, true);
        this.initialize(context);
    }

    protected AbstractDialog(WorkbenchContext context, Dialog owner) {
        this(context, null, owner);
    }

    protected AbstractDialog(WorkbenchContext context, String title, Dialog owner) {
        super(owner, title, true);
        this.initialize(context);
    }

    protected void initialize(WorkbenchContext ctx) {
        this.context = new WindowWorkbenchContext(ctx, this);
        this.initialize();
    }

    protected void initialize() {
        this.buttons = new HashMap();
        this.wasConfirmed = false;
        this.container = new AbstractPanel(new GridBagLayout(), this.getApplicationContext()){};
        this.setDefaultCloseOperation(2);
        this.initializeActions();
        this.initializeDefaultKeyboardActions();
        this.addWindowListener(this.buildWindowListener());
    }

    protected void initializeActions() {
        this.okAction = this.buildOKAction();
        this.cancelAction = this.buildCancelAction();
        this.helpAction = this.buildHelpAction();
    }

    protected void initializeContentPane() {
        GridBagConstraints constraints = new GridBagConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.container.setOpaque(false);
        contentPane.add((Component)this.container, "Center");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 11;
        constraints.insets = new Insets(10, 5, 0, 5);
        Component mainPanel = this.buildMainPanel();
        this.helpManager().addTopicID(mainPanel, this.helpTopicId());
        this.container.add(mainPanel, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 11;
        constraints.insets = new Insets(10, 5, 10, 5);
        this.container.add((Component)new JSeparator(), constraints);
        JPanel buttonPanel = this.buildButtonPanel();
        buttonPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 11;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.container.add((Component)buttonPanel, constraints);
    }

    protected abstract Component buildMainPanel();

    protected JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        ComponentAligner aligner = new ComponentAligner();
        JPanel leftButtonPanel = new JPanel(new GridLayout(1, 0, 5, 5));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 0);
        JButton helpButton = new JButton(this.helpAction);
        this.buttons.put(this.helpAction, helpButton);
        leftButtonPanel.add(helpButton);
        aligner.add(helpButton);
        buttonPanel.add((Component)leftButtonPanel, constraints);
        Box leftCenterButtonPanelSpace = Box.createHorizontalBox();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 10, 0, 0);
        buttonPanel.add((Component)leftCenterButtonPanelSpace, constraints);
        this.customButtonPanel = this.buildCustomButtonPanel(aligner);
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(0, 0, 0, 5);
        buttonPanel.add((Component)this.customButtonPanel, constraints);
        this.rightButtonPanel = new JPanel(new GridLayout(1, 0, 5, 5));
        constraints.gridx = 4;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(0, 0, 0, 5);
        JButton okButton = new JButton(this.okAction);
        this.buttons.put(this.okAction, okButton);
        this.rightButtonPanel.add(okButton);
        aligner.add(okButton);
        JButton cancelButton = new JButton(this.cancelAction);
        this.buttons.put(this.cancelAction, cancelButton);
        if (this.cancelButtonIsVisible()) {
            this.rightButtonPanel.add(cancelButton);
            aligner.add(cancelButton);
        }
        buttonPanel.add((Component)this.rightButtonPanel, constraints);
        this.setDefaultAction(this.okAction);
        return buttonPanel;
    }

    protected JPanel buildCustomButtonPanel(ComponentAligner aligner) {
        JPanel panel = new JPanel(new GridLayout(1, 0, 5, 5));
        Iterator stream = this.buildCustomActions();
        while (stream.hasNext()) {
            this.addCustomAction((Action)stream.next(), panel, aligner);
        }
        return panel;
    }

    protected Iterator buildCustomActions() {
        return NullIterator.instance();
    }

    private void addCustomAction(Action customAction, JPanel panel, ComponentAligner aligner) {
        JButton button = new JButton(customAction);
        panel.add(button);
        aligner.add(button);
        this.buttons.put(customAction, button);
    }

    protected void initializeDefaultKeyboardActions() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", this.cancelAction);
    }

    protected Action getOKAction() {
        return this.okAction;
    }

    protected Action buildOKAction() {
        return new AbstractAction(this.buildOKText()){

            public void actionPerformed(ActionEvent e) {
                AbstractDialog.this.okPressed();
            }
        };
    }

    protected String buildOKText() {
        return this.resourceRepository().getString("DIALOG.OK_BUTTON_TEXT");
    }

    protected void okPressed() {
        if (this.preConfirm()) {
            this.okConfirmed();
        }
    }

    protected boolean preConfirm() {
        return true;
    }

    protected void okConfirmed() {
        this.wasConfirmed = true;
        this.dispose();
    }

    protected Action getCancelAction() {
        return this.cancelAction;
    }

    protected Action buildCancelAction() {
        return new AbstractAction(this.buildCancelText()){

            public void actionPerformed(ActionEvent e) {
                AbstractDialog.this.cancelPressed();
            }
        };
    }

    protected String buildCancelText() {
        return this.resourceRepository().getString("DIALOG.CANCEL_BUTTON_TEXT");
    }

    protected void cancelPressed() {
        this.wasConfirmed = false;
        this.dispose();
    }

    protected boolean cancelButtonIsVisible() {
        return true;
    }

    protected Action getHelpAction() {
        return this.helpAction;
    }

    protected abstract String helpTopicId();

    protected Action buildHelpAction() {
        return new AbstractAction(this.buildHelpText()){

            public void actionPerformed(ActionEvent e) {
                AbstractDialog.this.helpPressed();
            }
        };
    }

    protected String buildHelpText() {
        return this.resourceRepository().getString("DIALOG.HELP_BUTTON_TEXT");
    }

    protected void helpPressed() {
        this.helpManager().showTopic(this.getContentPane());
    }

    protected JButton getButtonFor(Action action) {
        return (JButton)this.buttons.get(action);
    }

    protected void setDefaultAction(Action action) {
        this.getRootPane().setDefaultButton(this.getButtonFor(action));
    }

    protected Component initialFocusComponent() {
        return null;
    }

    public void show() {
        if (!this.built) {
            this.initializeContentPane();
            this.built = true;
        }
        this.wasConfirmed = false;
        this.helpManager().addTopicID(this.getContentPane(), this.helpTopicId());
        this.prepareToShow();
        super.show();
    }

    protected void prepareToShow() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    protected WindowListener buildWindowListener() {
        return new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                AbstractDialog.this.windowOpened();
            }
        };
    }

    protected void windowOpened() {
        Component component = this.initialFocusComponent();
        if (component != null) {
            component.requestFocusInWindow();
        }
    }

    public void dispose() {
        super.dispose();
    }

    public boolean wasConfirmed() {
        return this.wasConfirmed;
    }

    public boolean wasCanceled() {
        return !this.wasConfirmed();
    }

    protected void click(Action action) {
        this.getButtonFor(action).doClick();
    }

    protected void clickOK() {
        this.click(this.okAction);
    }

    protected void clickCancel() {
        this.click(this.cancelAction);
    }

    public ApplicationContext getApplicationContext() {
        return this.context.getApplicationContext();
    }

    public WorkbenchContext getWorkbenchContext() {
        return this.context;
    }

    public ResourceRepository resourceRepository() {
        return this.getApplicationContext().getResourceRepository();
    }

    public HelpManager helpManager() {
        return this.getApplicationContext().getHelpManager();
    }

    public Window currentWindow() {
        return this.getWorkbenchContext().getCurrentWindow();
    }

    public Preferences preferences() {
        return this.getApplicationContext().getPreferences();
    }

    public static Runnable buildDialogLauncher(final Dialog d) {
        return new Runnable(){

            public void run() {
                d.show();
            }
        };
    }

    public static void launchLater(Dialog d) {
        EventQueue.invokeLater(AbstractDialog.buildDialogLauncher(d));
    }

    public static void launchAndWait(Dialog d) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(AbstractDialog.buildDialogLauncher(d));
    }

    protected final ExpandablePane buildExpandablePanel(String key, JComponent internalPane) {
        return SwingComponentFactory.buildExpandablePanel(key, internalPane, this.resourceRepository());
    }

    protected final ExpandablePane buildExpandablePanel(String key, JComponent internalPane, boolean expanded) {
        return SwingComponentFactory.buildExpandablePanel(key, internalPane, expanded, this.resourceRepository());
    }

    protected final ExpandablePane buildExpandablePanel(String expandedTextKey, String collapsedTextKey, JComponent internalPane) {
        return SwingComponentFactory.buildExpandablePanel(expandedTextKey, collapsedTextKey, internalPane, this.resourceRepository());
    }

    protected final ExpandablePane buildExpandablePanel(String expandedTextKey, String collapsedTextKey, JComponent internalPane, boolean expanded) {
        return SwingComponentFactory.buildExpandablePanel(expandedTextKey, collapsedTextKey, internalPane, expanded, this.resourceRepository());
    }

    protected final JLabel buildLabel(String key) {
        return SwingComponentFactory.buildLabel(key, this.resourceRepository());
    }

    protected final JComponent buildLabeledComboBox(String key, ComboBoxModel model) {
        return SwingComponentFactory.buildLabeledComboBox(key, model, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledComboBox(String key, ComboBoxModel model, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledComboBox(key, model, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledComboBox(String key, ComboBoxModel model, ListCellRenderer renderer) {
        return SwingComponentFactory.buildLabeledComboBox(key, model, renderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledComboBox(String key, ComboBoxModel model, CellRendererAdapter renderer) {
        return SwingComponentFactory.buildLabeledComboBox(key, model, renderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledComboBox(String key, ComboBoxModel model, ListCellRenderer renderer, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledComboBox(key, model, renderer, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledComponent(JComponent leftComponent, JComponent centerComponent, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledComponent(leftComponent, centerComponent, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledComponent(String key, JComponent component) {
        return SwingComponentFactory.buildLabeledComponent(key, component, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledComponent(String key, JComponent component, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledComponent(key, component, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder) {
        return SwingComponentFactory.buildLabeledEditableComboBox(key, model, subjectHolder, valueHolder, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledEditableComboBox(key, model, subjectHolder, valueHolder, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer) {
        return SwingComponentFactory.buildLabeledEditableComboBox(key, model, subjectHolder, valueHolder, renderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter) {
        return SwingComponentFactory.buildLabeledEditableComboBox(key, model, subjectHolder, valueHolder, renderer, editorValueConverter, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue) {
        return SwingComponentFactory.buildLabeledEditableComboBox(key, model, subjectHolder, valueHolder, renderer, editorValueConverter, nullValue, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledEditableComboBox(key, model, subjectHolder, valueHolder, renderer, editorValueConverter, nullValue, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledEditableComboBox(key, model, subjectHolder, valueHolder, renderer, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, Object nullValue) {
        return SwingComponentFactory.buildLabeledEditableComboBox(key, model, subjectHolder, valueHolder, renderer, nullValue, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder) {
        return SwingComponentFactory.buildLabeledEditableComboBox(key, model, subjectHolder, valueHolder, defaultValueHolder, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledEditableComboBox(key, model, subjectHolder, valueHolder, defaultValueHolder, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer) {
        return SwingComponentFactory.buildLabeledEditableComboBox(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter) {
        return SwingComponentFactory.buildLabeledEditableComboBox(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, editorValueConverter, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue) {
        return SwingComponentFactory.buildLabeledEditableComboBox(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, editorValueConverter, nullValue, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledEditableComboBox(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, editorValueConverter, nullValue, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledEditableComboBox(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, Object nullValue) {
        return SwingComponentFactory.buildLabeledEditableComboBox(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, nullValue, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder) {
        return SwingComponentFactory.buildLabeledEditableListChooser(key, model, subjectHolder, valueHolder, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledEditableListChooser(key, model, subjectHolder, valueHolder, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer) {
        return SwingComponentFactory.buildLabeledEditableListChooser(key, model, subjectHolder, valueHolder, renderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter) {
        return SwingComponentFactory.buildLabeledEditableListChooser(key, model, subjectHolder, valueHolder, renderer, editorValueConverter, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue) {
        return SwingComponentFactory.buildLabeledEditableListChooser(key, model, subjectHolder, valueHolder, renderer, editorValueConverter, nullValue, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledEditableListChooser(key, model, subjectHolder, valueHolder, renderer, editorValueConverter, nullValue, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledEditableListChooser(key, model, subjectHolder, valueHolder, renderer, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, Object nullValue) {
        return SwingComponentFactory.buildLabeledEditableListChooser(key, model, subjectHolder, valueHolder, renderer, nullValue, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, Object nullValue) {
        return SwingComponentFactory.buildLabeledEditableListChooser(key, model, subjectHolder, valueHolder, nullValue, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, Object nullValue, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledEditableListChooser(key, model, subjectHolder, valueHolder, nullValue, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder) {
        return SwingComponentFactory.buildLabeledEditableListChooser(key, model, subjectHolder, valueHolder, defaultValueHolder, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledEditableListChooser(key, model, subjectHolder, valueHolder, defaultValueHolder, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer) {
        return SwingComponentFactory.buildLabeledEditableListChooser(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter) {
        return SwingComponentFactory.buildLabeledEditableListChooser(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, editorValueConverter, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue) {
        return SwingComponentFactory.buildLabeledEditableListChooser(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, editorValueConverter, nullValue, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledEditableListChooser(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, Object nullValue) {
        return SwingComponentFactory.buildLabeledEditableListChooser(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, nullValue, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, Object nullValue) {
        return SwingComponentFactory.buildLabeledEditableListChooser(key, model, subjectHolder, valueHolder, defaultValueHolder, nullValue, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, Object nullValue, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledEditableListChooser(key, model, subjectHolder, valueHolder, defaultValueHolder, nullValue, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledListChooser(String key, ComboBoxModel model) {
        return SwingComponentFactory.buildLabeledListChooser(key, model, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledListChooser(String key, ComboBoxModel model, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledListChooser(key, model, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledListChooser(String key, ComboBoxModel model, ListCellRenderer renderer) {
        return SwingComponentFactory.buildLabeledListChooser(key, model, renderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledListChooser(String key, ComboBoxModel model, ListCellRenderer renderer, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledListChooser(key, model, renderer, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledNonEditableTextField(String key, Document document) {
        return SwingComponentFactory.buildLabeledNonEditableTextField(key, document, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledNonEditableTextField(String key, Document document, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledNonEditableTextField(key, document, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledSpinnerDate(String labelKey, SpinnerDateModel model) {
        return SwingComponentFactory.buildLabeledSpinnerDate(labelKey, model, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledSpinnerNumber(String key, SpinnerNumberModel model) {
        return SwingComponentFactory.buildLabeledSpinnerNumber(key, model, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledSpinnerNumber(String key, SpinnerNumberModel model, int columns) {
        return SwingComponentFactory.buildLabeledSpinnerNumber(key, model, columns, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledTextField(String key, Document document) {
        return SwingComponentFactory.buildLabeledTextField(key, document, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledTextField(String key, Document document, int columns) {
        return SwingComponentFactory.buildLabeledTextField(key, document, columns, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledTextField(String key, Document document, int columns, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledTextField(key, document, columns, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledTextField(String key, Document document, JComponent rightComponent) {
        return SwingComponentFactory.buildLabeledTextField(key, document, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledTextField(String key, Document document, JTextField field) {
        return SwingComponentFactory.buildLabeledTextField(key, document, field, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final ListChooser buildListChooser(ComboBoxModel model) {
        return SwingComponentFactory.buildListChooser(model);
    }

    protected final ListChooser buildListChooser(ComboBoxModel model, ListCellRenderer cellRenderer) {
        return SwingComponentFactory.buildListChooser(model, cellRenderer);
    }

    protected final Border buildPaneTitledBorder(String key) {
        return SwingComponentFactory.buildPaneTitledBorder(key, this.resourceRepository());
    }

    protected final JRadioButton buildRadioButton(String key, ButtonModel buttonModel) {
        return SwingComponentFactory.buildRadioButton(key, buttonModel, this.resourceRepository());
    }

    protected final JSpinner buildSpinnerDate(SpinnerDateModel model) {
        return SwingComponentFactory.buildSpinnerDate(model);
    }

    protected final JSpinner buildSpinnerNumber(SpinnerNumberModel model) {
        return SwingComponentFactory.buildSpinnerNumber(model);
    }

    protected final JSpinner buildSpinnerNumber(SpinnerNumberModel model, int columns) {
        return SwingComponentFactory.buildSpinnerNumber(model, columns);
    }

    protected final JTable buildTable(TableModel tableModel) {
        return SwingComponentFactory.buildTable(tableModel);
    }

    protected final JTable buildTable(TableModel tableModel, ListSelectionModel listSelectionModel) {
        return SwingComponentFactory.buildTable(tableModel, listSelectionModel);
    }

    protected final JTable buildTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        return SwingComponentFactory.buildTable(tableModel, tableColumnModel, listSelectionModel);
    }

    protected final JTextField buildTextField(Document document) {
        return SwingComponentFactory.buildTextField(document);
    }

    protected final Border buildTitledBorder(String key) {
        return SwingComponentFactory.buildTitledBorder(key, this.resourceRepository());
    }

    protected final JToggleButton buildToggleButton(String key) {
        return SwingComponentFactory.buildToggleButton(key, this.resourceRepository());
    }

    protected final JComponent buildTopLabeledComboBox(String key, ComboBoxModel model) {
        return SwingComponentFactory.buildTopLabeledComboBox(key, model, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledComboBox(String key, ComboBoxModel model, JComponent rightComponent) {
        return SwingComponentFactory.buildTopLabeledComboBox(key, model, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledComboBox(String key, ComboBoxModel model, ListCellRenderer renderer) {
        return SwingComponentFactory.buildTopLabeledComboBox(key, model, renderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledComboBox(String key, ComboBoxModel model, ListCellRenderer renderer, JComponent rightComponent) {
        return SwingComponentFactory.buildTopLabeledComboBox(key, model, renderer, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledComponent(JComponent leftComponent, JComponent centerComponent, JComponent rightComponent) {
        return SwingComponentFactory.buildTopLabeledComponent(leftComponent, centerComponent, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledComponent(String key, JComponent component) {
        return SwingComponentFactory.buildTopLabeledComponent(key, component, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledComponent(String key, JComponent component, JComponent rightComponent) {
        return SwingComponentFactory.buildTopLabeledComponent(key, component, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder) {
        return SwingComponentFactory.buildTopLabeledEditableComboBox(key, model, subjectHolder, valueHolder, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer) {
        return SwingComponentFactory.buildTopLabeledEditableComboBox(key, model, subjectHolder, valueHolder, renderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter) {
        return SwingComponentFactory.buildTopLabeledEditableComboBox(key, model, subjectHolder, valueHolder, renderer, editorValueConverter, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue) {
        return SwingComponentFactory.buildTopLabeledEditableComboBox(key, model, subjectHolder, valueHolder, renderer, editorValueConverter, nullValue, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, Object nullValue) {
        return SwingComponentFactory.buildTopLabeledEditableComboBox(key, model, subjectHolder, valueHolder, renderer, nullValue, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder) {
        return SwingComponentFactory.buildTopLabeledEditableComboBox(key, model, subjectHolder, valueHolder, defaultValueHolder, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer) {
        return SwingComponentFactory.buildTopLabeledEditableComboBox(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter) {
        return SwingComponentFactory.buildTopLabeledEditableComboBox(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, editorValueConverter, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue) {
        return SwingComponentFactory.buildTopLabeledEditableComboBox(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, editorValueConverter, nullValue, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, Object nullValue) {
        return SwingComponentFactory.buildTopLabeledEditableComboBox(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, nullValue, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(key, model, subjectHolder, valueHolder, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, JComponent rightComponent) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(key, model, subjectHolder, valueHolder, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(key, model, subjectHolder, valueHolder, renderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(key, model, subjectHolder, valueHolder, renderer, editorValueConverter, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(key, model, subjectHolder, valueHolder, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, Object nullValue) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(key, model, subjectHolder, valueHolder, renderer, nullValue, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, Object nullValue) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(key, model, subjectHolder, valueHolder, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, Object nullValue, JComponent rightComponent) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(key, model, subjectHolder, valueHolder, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(key, model, subjectHolder, valueHolder, defaultValueHolder, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, JComponent rightComponent) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(key, model, subjectHolder, valueHolder, defaultValueHolder, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, editorValueConverter, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, editorValueConverter, nullValue, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, Object nullValue) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, nullValue, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, Object nullValue) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(key, model, subjectHolder, valueHolder, defaultValueHolder, nullValue, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, Object nullValue, JComponent rightComponent) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(key, model, subjectHolder, valueHolder, defaultValueHolder, nullValue, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledListChooser(String key, ComboBoxModel model) {
        return SwingComponentFactory.buildTopLabeledListChooser(key, model, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledListChooser(String key, ComboBoxModel model, JComponent rightComponent) {
        return SwingComponentFactory.buildTopLabeledListChooser(key, model, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledListChooser(String key, ComboBoxModel model, ListCellRenderer cellRenderer) {
        return SwingComponentFactory.buildTopLabeledListChooser(key, model, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledListChooser(String key, ComboBoxModel model, ListCellRenderer renderer, JComponent rightComponent) {
        return SwingComponentFactory.buildTopLabeledListChooser(key, model, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledNonEditableTextField(String key, Document document, JComponent rightComponent, ResourceRepository repository) {
        return SwingComponentFactory.buildTopLabeledNonEditableTextField(key, document, rightComponent, repository, this.getAlignRightGroup(), this.getAlignLeftGroup());
    }

    protected final JComponent buildTopLabeledSpinnerNumber(String key, SpinnerNumberModel model, int columns) {
        return SwingComponentFactory.buildLabeledSpinnerNumber(key, model, columns, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledTextField(String key, Document document) {
        return SwingComponentFactory.buildTopLabeledTextField(key, document, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledTextField(String key, Document document, JComponent rightComponent) {
        return SwingComponentFactory.buildTopLabeledTextField(key, document, rightComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JTree buildTree(TreeModel model) {
        return SwingComponentFactory.buildTree(model);
    }

    protected final TriStateCheckBox buildTriStateCheckBox(String key, TriStateCheckBox.TriStateButtonModel model) {
        return SwingComponentFactory.buildTriStateCheckBox(key, model, this.resourceRepository());
    }

    private ComponentAligner getAlignLeftGroup() {
        return this.container.getAlignLeftGroup();
    }

    private ComponentAligner getAlignRightGroup() {
        return this.container.getAlignRightGroup();
    }
}

