/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import javax.swing.tree.TreeModel;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.ComponentAligner;
import org.eclipse.persistence.tools.workbench.framework.uitools.DoubleClickMouseListener;
import org.eclipse.persistence.tools.workbench.framework.uitools.DoubleClickTrigger;
import org.eclipse.persistence.tools.workbench.framework.uitools.Pane;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.app.NullPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.ComboBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.Combo;
import org.eclipse.persistence.tools.workbench.uitools.swing.ComboBoxEditorAdapter;
import org.eclipse.persistence.tools.workbench.uitools.swing.ComboBoxEditorWithDefault;
import org.eclipse.persistence.tools.workbench.uitools.swing.ComboBoxModelWithDefaultHandler;
import org.eclipse.persistence.tools.workbench.uitools.swing.EmptyIcon;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExpandablePane;
import org.eclipse.persistence.tools.workbench.uitools.swing.SpinnerWithDefaultHandler;
import org.eclipse.persistence.tools.workbench.uitools.swing.TriStateCheckBox;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.eclipse.persistence.tools.workbench.utility.string.BidiStringConverter;

public class SwingComponentFactory {
    private static DoubleClickMouseHandler doubleClickMouseHandler = new DoubleClickMouseHandler();
    private static Border STANDARD_EMPTY_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String LABELED_BY_KEY = "labeledBy";

    public static void addDoubleClickMouseListener(Component component, DoubleClickMouseListener listener) {
        Object[] listeners = (MouseListener[])component.getListeners(MouseListener.class);
        if (!CollectionTools.contains((Object[])listeners, (Object)doubleClickMouseHandler)) {
            component.addMouseListener(doubleClickMouseHandler);
        }
        doubleClickMouseHandler.addMouseListener(component, listener);
    }

    public static JButton buildButton(String key, ResourceRepository resourceRepository) {
        JButton button = new JButton();
        button.setName(key);
        SwingComponentFactory.setTextFor(button, key, resourceRepository);
        return button;
    }

    public static final JButton buildBrowseButton(String key, ResourceRepository resourceRepository, Accessible labeler) {
        BrowseButton button = new BrowseButton(labeler);
        button.setName(key);
        SwingComponentFactory.setTextFor(button, key, resourceRepository);
        return button;
    }

    public static JCheckBox buildCheckBox(String key, ButtonModel buttonModel, ResourceRepository resourceRepository) {
        JCheckBox checkBox = new JCheckBox();
        checkBox.setModel(buttonModel);
        checkBox.setName(key);
        SwingComponentFactory.setTextFor(checkBox, key, resourceRepository);
        return checkBox;
    }

    private static PropertyValueModel buildCommentAdapter(ValueModel nodeModelHolder) {
        return new PropertyAspectAdapter(nodeModelHolder, "comment"){

            protected Object getValueFromSubject() {
                return ((AbstractNodeModel)this.subject).getComment();
            }

            protected void setValueOnSubject(Object value) {
                ((AbstractNodeModel)this.subject).setComment((String)value);
            }
        };
    }

    private static Document buildCommentDocument(ValueModel nodeModelHolder) {
        return new DocumentAdapter(SwingComponentFactory.buildCommentAdapter(nodeModelHolder));
    }

    public static JComponent buildCommentPanel(ValueModel nodeModelHolder, ResourceRepository resourceRepository) {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel label = SwingComponentFactory.buildLabel("COMMENT_LABEL", resourceRepository);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)label, constraints);
        JTextArea textArea = new JTextArea(SwingComponentFactory.buildCommentDocument(nodeModelHolder));
        textArea.setFont(label.getFont());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 0, 0, 0);
        JScrollPane scrollPane = new JScrollPane(textArea);
        panel.add((Component)scrollPane, constraints);
        label.setLabelFor(textArea);
        int height = textArea.getFontMetrics(textArea.getFont()).getHeight();
        Insets borderInsets = textArea.getBorder().getBorderInsets(textArea);
        height = 2 * height + borderInsets.top + borderInsets.bottom;
        Dimension size = new Dimension(10, height);
        scrollPane.getViewport().setPreferredSize(size);
        scrollPane.getViewport().setMinimumSize(size);
        scrollPane.getViewport().setMaximumSize(size);
        return panel;
    }

    public static JComponent buildDoNotAskAgainPanel(String message, PropertyValueModel resultHolder, ResourceRepository resourceRepository) {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel container = new JPanel(new GridBagLayout());
        LabelArea label = new LabelArea(message);
        label.setScrollable(true);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)label, constraints);
        JCheckBox dontAskMeAgainCheckBox = SwingComponentFactory.buildCheckBox("DONT_SHOW_THIS_AGAIN_CHECK_BOX", new CheckBoxModelAdapter(resultHolder), resourceRepository);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(20, 0, 0, 0);
        container.add((Component)dontAskMeAgainCheckBox, constraints);
        return container;
    }

    public static JLabel buildLabel(String key, ResourceRepository resourceRepository) {
        JLabel label = new JLabel();
        label.setName(key);
        SwingComponentFactory.setTextFor(label, key, resourceRepository);
        return label;
    }

    public static JList buildList() {
        return new AccessibleList();
    }

    public static JList buildList(ListModel model) {
        return new AccessibleList(model);
    }

    public static JList buildList(Vector items) {
        return new AccessibleList(items);
    }

    public static Border buildTitledBorder(ResourceRepository resourceRepository, String key) {
        return BorderFactory.createTitledBorder(resourceRepository.getString(key));
    }

    public static JRadioButton buildRadioButton(String key, ButtonModel buttonModel, ResourceRepository resourceRepository) {
        JRadioButton radioButton = new JRadioButton();
        radioButton.setModel(buttonModel);
        radioButton.setName(key);
        SwingComponentFactory.setTextFor(radioButton, key, resourceRepository);
        return radioButton;
    }

    public static JSpinner buildSpinnerNumber(SpinnerNumberModel model) {
        return SwingComponentFactory.buildSpinnerNumber(model, 4);
    }

    public static JSpinner buildSpinnerNumber(SpinnerNumberModel model, int columns) {
        JSpinner spinner;
        block2: {
            spinner = new JSpinner(model);
            JSpinner.NumberEditor editor = (JSpinner.NumberEditor)spinner.getEditor();
            JFormattedTextField textField = editor.getTextField();
            textField.setColumns(columns);
            try {
                String value = textField.getFormatter().valueToString(model.getValue());
                textField.setText(value);
            }
            catch (ParseException e) {
                if (model.getValue() == null) break block2;
                textField.setText(model.getValue().toString());
            }
        }
        return spinner;
    }

    public static Border buildStandardEmptyBorder() {
        return STANDARD_EMPTY_BORDER;
    }

    public static JTable buildTable(TableModel tableModel) {
        return SwingComponentFactory.buildTable(tableModel, null, null);
    }

    public static JTable buildTable(TableModel tableModel, ListSelectionModel selectionModel) {
        return SwingComponentFactory.buildTable(tableModel, null, selectionModel);
    }

    public static JTable buildTable(TableModel tableModel, TableColumnModel columnModel, ListSelectionModel selectionModel) {
        InternalJTable table = new InternalJTable(tableModel, columnModel, selectionModel);
        table.setDoubleBuffered(true);
        table.setAutoResizeMode(1);
        return table;
    }

    public static void attachTableEditorCanceler(final JTable table, ValueModel subjectHolder) {
        subjectHolder.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (table.isEditing()) {
                    table.getCellEditor().cancelCellEditing();
                }
            }
        });
    }

    public static void attachDateSpinnerCommiter(final JSpinner spinner, ValueModel subjectHolder) {
        subjectHolder.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    spinner.commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
    }

    public static JTextField buildTextField(Document document) {
        JTextField textField = new JTextField();
        textField.setDocument(document);
        return textField;
    }

    public static JTree buildTree() {
        return new AccessibleTree();
    }

    public static JTree buildTree(TreeModel model) {
        return new AccessibleTree(model);
    }

    public static void installCellRenderer(JComboBox comboBox, ListCellRenderer cellRenderer) {
        comboBox.setPrototypeDisplayValue(ComboBoxTableCellRenderer.prototypeLabel);
        comboBox.setRenderer(new InternalListCellRenderer(cellRenderer, comboBox.getRenderer()));
    }

    public static void installComboBoxEditorWithDefault(JComboBox comboBox, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, BidiStringConverter editorValueConverter, Object nullValue) {
        SwingComponentFactory.installComboBoxEditorWithDefault(comboBox, subjectHolder, valueHolder, defaultValueHolder, editorValueConverter, nullValue, null);
    }

    public static void installComboBoxEditorWithDefault(JComboBox comboBox, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, BidiStringConverter editorValueConverter, Object nullValue, CellRendererAdapter cellRendererAdapter) {
        comboBox.setEditable(true);
        ComboBoxEditorWithDefault comboBoxEditor = new ComboBoxEditorWithDefault(comboBox.getEditor(), subjectHolder, valueHolder, defaultValueHolder, cellRendererAdapter);
        ComboBoxEditorAdapter editor = new ComboBoxEditorAdapter(comboBoxEditor, editorValueConverter, nullValue);
        comboBox.setEditor(editor);
    }

    public static void removeDoubleClickMouseListener(Component component, DoubleClickMouseListener listener) {
        doubleClickMouseHandler.removeMouseListener(component, listener);
        if (!doubleClickMouseHandler.hasListeners(component)) {
            component.removeMouseListener(doubleClickMouseHandler);
        }
    }

    public static void setTextFor(AbstractButton button, String key, Object[] arguments, ResourceRepository resourceRepository) {
        button.setText(resourceRepository.getString(key, arguments));
        button.setMnemonic(resourceRepository.getMnemonic(key));
        button.setDisplayedMnemonicIndex(resourceRepository.getMnemonicIndex(key));
    }

    public static void setTextFor(AbstractButton button, String key, ResourceRepository resourceRepository) {
        SwingComponentFactory.setTextFor(button, key, EMPTY_OBJECT_ARRAY, resourceRepository);
    }

    public static void setTextFor(JLabel label, String key, Object argument, ResourceRepository resourceRepository) {
        SwingComponentFactory.setTextFor(label, key, new Object[]{argument}, resourceRepository);
    }

    public static void setTextFor(JLabel label, String key, Object[] arguments, ResourceRepository resourceRepository) {
        label.setText(resourceRepository.getString(key, arguments));
        label.setDisplayedMnemonic(resourceRepository.getMnemonic(key));
        label.setDisplayedMnemonicIndex(resourceRepository.getMnemonicIndex(key));
    }

    public static void setTextFor(JLabel label, String key, ResourceRepository resourceRepository) {
        SwingComponentFactory.setTextFor(label, key, EMPTY_OBJECT_ARRAY, resourceRepository);
    }

    public static void updateButtonAccessibleName(JLabel label, AbstractButton button) {
        StringBuffer sb = new StringBuffer();
        sb.append(label.getAccessibleContext().getAccessibleName());
        sb.append(" ");
        sb.append(button.getAccessibleContext().getAccessibleName());
        button.getAccessibleContext().setAccessibleName(sb.toString());
    }

    public static Border buildTitledBorder(String key, ResourceRepository repository) {
        return BorderFactory.createTitledBorder(repository.getString(key));
    }

    public static Border buildPaneTitledBorder(String key, ResourceRepository repository) {
        return BorderFactory.createCompoundBorder(SwingComponentFactory.buildTitledBorder(key, repository), BorderFactory.createEmptyBorder(0, 5, 5, 5));
    }

    public static ExpandablePane buildExpandablePanel(String key, JComponent internalPane, boolean expanded, ResourceRepository repository) {
        return SwingComponentFactory.buildExpandablePanel(key, key, internalPane, expanded, repository);
    }

    public static ExpandablePane buildExpandablePanel(String key, JComponent internalPane, ResourceRepository repository) {
        return SwingComponentFactory.buildExpandablePanel(key, key, internalPane, false, repository);
    }

    public static ExpandablePane buildExpandablePanel(String expandedTextKey, String collapsedTextKey, JComponent internalPane, boolean expanded, ResourceRepository repository) {
        return new ExpandablePane(repository.getString(expandedTextKey), repository.getString(collapsedTextKey), repository.getIcon("expand"), repository.getIcon("collapse"), repository.getIcon("expand.disabled"), repository.getIcon("collapse.disabled"), repository.getIcon("expand.focus"), repository.getIcon("collapse.focus"), repository.getIcon("expand.pressed"), repository.getIcon("collapse.pressed"), internalPane, expanded);
    }

    public static ExpandablePane buildExpandablePanel(String expandedTextKey, String collapsedTextKey, JComponent internalPane, ResourceRepository repository) {
        return SwingComponentFactory.buildExpandablePanel(expandedTextKey, collapsedTextKey, internalPane, false, repository);
    }

    public static JComponent buildLabeledComboBox(String key, ComboBoxModel model, CellRendererAdapter rendererAdapter, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComboBoxImp(key, model, rendererAdapter, rightComponent, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledComboBox(String key, ComboBoxModel model, CellRendererAdapter renderer, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComboBoxImp(key, model, renderer, null, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledComboBox(String key, ComboBoxModel model, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComboBoxImp(key, model, (CellRendererAdapter)null, rightComponent, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledComboBox(String key, ComboBoxModel model, ListCellRenderer renderer, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComboBoxImp(key, model, renderer, rightComponent, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledComboBox(String key, ComboBoxModel model, ListCellRenderer renderer, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComboBoxImp(key, model, renderer, null, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledComboBox(String key, ComboBoxModel model, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComboBoxImp(key, model, (CellRendererAdapter)null, null, null, repository, leftAligner, rightAligner, false, false);
    }

    private static JComponent buildLabeledComboBoxImp(String key, ComboBoxModel model, CellRendererAdapter rendererAdapter, JComponent rightComponent, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner, boolean topAlignedLabel, boolean listChooser) {
        return SwingComponentFactory.buildLabeledComponent(key, (JComponent)(listChooser ? SwingComponentFactory.buildListChooser(model, rendererAdapter) : SwingComponentFactory.buildComboBox(model, rendererAdapter)), rightComponent == null ? new Spacer() : rightComponent, repository, leftAligner, rightAligner, topAlignedLabel);
    }

    private static JComponent buildLabeledComboBoxImp(String key, ComboBoxModel model, ListCellRenderer renderer, JComponent rightComponent, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner, boolean topAlignedLabel, boolean listChooser) {
        return SwingComponentFactory.buildLabeledComponent(key, (JComponent)(listChooser ? SwingComponentFactory.buildListChooser(model, renderer) : SwingComponentFactory.buildComboBox(model, renderer)), rightComponent == null ? new Spacer() : rightComponent, repository, leftAligner, rightAligner, topAlignedLabel);
    }

    public static Combo buildComboBox(ComboBoxModel model, ListCellRenderer cellRenderer) {
        Combo combo = SwingComponentFactory.buildComboBox(model);
        if (cellRenderer != null) {
            SwingComponentFactory.installCellRenderer(combo, cellRenderer);
        }
        return combo;
    }

    public static Combo buildComboBox(ComboBoxModel model) {
        Combo combo = new Combo(model);
        return combo;
    }

    public static ListChooser buildListChooser(ComboBoxModel model, ListCellRenderer cellRenderer) {
        ListChooser comboBox = SwingComponentFactory.buildListChooser(model);
        if (cellRenderer != null) {
            SwingComponentFactory.installCellRenderer(comboBox, cellRenderer);
        }
        return comboBox;
    }

    public static ListChooser buildListChooser(ComboBoxModel model) {
        ListChooser chooser = model instanceof CachingComboBoxModel ? new ListChooser((CachingComboBoxModel)model) : new ListChooser(model);
        chooser.setLongListSize(Integer.MAX_VALUE);
        return chooser;
    }

    public static JComponent buildLabeledComponent(String key, JComponent component, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComponent(key, component, rightComponent, repository, leftAligner, rightAligner, false);
    }

    public static JComponent buildLabeledComponent(String key, JComponent component, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComponent(key, component, (JComponent)new Spacer(), repository, leftAligner, rightAligner);
    }

    private static JComponent buildLabeledComponent(String key, JComponent centerComponent, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner, boolean topAlignedLabel) {
        return SwingComponentFactory.buildLabeledComponent(SwingComponentFactory.buildLabel(key, repository), centerComponent, rightComponent, repository, leftAligner, rightAligner, topAlignedLabel);
    }

    public static JComponent buildLabeledComponent(JComponent leftComponent, JComponent centerComponent, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComponent(leftComponent, centerComponent, rightComponent, repository, leftAligner, rightAligner, false);
    }

    private static JComponent buildLabeledComponent(JComponent leftComponent, JComponent centerComponent, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner, boolean topAlignedLabel) {
        GridBagConstraints constraints = new GridBagConstraints();
        Pane pane = new Pane(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = topAlignedLabel ? 2 : 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        pane.add((Component)leftComponent, constraints);
        leftAligner.add(leftComponent);
        constraints.gridx = topAlignedLabel ? 0 : 1;
        constraints.gridy = topAlignedLabel ? 1 : 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(topAlignedLabel ? 1 : 0, topAlignedLabel ? 0 : 5, 0, 0);
        if (centerComponent instanceof JScrollPane || centerComponent instanceof Scrollable) {
            constraints.weighty = 1.0;
            constraints.fill = 1;
        } else {
            constraints.weighty = 0.0;
            constraints.fill = 2;
        }
        pane.add((Component)centerComponent, constraints);
        if (leftComponent instanceof JLabel) {
            JLabel label = (JLabel)leftComponent;
            label.setLabelFor(centerComponent);
        } else {
            centerComponent.putClientProperty(LABELED_BY_KEY, leftComponent);
        }
        if (rightComponent != null) {
            constraints.gridx = topAlignedLabel ? 1 : 2;
            constraints.gridy = topAlignedLabel ? 1 : 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            constraints.anchor = 21;
            constraints.insets = new Insets(topAlignedLabel ? 1 : 0, 5, 0, 0);
            pane.add((Component)rightComponent, constraints);
            rightAligner.add(rightComponent);
            if (rightComponent instanceof AbstractButton && leftComponent instanceof Accessible) {
                SwingComponentFactory.updateButtonAccessibleName((Accessible)((Object)leftComponent), rightComponent);
            }
        }
        return pane;
    }

    private static JComponent buildLabeledEditableComboBoxImp(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner, boolean topAlignedLabel, boolean listChooser) {
        JComponent container = SwingComponentFactory.buildLabeledComboBoxImp(key, (ComboBoxModel)new ComboBoxModelWithDefaultHandler(model, defaultValueHolder), renderer, rightComponent, nullValue, repository, leftAligner, rightAligner, topAlignedLabel, listChooser);
        JComboBox comboBox = (JComboBox)container.getComponent(1);
        SwingComponentFactory.installComboBoxEditorWithDefault(comboBox, subjectHolder, valueHolder, defaultValueHolder, editorValueConverter, nullValue);
        return container;
    }

    public static void updateButtonAccessibleName(Accessible accessible, JComponent button) {
        StringBuilder sb = new StringBuilder();
        sb.append(accessible.getAccessibleContext().getAccessibleName());
        sb.append(' ');
        sb.append(button.getAccessibleContext().getAccessibleName());
        button.getAccessibleContext().setAccessibleName(sb.toString());
    }

    public static ListChooser buildListChooser(ComboBoxModel model, CellRendererAdapter cellRendererAdapter) {
        ListChooser chooser = SwingComponentFactory.buildListChooser(model);
        if (cellRendererAdapter != null) {
            chooser.setRendererAdapter(cellRendererAdapter);
        }
        return chooser;
    }

    public static Combo buildComboBox(ComboBoxModel model, CellRendererAdapter cellRendererAdapter) {
        Combo combo = SwingComponentFactory.buildComboBox(model);
        if (cellRendererAdapter != null) {
            combo.setRendererAdapter(cellRendererAdapter);
        }
        return combo;
    }

    private static JComponent buildLabeledEditableComboBoxImp(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, CellRendererAdapter renderer, BidiStringConverter editorValueConverter, Object nullValue, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner, boolean topAlignedLabel, boolean listChooser) {
        JComponent container = SwingComponentFactory.buildLabeledComboBoxImp(key, (ComboBoxModel)new ComboBoxModelWithDefaultHandler(model, defaultValueHolder), renderer, rightComponent, nullValue, repository, leftAligner, rightAligner, topAlignedLabel, listChooser);
        JComboBox comboBox = (JComboBox)container.getComponent(1);
        SwingComponentFactory.installComboBoxEditorWithDefault(comboBox, subjectHolder, valueHolder, defaultValueHolder, editorValueConverter, nullValue);
        return container;
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, CellRendererAdapter renderer, BidiStringConverter editorValueConverter, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, editorValueConverter, nullValue, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, CellRendererAdapter renderer, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, editorValueConverter, nullValue, rightComponent, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, editorValueConverter, nullValue, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, editorValueConverter, null, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, BidiStringConverter.DEFAULT_INSTANCE, null, rightComponent, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, Object nullValue, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, CellRendererAdapter renderer, BidiStringConverter editorValueConverter, Object nullValue, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, editorValueConverter, nullValue, rightComponent, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, editorValueConverter, nullValue, rightComponent, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValue, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValue, renderer, editorValueConverter, nullValue, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, editorValueConverter, null, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValue, ListCellRenderer renderer, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValue, renderer, BidiStringConverter.DEFAULT_INSTANCE, null, rightComponent, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, Object nullValue, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, false, false);
    }

    public static JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, CellRendererAdapter renderer, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, editorValueConverter, nullValue, rightComponent, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, editorValueConverter, nullValue, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, editorValueConverter, null, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, BidiStringConverter.DEFAULT_INSTANCE, null, rightComponent, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, Object nullValue, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, editorValueConverter, nullValue, rightComponent, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValue, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValue, renderer, editorValueConverter, nullValue, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, editorValueConverter, null, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValue, ListCellRenderer renderer, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValue, renderer, BidiStringConverter.DEFAULT_INSTANCE, null, rightComponent, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, Object nullValue, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledListChooser(String key, ComboBoxModel model, CellRendererAdapter renderer, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComboBoxImp(key, model, renderer, rightComponent, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledListChooser(String key, ComboBoxModel model, CellRendererAdapter renderer, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComboBoxImp(key, model, renderer, null, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledListChooser(String key, ComboBoxModel model, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComboBoxImp(key, model, (CellRendererAdapter)null, rightComponent, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledListChooser(String key, ComboBoxModel model, ListCellRenderer renderer, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComboBoxImp(key, model, renderer, rightComponent, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledListChooser(String key, ComboBoxModel model, ListCellRenderer renderer, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComboBoxImp(key, model, renderer, null, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledListChooser(String key, ComboBoxModel model, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComboBoxImp(key, model, (CellRendererAdapter)null, null, null, repository, leftAligner, rightAligner, false, true);
    }

    public static JComponent buildLabeledNonEditableTextField(String key, Document document, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        JTextField textField = SwingComponentFactory.buildTextField(document);
        textField.setEditable(false);
        return SwingComponentFactory.buildLabeledComponent(key, (JComponent)textField, rightComponent, repository, leftAligner, rightAligner);
    }

    public static JComponent buildLabeledNonEditableTextField(String key, Document document, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledNonEditableTextField(key, document, new Spacer(), repository, leftAligner, rightAligner);
    }

    public static JComponent buildLabeledSpinnerDate(String labelKey, SpinnerDateModel model, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComponent(labelKey, SwingComponentFactory.buildSpinnerDate(model), repository, leftAligner, rightAligner);
    }

    public static JComponent buildLabeledSpinnerNumber(String key, SpinnerNumberModel model, int columns, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        GridBagConstraints constraints = new GridBagConstraints();
        Pane pane = new Pane(new GridBagLayout());
        JLabel label = SwingComponentFactory.buildLabel(key, repository);
        pane.add((Component)label, constraints);
        leftAligner.add(label);
        JSpinner spinner = SwingComponentFactory.buildSpinnerNumber(model, columns);
        constraints.weightx = 1.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 0);
        pane.add((Component)spinner, constraints);
        label.setLabelFor(spinner);
        spinner.setName(key);
        Spacer spacer = new Spacer();
        constraints.weightx = 0.0;
        constraints.fill = 0;
        pane.add((Component)spacer, constraints);
        rightAligner.add(spacer);
        return pane;
    }

    public static JComponent buildLabeledSpinnerNumber(String key, SpinnerNumberModel model, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledSpinnerNumber(key, model, 4, repository, leftAligner, rightAligner);
    }

    public static JComponent buildLabeledSpinnerNumber(String key, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, Comparable minimumValue, Comparable maximumValue, Number stepSize, int columns, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        GridBagConstraints constraints = new GridBagConstraints();
        Pane pane = new Pane(new GridBagLayout());
        JLabel label = SwingComponentFactory.buildLabel(key, repository);
        pane.add((Component)label, constraints);
        leftAligner.add(label);
        JSpinner spinner = SwingComponentFactory.buildSpinnerNumber(subjectHolder, valueHolder, defaultValueHolder, minimumValue, maximumValue, stepSize, columns);
        constraints.weightx = 1.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 0);
        pane.add((Component)spinner, constraints);
        label.setLabelFor(spinner);
        spinner.setName(key);
        Spacer spacer = new Spacer();
        constraints.weightx = 0.0;
        constraints.fill = 0;
        pane.add((Component)spacer, constraints);
        rightAligner.add(spacer);
        return pane;
    }

    public static JComponent buildLabeledSpinnerNumber(String key, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, Comparable minimumValue, Comparable maximumValue, Number stepSize, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledSpinnerNumber(key, subjectHolder, valueHolder, defaultValueHolder, minimumValue, maximumValue, stepSize, 4, repository, leftAligner, rightAligner);
    }

    public static JSpinner buildSpinnerDate(SpinnerDateModel model) {
        JSpinner spinner = new JSpinner();
        spinner.setModel(model);
        return spinner;
    }

    public static JSpinner buildSpinnerNumber(ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, Comparable minimumValue, Comparable maximumValue, Number stepSize, int columns) {
        SpinnerWithDefaultHandler handler = new SpinnerWithDefaultHandler(subjectHolder, valueHolder, defaultValueHolder, minimumValue, maximumValue, stepSize);
        JSpinner spinner = handler.getSpinner();
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)spinner.getEditor();
        JFormattedTextField textField = editor.getTextField();
        textField.setColumns(columns);
        return spinner;
    }

    public static JComponent buildLabeledTextField(String key, Document document, int columns, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComponent(key, (JComponent)SwingComponentFactory.buildTextField(document, columns), rightComponent, repository, leftAligner, rightAligner);
    }

    public static JComponent buildLabeledTextField(String key, Document document, int columns, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledTextField(key, document, columns, new Spacer(), repository, leftAligner, rightAligner);
    }

    public static JComponent buildLabeledTextField(String key, Document document, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComponent(key, (JComponent)SwingComponentFactory.buildTextField(document), rightComponent, repository, leftAligner, rightAligner);
    }

    public static JComponent buildLabeledTextField(String key, Document document, JTextField field, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        field.setDocument(document);
        return SwingComponentFactory.buildLabeledComponent(key, field, repository, leftAligner, rightAligner);
    }

    public static JComponent buildLabeledTextField(String key, Document document, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledTextField(key, document, new Spacer(), repository, leftAligner, rightAligner);
    }

    public static JTextField buildTextField(Document document, int columns) {
        JTextField textField = new JTextField(document, null, columns);
        return textField;
    }

    public static JToggleButton buildToggleButton(String key, ResourceRepository repository) {
        JToggleButton button = new JToggleButton();
        button.setName(key);
        SwingComponentFactory.setTextFor(button, key, repository);
        return button;
    }

    public static JComponent buildTopLabeledComboBox(String labelKey, ComboBoxModel model, CellRendererAdapter cellRenderer, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComboBoxImp(labelKey, model, cellRenderer, null, null, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledComboBox(String key, ComboBoxModel model, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComboBoxImp(key, model, (CellRendererAdapter)null, null, (Object)rightComponent, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledComboBox(String key, ComboBoxModel model, ListCellRenderer renderer, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComboBoxImp(key, model, renderer, null, (Object)rightComponent, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledComboBox(String labelKey, ComboBoxModel model, ListCellRenderer cellRenderer, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComboBoxImp(labelKey, model, cellRenderer, null, null, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledComboBox(String key, ComboBoxModel model, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComboBoxImp(key, model, (CellRendererAdapter)null, null, null, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledComponent(JComponent leftComponent, JComponent centerComponent, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComponent(leftComponent, centerComponent, rightComponent, repository, leftAligner, rightAligner, true);
    }

    public static JComponent buildTopLabeledComponent(String key, JComponent component, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComponent(key, component, rightComponent, repository, leftAligner, rightAligner, true);
    }

    public static JComponent buildTopLabeledComponent(String key, JComponent component, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComponent(key, component, (JComponent)new Spacer(), repository, leftAligner, rightAligner, true);
    }

    public static JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, editorValueConverter, nullValue, rightComponent, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, editorValueConverter, nullValue, null, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, editorValueConverter, null, null, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, Object nullValue, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, editorValueConverter, nullValue, rightComponent, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, editorValueConverter, nullValue, null, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueModel, ListCellRenderer renderer, BidiStringConverter editorValueConverter, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueModel, renderer, editorValueConverter, null, null, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValue, Object nullValue, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValue, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, true, false);
    }

    public static JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, editorValueConverter, nullValue, null, repository, leftAligner, rightAligner, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, editorValueConverter, null, null, repository, leftAligner, rightAligner, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ListCellRenderer renderer, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), renderer, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, Object nullValue, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, editorValueConverter, nullValue, rightComponent, repository, leftAligner, rightAligner, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, BidiStringConverter editorValueConverter, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, editorValueConverter, nullValue, null, repository, leftAligner, rightAligner, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueModel, ListCellRenderer renderer, BidiStringConverter editorValueConverter, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueModel, renderer, editorValueConverter, null, null, repository, leftAligner, rightAligner, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ListCellRenderer renderer, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, renderer, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValue, Object nullValue, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValue, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, Object nullValue, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, nullValue, null, repository, leftAligner, rightAligner, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String key, ComboBoxModel model, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(key, model, subjectHolder, valueHolder, defaultValueHolder, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, repository, leftAligner, rightAligner, true, true);
    }

    public static JComponent buildTopLabeledListChooser(String key, ComboBoxModel model, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComboBoxImp(key, model, (CellRendererAdapter)null, null, (Object)rightComponent, repository, leftAligner, rightAligner, true, true);
    }

    public static JComponent buildTopLabeledListChooser(String key, ComboBoxModel model, ListCellRenderer renderer, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComboBoxImp(key, model, renderer, null, (Object)rightComponent, repository, leftAligner, rightAligner, true, true);
    }

    public static JComponent buildTopLabeledListChooser(String labelKey, ComboBoxModel model, ListCellRenderer cellRenderer, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComboBoxImp(labelKey, model, cellRenderer, null, null, repository, leftAligner, rightAligner, true, true);
    }

    public static JComponent buildTopLabeledListChooser(String key, ComboBoxModel model, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildLabeledComboBoxImp(key, model, (CellRendererAdapter)null, null, null, repository, leftAligner, rightAligner, true, true);
    }

    public static JComponent buildTopLabeledNonEditableTextField(String key, Document document, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        JTextField textField = SwingComponentFactory.buildTextField(document);
        textField.setEditable(false);
        return SwingComponentFactory.buildTopLabeledComponent(key, (JComponent)textField, rightComponent, repository, leftAligner, rightAligner);
    }

    public static JComponent buildTopLabeledTextArea(String key, Document document, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildTopLabeledComponent(key, (JComponent)SwingComponentFactory.buildTextArea(document), (JComponent)new Spacer(), repository, leftAligner, rightAligner);
    }

    public static JComponent buildTopLabeledTextField(String key, Document document, int columns, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildTopLabeledComponent(key, (JComponent)SwingComponentFactory.buildTextField(document, columns), (JComponent)new Spacer(), repository, leftAligner, rightAligner);
    }

    public static JComponent buildTopLabeledTextField(String key, Document document, JComponent rightComponent, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildTopLabeledComponent(key, (JComponent)SwingComponentFactory.buildTextField(document), rightComponent, repository, leftAligner, rightAligner);
    }

    public static JComponent buildTopLabeledTextField(String key, Document document, ResourceRepository repository, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        return SwingComponentFactory.buildTopLabeledTextField(key, document, new Spacer(), repository, leftAligner, rightAligner);
    }

    public static JTextArea buildTextArea(Document document) {
        TextArea textArea = new TextArea(document);
        return textArea;
    }

    public static TriStateCheckBox buildTriStateCheckBox(String key, TriStateCheckBox.TriStateButtonModel model, ResourceRepository repository) {
        TriStateCheckBox checkBox = new TriStateCheckBox();
        checkBox.setModel(model);
        checkBox.setOpaque(false);
        SwingComponentFactory.setTextFor(checkBox, key, repository);
        return checkBox;
    }

    private static class TextArea
    extends JTextArea {
        private int minimumHeight;

        TextArea(Document document) {
            super(document);
            this.initialize();
        }

        private int calculateMinimumHeight() {
            int minimumHeight = this.getFontMetrics(this.getFont()).getHeight() * 5;
            Insets insets = this.getInsets();
            return minimumHeight += insets.top + insets.bottom;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            if (this.minimumHeight == 0) {
                this.minimumHeight = this.calculateMinimumHeight();
            }
            size.height = Math.max(this.minimumHeight, size.height);
            return size;
        }

        private void initialize() {
            this.setFont(UIManager.getFont("Label.font"));
            Insets margin = this.getMargin();
            this.setBorder(BorderFactory.createCompoundBorder());
        }
    }

    private static class InternalListCellRenderer
    implements ListCellRenderer {
        private final ListCellRenderer customRenderer;
        private final ListCellRenderer defaultDelegate;

        public InternalListCellRenderer(ListCellRenderer customRenderer, ListCellRenderer defaultDelegate) {
            this.customRenderer = customRenderer;
            this.defaultDelegate = defaultDelegate;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean cellHasFocus) {
            if (value == ComboBoxTableCellRenderer.prototypeLabel) {
                return ComboBoxTableCellRenderer.prototypeLabel;
            }
            JLabel ourLabel = (JLabel)this.customRenderer.getListCellRendererComponent(list, value, index, selected, cellHasFocus);
            JLabel actualLabel = (JLabel)this.defaultDelegate.getListCellRendererComponent(list, null, index, selected, cellHasFocus);
            actualLabel.setText(ourLabel.getText());
            actualLabel.setIcon(ourLabel.getIcon());
            actualLabel.setToolTipText(ourLabel.getToolTipText());
            actualLabel.getAccessibleContext().setAccessibleName(ourLabel.getAccessibleContext().getAccessibleName());
            if (!list.hasFocus() && selected && list.isFocusable()) {
                actualLabel.setForeground(list.getForeground());
                actualLabel.setBackground(UIManager.getColor("Panel.background"));
            }
            if (actualLabel.getIcon() == null) {
                actualLabel.setIcon(EmptyIcon.SMALL_ICON);
                actualLabel.setPreferredSize(actualLabel.getPreferredSize());
                actualLabel.setIcon(null);
            }
            return actualLabel;
        }
    }

    private static class InternalJTable
    extends JTable {
        InternalJTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
            super(tableModel, tableColumnModel, listSelectionModel);
        }

        public Color getBackground() {
            if (!this.isEnabled()) {
                return UIManager.getColor("control");
            }
            return super.getBackground();
        }

        public Color getForeground() {
            if (!this.isEnabled()) {
                return UIManager.getColor("controlText");
            }
            return super.getForeground();
        }

        private boolean isMousePressed(MouseEvent e) {
            return (e.getModifiers() & 0x1F5) != 0;
        }

        protected void processMouseEvent(MouseEvent e) {
            Rectangle bounds;
            if (this.isEditing() && SwingUtilities.isLeftMouseButton(e) && this.isMousePressed(e) && !(bounds = this.getCellRect(this.getEditingRow(), this.getEditingColumn(), true)).contains(e.getX(), e.getY())) {
                this.getCellEditor().stopCellEditing();
            }
            super.processMouseEvent(e);
        }

        public void setEnabled(boolean enabled) {
            boolean oldEnabled = this.isEnabled();
            super.setEnabled(enabled);
            if (oldEnabled != enabled && this.getParent() != null) {
                this.getParent().setBackground(this.getBackground());
                this.getParent().repaint();
            }
        }
    }

    private static class DoubleClickMouseHandler
    extends MouseAdapter {
        private final Map componentMouseListeners;
        private final DoubleClickTrigger trigger = new DoubleClickTrigger();

        DoubleClickMouseHandler() {
            this.componentMouseListeners = new Hashtable();
        }

        void addMouseListener(Component component, DoubleClickMouseListener listener) {
            Vector<DoubleClickMouseListener> listeners = (Vector<DoubleClickMouseListener>)this.componentMouseListeners.get(component);
            if (listeners == null) {
                listeners = new Vector<DoubleClickMouseListener>();
                this.componentMouseListeners.put(component, listeners);
            }
            listeners.add(listener);
        }

        private void fireMouseDoucleClicked(MouseEvent e) {
            List listeners = (List)this.componentMouseListeners.get(e.getComponent());
            Iterator iter = listeners.iterator();
            while (iter.hasNext()) {
                ((DoubleClickMouseListener)iter.next()).mouseDoubleClicked(e);
            }
        }

        boolean hasListeners(Component component) {
            return this.componentMouseListeners.containsKey(component);
        }

        public void mouseReleased(MouseEvent e) {
            if (this.trigger.isDoubleClick(e)) {
                this.fireMouseDoucleClicked(e);
            }
        }

        void removeMouseListener(Component component, DoubleClickMouseListener listener) {
            List listeners = (List)this.componentMouseListeners.get(component);
            if (listeners == null || !listeners.contains(listener)) {
                throw new IllegalStateException("Can't remove a listener that was not registered");
            }
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                listeners.remove(component);
            }
        }
    }

    public static class AccessibleTree
    extends JTree {
        public AccessibleTree() {
        }

        public AccessibleTree(TreeModel model) {
            super(model);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleAccessibleTree();
            }
            return this.accessibleContext;
        }

        protected class AccessibleAccessibleTree
        extends JTree.AccessibleJTree {
            protected AccessibleAccessibleTree() {
                super(AccessibleTree.this);
            }

            public String getAccessibleName() {
                String name = super.getAccessibleName();
                if (name != null) {
                    return name;
                }
                if (AccessibleTree.this.getParent() instanceof JViewport) {
                    JComponent container = (JComponent)AccessibleTree.this.getParent().getParent().getParent();
                    return container.getAccessibleContext().getAccessibleName();
                }
                return null;
            }
        }
    }

    public static class AccessibleList
    extends JList {
        public AccessibleList() {
        }

        public AccessibleList(ListModel model) {
            super(model);
        }

        public AccessibleList(Vector items) {
            super(items);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleAccessibleList();
            }
            return this.accessibleContext;
        }

        protected class AccessibleAccessibleList
        extends JList.AccessibleJList {
            protected AccessibleAccessibleList() {
                super(AccessibleList.this);
            }

            public String getAccessibleName() {
                String name = super.getAccessibleName();
                if (name != null) {
                    return name;
                }
                if (AccessibleList.this.getParent() instanceof JViewport) {
                    JComponent container = (JComponent)AccessibleList.this.getParent().getParent().getParent();
                    return container.getAccessibleContext().getAccessibleName();
                }
                return null;
            }
        }
    }

    protected static class BrowseButton
    extends JButton {
        Accessible labeler;

        protected BrowseButton(Accessible labeler) {
            this.labeler = labeler;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                if (this.labeler == null) {
                    return super.getAccessibleContext();
                }
                this.accessibleContext = new AccessibleBrowseButton();
            }
            return this.accessibleContext;
        }

        protected class AccessibleBrowseButton
        extends JButton.AccessibleJButton {
            protected AccessibleBrowseButton() {
                super(BrowseButton.this);
            }

            public String getAccessibleDescription() {
                StringBuffer sb = new StringBuffer();
                sb.append(BrowseButton.this.labeler.getAccessibleContext().getAccessibleDescription());
                sb.append(" ");
                sb.append(super.getAccessibleDescription());
                return sb.toString();
            }

            public String getAccessibleName() {
                StringBuffer sb = new StringBuffer();
                sb.append(BrowseButton.this.labeler.getAccessibleContext().getAccessibleName());
                sb.append(" ");
                sb.append(super.getAccessibleName());
                return sb.toString();
            }
        }
    }
}

