/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.MultipleClassChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ClassCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ExternalClassDescriptionClassDesciptionAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ExternalClassDescriptionClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ExternalClassLoadFailuresDialog;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class NonDescriptorClassManagementDialog
extends AbstractDialog {
    private MWProject project;
    private DefaultListModel classesListModel;
    ObjectListSelectionModel classesListSelectionModel;

    public NonDescriptorClassManagementDialog(WorkbenchContext context, MWProject project) {
        super(context);
        this.project = project;
        this.buildModels();
    }

    protected void initialize() {
        super.initialize();
        String egg = "";
        if (System.getProperty("user.name", "").equalsIgnoreCase("dmahar")) {
            egg = "Denise's ";
        }
        this.setTitle(this.resourceRepository().getString("NON_DESCRIPTOR_CLASS_MANAGEMENT_DIALOG.TITLE", egg));
    }

    private void buildModels() {
        this.classesListModel = new DefaultListModel();
        this.rebuildClassesListModel();
        this.classesListSelectionModel = this.buildClassesListSelectionModel();
    }

    private void rebuildClassesListModel() {
        Set descriptorClasses = CollectionTools.set((Iterator)this.descriptorClasses());
        ArrayList types = new ArrayList(this.project.getClassRepository().userTypesSize());
        Iterator stream = this.project.getClassRepository().userTypes();
        while (stream.hasNext()) {
            Object type = stream.next();
            if (descriptorClasses.contains(type)) continue;
            types.add(type);
        }
        Collections.sort(types);
        this.classesListModel.clear();
        stream = types.iterator();
        while (stream.hasNext()) {
            this.classesListModel.addElement(stream.next());
        }
    }

    private ObjectListSelectionModel buildClassesListSelectionModel() {
        return new ObjectListSelectionModel(this.classesListModel);
    }

    protected Component buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        LabelArea label = new LabelArea();
        label.setText(this.resourceRepository().getString("NON_DESCRIPTOR_CLASS_MANAGEMENT_DIALOG.EXPLANATION", StringTools.CR));
        label.setBorder(BorderFactory.createEmptyBorder(3, 3, 5, 3));
        panel.add((Component)label, "North");
        JList list = SwingComponentFactory.buildList(this.classesListModel);
        list.setSelectionModel(this.classesListSelectionModel);
        list.setCellRenderer(this.buildCellRenderer());
        JScrollPane scrollPane = new JScrollPane(list);
        scrollPane.setPreferredSize(new Dimension(500, 400));
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    private ListCellRenderer buildCellRenderer() {
        ClassCellRendererAdapter adapter = new ClassCellRendererAdapter(this.resourceRepository()){

            public boolean showDetailedIcon() {
                return false;
            }
        };
        return new AdaptableListCellRenderer(adapter);
    }

    protected Iterator buildCustomActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.buildAddAction());
        actions.add(this.buildRemoveAction());
        actions.add(this.buildRefreshAction());
        return actions.iterator();
    }

    private Action buildAddAction() {
        return new AbstractAction(this.resourceRepository().getString("NON_DESCRIPTOR_CLASS_MANAGEMENT_DIALOG.ADD_ACTION")){

            public void actionPerformed(ActionEvent e) {
                NonDescriptorClassManagementDialog.this.addClasses();
            }
        };
    }

    void addClasses() {
        this.repository().refreshExternalClassDescriptions();
        MultipleClassChooserDialog dialog = new MultipleClassChooserDialog(this.getWorkbenchContext(), this.buildMultiClassChooserDialogClassDescriptionRepository(), ExternalClassDescriptionClassDesciptionAdapter.instance(), this);
        dialog.show();
        if (dialog.wasCanceled()) {
            dialog = null;
            MultipleClassChooserDialog.gc();
            return;
        }
        ExternalClassLoadFailureContainer failures = this.repository().refreshTypesFor(dialog.selectedClassDescriptions());
        dialog = null;
        MultipleClassChooserDialog.gc();
        if (failures.containsFailures()) {
            new ExternalClassLoadFailuresDialog(this.getWorkbenchContext(), this, failures).show();
        }
        this.rebuildClassesListModel();
    }

    private ClassDescriptionRepository buildMultiClassChooserDialogClassDescriptionRepository() {
        return new NonDescriptorExternalClassDescriptionClassDescriptionRepository(this.project.getClassRepository());
    }

    private Action buildRemoveAction() {
        final AbstractAction action = new AbstractAction(this.resourceRepository().getString("NON_DESCRIPTOR_CLASS_MANAGEMENT_DIALOG.REMOVE_ACTION")){

            public void actionPerformed(ActionEvent e) {
                NonDescriptorClassManagementDialog.this.removeSelectedClasses();
            }
        };
        action.setEnabled(false);
        this.classesListSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    action.setEnabled(!NonDescriptorClassManagementDialog.this.classesListSelectionModel.isSelectionEmpty());
                }
            }
        });
        return action;
    }

    void removeSelectedClasses() {
        Iterator stream = CollectionTools.iterator((Object[])this.classesListSelectionModel.getSelectedValues());
        while (stream.hasNext()) {
            MWClass type = (MWClass)stream.next();
            this.classesListModel.removeElement(type);
            type.clear();
        }
    }

    private Action buildRefreshAction() {
        final AbstractAction action = new AbstractAction(this.resourceRepository().getString("NON_DESCRIPTOR_CLASS_MANAGEMENT_DIALOG.REFRESH_ACTION")){

            public void actionPerformed(ActionEvent e) {
                NonDescriptorClassManagementDialog.this.refreshSelectedClasses();
            }
        };
        action.setEnabled(false);
        this.classesListSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    action.setEnabled(!NonDescriptorClassManagementDialog.this.classesListSelectionModel.isSelectionEmpty());
                }
            }
        });
        return action;
    }

    void refreshSelectedClasses() {
        this.repository().refreshExternalClassDescriptions();
        ExternalClassLoadFailureContainer failures = this.repository().refreshTypes(CollectionTools.iterator((Object[])this.classesListSelectionModel.getSelectedValues()));
        if (failures.containsFailures()) {
            new ExternalClassLoadFailuresDialog(this.getWorkbenchContext(), this, failures).show();
        }
    }

    private MWClassRepository repository() {
        return this.project.getClassRepository();
    }

    Iterator descriptorClasses() {
        return new TransformationIterator(this.project.descriptors()){

            protected Object transform(Object next) {
                return ((MWDescriptor)next).getMWClass();
            }
        };
    }

    protected boolean cancelButtonIsVisible() {
        return false;
    }

    protected String helpTopicId() {
        return "dialog.nonDescriptorManagement";
    }

    private class NonDescriptorExternalClassDescriptionClassDescriptionRepository
    extends ExternalClassDescriptionClassDescriptionRepository {
        Collection descriptorClassNames;
        Collection userClassNames;

        private NonDescriptorExternalClassDescriptionClassDescriptionRepository(MWClassRepository repository) {
            super(repository);
            this.descriptorClassNames = this.buildDescriptorClassNames();
            this.userClassNames = this.buildUserClassNames();
        }

        private Collection buildDescriptorClassNames() {
            return CollectionTools.set((Iterator)this.allDescriptorClassNames());
        }

        private Iterator allDescriptorClassNames() {
            return new TransformationIterator(NonDescriptorClassManagementDialog.this.descriptorClasses()){

                protected Object transform(Object next) {
                    return ((MWClass)next).getName();
                }
            };
        }

        private Collection buildUserClassNames() {
            Classpath cp = new Classpath(CollectionTools.list((Iterator)this.repository.fullyQualifiedClasspathEntries()));
            HashSet result = new HashSet(1000);
            cp.addClassNamesTo(result);
            return result;
        }

        protected boolean accept(String externalClassDescriptionName) {
            return super.accept(externalClassDescriptionName) && this.userClassNames.contains(externalClassDescriptionName) && !this.descriptorClassNames.contains(externalClassDescriptionName);
        }
    }
}

