/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Frame;
import java.util.Collection;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractEnablableFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.WaitDialog;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.DatabaseNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.TableImporterDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ProjectNode;

final class AddOrRefreshTablesAction
extends AbstractEnablableFrameworkAction {
    AddOrRefreshTablesAction(WorkbenchContext context) {
        super(context);
    }

    protected void initialize() {
        super.initialize();
        this.initializeIcon("table.addFromDatabase");
        this.initializeTextAndMnemonic("ADD_OR_REFRESH_TABLES_ACTION");
        this.initializeToolTipText("ADD_OR_REFRESH_TABLES_ACTION.toolTipText");
    }

    protected void execute() {
        ApplicationNode[] projectNodes = this.selectedProjectNodes();
        for (int i = 0; i < projectNodes.length; ++i) {
            this.execute((ProjectNode)projectNodes[i]);
        }
    }

    protected void execute(ProjectNode projectNode) {
        MWDatabase database = projectNode.getProject().getDatabase();
        TableImporterDialog importDialog = new TableImporterDialog(this.getWorkbenchContext(), database);
        importDialog.show();
        if (importDialog.wasCanceled()) {
            return;
        }
        this.startTableImporter(database, importDialog.importsTablesFullyQualified(), importDialog.selectedTables());
    }

    protected boolean shouldBeEnabled(ApplicationNode selectedNode) {
        return ((DatabaseNode)selectedNode).getDatabase().isConnected();
    }

    protected String[] enabledPropertyNames() {
        return new String[]{"connected"};
    }

    private void startTableImporter(MWDatabase database, boolean importsTablesFullyQualified, Collection selectedTables) {
        Thread thread = new Thread((Runnable)new TableImporter(database, importsTablesFullyQualified, selectedTables), "Database Table Importer");
        thread.setPriority(5);
        thread.start();
    }

    private class TableImporter
    implements Runnable {
        private MWDatabase database;
        private boolean importsTablesFullyQualified;
        private Collection selectedTables;

        TableImporter(MWDatabase database, boolean importsTablesFullyQualified, Collection selectedTables) {
            this.database = database;
            this.importsTablesFullyQualified = importsTablesFullyQualified;
            this.selectedTables = selectedTables;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WaitDialog waitDialog = this.buildWaitDialog();
            AbstractFrameworkAction.launchLater(waitDialog);
            this.database.getValidator().pause();
            try {
                if (this.importsTablesFullyQualified) {
                    this.database.importQualifiedTablesFor(this.selectedTables);
                } else {
                    this.database.importUnqualifiedTablesFor(this.selectedTables);
                }
            }
            finally {
                this.database.getValidator().resume();
                waitDialog.dispose();
            }
        }

        private WaitDialog buildWaitDialog() {
            return new WaitDialog((Frame)this.workbenchContext().getCurrentWindow(), this.resourceRepository().getIcon("database.large"), this.resourceRepository().getString("TABLE_IMPORTATION_DIALOG.TITLE"), this.resourceRepository().getString("TABLE_IMPORTATION_MESSAGE"));
        }

        private WorkbenchContext workbenchContext() {
            return AddOrRefreshTablesAction.this.getWorkbenchContext();
        }

        private ResourceRepository resourceRepository() {
            return AddOrRefreshTablesAction.this.resourceRepository();
        }
    }
}

