/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.DoubleClickMouseListener;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.generation.MWRelationshipHolder;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;

final class RelationshipGenerationDialog
extends AbstractDialog
implements ActionListener,
ListSelectionListener {
    private TreeSet availableListData;
    private TreeSet selectedListData;
    private JList availableList;
    private JList selectedList;
    private JButton oneToManyButton;
    private JButton oneToOneButton;
    private boolean generateBidirectionalRelationships;
    private JCheckBox generateBidirectionalRelationshipsCheckBox;
    protected static final String ID_ONE_TO_ONE = "One-To-One";
    protected static final String ID_CREATE = "Create";
    protected static final String ID_SKIP = "Skip";
    protected static final String ID_ONE_TO_MANY = "One-To-Many";
    protected static final String ID_DESELECT_ITEMS = "Deselect Items";

    public RelationshipGenerationDialog(Vector relationships, WorkbenchContext workbenchContext) {
        super(workbenchContext);
        this.setAvailableListData(relationships);
        this.setSelectedListData(new Vector());
    }

    public boolean getGenerateBidirectionalRelationships() {
        return this.generateBidirectionalRelationshipsCheckBox.isSelected();
    }

    private ListCellRenderer getListCellRenderer() {
        return new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                MWRelationshipHolder holder = (MWRelationshipHolder)value;
                label.setText(holder.displayString());
                if (holder.isOneToOne()) {
                    label.setIcon(RelationshipGenerationDialog.this.resourceRepository().getIcon("mapping.oneToOne"));
                } else if (holder.isOneToMany()) {
                    label.setIcon(RelationshipGenerationDialog.this.resourceRepository().getIcon("mapping.oneToMany"));
                }
                return label;
            }
        };
    }

    public Collection getRelationshipsToCreate() {
        return new Vector(this.selectedListData);
    }

    protected String helpTopicId() {
        return "dialog.relationshipGenerator";
    }

    protected Component initialFocusComponent() {
        return this.availableList;
    }

    protected void initialize(WorkbenchContext context) {
        super.initialize(context);
        this.setTitle(this.resourceRepository().getString("chooseRelationshipsToGenerate.title"));
    }

    protected void prepareToShow() {
        this.setSize(800, 400);
        this.setLocationRelativeTo(this.getParent());
    }

    protected Component buildMainPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel mainPanel = new JPanel(new GridBagLayout());
        LabelArea messageLabel = new LabelArea(this.resourceRepository().getString("basedOnTheForeignKeysOfThe"));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 5);
        mainPanel.add((Component)messageLabel, constraints);
        JSeparator separator = new JSeparator(0);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(10, 5, 5, 5);
        mainPanel.add((Component)separator, constraints);
        JLabel availableLabel = SwingComponentFactory.buildLabel("potentialRelationships", this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 0);
        mainPanel.add((Component)availableLabel, constraints);
        this.availableList = new JList();
        this.availableList.setCellRenderer(this.getListCellRenderer());
        this.availableList.setSelectionMode(2);
        this.availableList.addListSelectionListener(this);
        this.availableList.setListData(this.availableListData.toArray());
        availableLabel.setLabelFor(this.availableList);
        JScrollPane availableScrollpane = new JScrollPane(this.availableList);
        availableScrollpane.getViewport().setPreferredSize(new Dimension(0, 0));
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 3;
        constraints.weightx = 0.5;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 5, 0, 0);
        mainPanel.add((Component)availableScrollpane, constraints);
        JLabel selectedLabel = SwingComponentFactory.buildLabel("selectedRelationships", this.resourceRepository());
        constraints.gridx = 2;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 5);
        mainPanel.add((Component)selectedLabel, constraints);
        this.selectedList = SwingComponentFactory.buildList();
        this.selectedList.setCellRenderer(this.getListCellRenderer());
        this.selectedList.setSelectionMode(2);
        this.selectedList.setListData(this.selectedListData.toArray());
        SwingComponentFactory.addDoubleClickMouseListener(this.selectedList, new DoubleClickMouseListener(){

            public void mouseDoubleClicked(MouseEvent e) {
                RelationshipGenerationDialog.this.deselectItems();
            }
        });
        selectedLabel.setLabelFor(this.selectedList);
        JScrollPane selectedScrollpane = new JScrollPane(this.selectedList);
        selectedScrollpane.getViewport().setPreferredSize(new Dimension(0, 0));
        constraints.gridx = 2;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 3;
        constraints.weightx = 0.5;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 5, 0, 5);
        mainPanel.add((Component)selectedScrollpane, constraints);
        this.oneToOneButton = new JButton();
        this.oneToOneButton.setIcon(this.resourceRepository().getIcon("mapping.oneToOne"));
        this.oneToOneButton.setToolTipText(this.resourceRepository().getString("mapAsOneToOne"));
        this.oneToOneButton.setActionCommand(ID_ONE_TO_ONE);
        this.oneToOneButton.addActionListener(this);
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 5, 0, 0);
        mainPanel.add((Component)this.oneToOneButton, constraints);
        this.oneToManyButton = new JButton();
        this.oneToManyButton.setIcon(this.resourceRepository().getIcon("mapping.oneToMany"));
        this.oneToManyButton.setToolTipText(this.resourceRepository().getString("mapAsOneToMany"));
        this.oneToManyButton.setActionCommand(ID_ONE_TO_MANY);
        this.oneToManyButton.addActionListener(this);
        constraints.gridx = 1;
        constraints.gridy = 5;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 0);
        mainPanel.add((Component)this.oneToManyButton, constraints);
        JButton leftArrowButton = new JButton();
        leftArrowButton.addActionListener(this.buildAction());
        leftArrowButton.setIcon(this.resourceRepository().getIcon("shuttle.left"));
        leftArrowButton.setEnabled(false);
        leftArrowButton.setToolTipText(this.resourceRepository().getString("removeSelectedMappings"));
        this.selectedList.addListSelectionListener(this.buildSelectionListListener(leftArrowButton));
        leftArrowButton.setActionCommand(ID_DESELECT_ITEMS);
        constraints.gridx = 1;
        constraints.gridy = 6;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 11;
        constraints.insets = new Insets(5, 5, 0, 0);
        mainPanel.add((Component)leftArrowButton, constraints);
        this.generateBidirectionalRelationshipsCheckBox = new JCheckBox(this.resourceRepository().getString("generateBidirectionalRelationships"));
        this.generateBidirectionalRelationshipsCheckBox.setMnemonic(this.resourceRepository().getMnemonic("generateBidirectionalRelationships"));
        this.generateBidirectionalRelationshipsCheckBox.setSelected(this.generateBidirectionalRelationships);
        constraints.gridx = 0;
        constraints.gridy = 7;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 11;
        constraints.insets = new Insets(5, 5, 0, 0);
        mainPanel.add((Component)this.generateBidirectionalRelationshipsCheckBox, constraints);
        return mainPanel;
    }

    private ListSelectionListener buildSelectionListListener(final JButton leftArrowButton) {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (RelationshipGenerationDialog.this.selectedList.getSelectedValues().length > 0) {
                    leftArrowButton.setEnabled(true);
                } else {
                    leftArrowButton.setEnabled(false);
                }
            }
        };
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand == ID_ONE_TO_ONE) {
            this.selectItems(ID_ONE_TO_ONE);
        } else if (actionCommand == ID_ONE_TO_MANY) {
            this.selectItems(ID_ONE_TO_MANY);
        } else if (actionCommand == ID_DESELECT_ITEMS) {
            this.deselectItems();
        }
    }

    private AbstractFrameworkAction buildAction() {
        return new AbstractFrameworkAction(this.getWorkbenchContext()){

            public void actionPerformed(ActionEvent e) {
                RelationshipGenerationDialog.this.actionPerformed(e);
            }
        };
    }

    private void deselectItems() {
        TreeSet selectedItems = this.selectedListData;
        TreeSet availableItems = this.availableListData;
        Object[] selectedSelectedItems = this.selectedList.getSelectedValues();
        for (int i = 0; i < selectedSelectedItems.length; ++i) {
            ((MWRelationshipHolder)selectedSelectedItems[i]).setNoRelationship();
            selectedItems.remove(selectedSelectedItems[i]);
            availableItems.add(selectedSelectedItems[i]);
        }
        this.availableList.setListData(availableItems.toArray());
        this.selectedList.setListData(selectedItems.toArray());
        this.setAvailableListData(availableItems);
        this.setSelectedListData(selectedItems);
    }

    public void selectItems(String typeOfMapping) {
        TreeSet selectedItems = this.selectedListData;
        TreeSet availableItems = this.availableListData;
        Object[] selectedAvailableItems = this.availableList.getSelectedValues();
        for (int i = 0; i < selectedAvailableItems.length; ++i) {
            if (selectedItems.contains(selectedAvailableItems[i])) continue;
            MWRelationshipHolder mappingHolder = (MWRelationshipHolder)selectedAvailableItems[i];
            if (typeOfMapping.equals(ID_ONE_TO_ONE)) {
                mappingHolder.setOneToOne();
            } else {
                mappingHolder.setOneToMany();
            }
            selectedItems.add(selectedAvailableItems[i]);
            availableItems.remove(selectedAvailableItems[i]);
        }
        this.availableList.setListData(availableItems.toArray());
        this.selectedList.setListData(selectedItems.toArray());
        this.setAvailableListData(availableItems);
        this.setSelectedListData(selectedItems);
    }

    private void setAvailableListData(Collection data) {
        this.availableListData = new TreeSet(data);
    }

    public void setGenerateBidirectionalRelationships(boolean newValue) {
        this.generateBidirectionalRelationships = newValue;
    }

    private void setSelectedListData(Collection data) {
        this.selectedListData = new TreeSet(data);
    }

    public void valueChanged(ListSelectionEvent lse) {
        if (lse.getValueIsAdjusting()) {
            return;
        }
        Object[] selectedAvailableItems = this.availableList.getSelectedValues();
        int oneToOneCount = 0;
        int oneToManyCount = 0;
        for (int i = 0; i < selectedAvailableItems.length; ++i) {
            MWRelationshipHolder holder = (MWRelationshipHolder)selectedAvailableItems[i];
            if (holder.canMapOneToOne()) {
                ++oneToOneCount;
            }
            if (!holder.canMapOneToMany()) continue;
            ++oneToManyCount;
        }
        this.oneToOneButton.setEnabled(oneToOneCount > 0);
        this.oneToManyButton.setEnabled(oneToManyCount > 0 && oneToManyCount == selectedAvailableItems.length);
    }
}

