/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorAfterLoadingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassRepositoryHolder;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExtendedComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.IndirectComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class AfterLoadingPropertiesPage
extends ScrollablePropertiesPage {
    static final int EDITOR_WEIGHT = 12;
    private PropertyValueModel afterLoadingPolicyHolder;
    private PropertyValueModel postLoadMethodClassHolder;
    private PropertyValueModel postLoadMethodHolder;

    AfterLoadingPropertiesPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
    }

    protected void initialize(PropertyValueModel nodeHolder) {
        super.initialize(nodeHolder);
        this.afterLoadingPolicyHolder = this.buildAfterLoadingPolicyHolder();
        this.postLoadMethodClassHolder = this.buildPostLoadMethodClassHolder();
        this.postLoadMethodHolder = this.buildPostLoadMethodHolder();
    }

    private PropertyValueModel buildAfterLoadingPolicyHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "afterLoadingPolicy"){

            protected Object getValueFromSubject() {
                MWDescriptorPolicy policy = ((MWMappingDescriptor)this.subject).getAfterLoadingPolicy();
                return policy.isActive() ? policy : null;
            }
        };
    }

    private PropertyValueModel buildPostLoadMethodClassHolder() {
        return new PropertyAspectAdapter(this.afterLoadingPolicyHolder, "postLoadMethodClass"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorAfterLoadingPolicy)this.subject).getPostLoadMethodClass();
            }

            protected void setValueOnSubject(Object value) {
                MWClass type = (MWClass)value;
                ((MWDescriptorAfterLoadingPolicy)this.subject).setPostLoadMethodClass(type);
                if (type != null) {
                    try {
                        if (type.isStub()) {
                            type.refresh();
                        }
                    }
                    catch (ExternalClassNotFoundException exception) {
                        AfterLoadingPropertiesPage.this.showClassLoadingException();
                    }
                }
            }
        };
    }

    private PropertyValueModel buildPostLoadMethodHolder() {
        PropertyAspectAdapter propertyValueModel = new PropertyAspectAdapter(this.afterLoadingPolicyHolder, "postLoadMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorAfterLoadingPolicy)this.subject).getPostLoadMethod();
            }

            protected void setValueOnSubject(Object value) {
                ((MWDescriptorAfterLoadingPolicy)this.subject).setPostLoadMethod((MWMethod)value);
            }
        };
        return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyValueModel, "signature");
    }

    protected Component buildPage() {
        JPanel afterLoadingExecutePanel = new JPanel(new GridBagLayout());
        afterLoadingExecutePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel titleLabel = this.buildLabel("AFTER_LOAD_POLICY_DESCRIPTOR");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 0, 10, 0);
        afterLoadingExecutePanel.add((Component)titleLabel, constraints);
        JLabel inClassLabel = this.buildLabel("AFTER_LOAD_POLICY_CLASS");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        afterLoadingExecutePanel.add((Component)inClassLabel, constraints);
        ClassChooserPanel postLoadMethodClassChooserPanel = this.buildPostLoadMethodClassChooserPanel(inClassLabel);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 0);
        afterLoadingExecutePanel.add((Component)postLoadMethodClassChooserPanel, constraints);
        this.addPaneForAlignment(postLoadMethodClassChooserPanel);
        JLabel staticMethodLabel = this.buildLabel("AFTER_LOAD_POLICY_STATIC_METHOD");
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        afterLoadingExecutePanel.add((Component)staticMethodLabel, constraints);
        ListChooser staticMethodChooser = this.buildPostLoadMethodListChooser();
        staticMethodLabel.setLabelFor(staticMethodChooser);
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 0);
        afterLoadingExecutePanel.add((Component)staticMethodChooser, constraints);
        Spacer spacer = new Spacer();
        constraints.gridx = 2;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 0);
        afterLoadingExecutePanel.add((Component)spacer, constraints);
        this.addAlignRight(spacer);
        JPanel emptyPanel = new JPanel();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        afterLoadingExecutePanel.add((Component)emptyPanel, constraints);
        this.addHelpTopicId(afterLoadingExecutePanel, this.getHelpTopicId());
        return afterLoadingExecutePanel;
    }

    private ClassChooserPanel buildPostLoadMethodClassChooserPanel(JLabel label) {
        return ClassChooserTools.buildPanel(this.postLoadMethodClassHolder, this.buildClassRepositoryHolder(), ClassChooserTools.buildDeclarableReferenceFilter(), label, this.getWorkbenchContextHolder());
    }

    private ClassRepositoryHolder buildClassRepositoryHolder() {
        return new ClassRepositoryHolder(){

            public MWClassRepository getClassRepository() {
                return AfterLoadingPropertiesPage.this.descriptor().getRepository();
            }
        };
    }

    private ListChooser buildPostLoadMethodListChooser() {
        DefaultListChooser listChooser = new DefaultListChooser(this.buildExtendedPostLoadMethodComboBoxModel(), this.getWorkbenchContextHolder(), this.buildPostLoadMethodListDialogBuilder());
        listChooser.setRenderer(DescriptorComponentFactory.buildMethodRenderer(this.resourceRepository()));
        this.updatePostLoadMethodChooser(listChooser);
        this.postLoadMethodClassHolder.addPropertyChangeListener("value", this.buildPostLoadMethodClassListener(listChooser));
        return listChooser;
    }

    private CachingComboBoxModel buildExtendedPostLoadMethodComboBoxModel() {
        return new ExtendedComboBoxModel(this.buildPostLoadMethodComboBoxModel());
    }

    private CachingComboBoxModel buildPostLoadMethodComboBoxModel() {
        return new IndirectComboBoxModel(this.postLoadMethodHolder, this.postLoadMethodClassHolder){

            protected ListIterator listValueFromSubject(Object subject) {
                return AfterLoadingPropertiesPage.this.orderedPostLoadMethodChoices((MWClass)subject);
            }
        };
    }

    ListIterator orderedPostLoadMethodChoices(MWClass mwClass) {
        return CollectionTools.sort((Iterator)mwClass.candidateDescriptorAfterLoadMethods()).listIterator();
    }

    private DefaultListChooserDialog.Builder buildPostLoadMethodListDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("POST_LOAD_METHOD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("POST_LOAD_METHOD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(DescriptorComponentFactory.buildMethodStringConverter());
        return builder;
    }

    private PropertyChangeListener buildPostLoadMethodClassListener(final ListChooser listChooser) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AfterLoadingPropertiesPage.this.updatePostLoadMethodChooser(listChooser);
            }
        };
    }

    private String getHelpTopicId() {
        return "descriptor.afterloading";
    }

    void showClassLoadingException() {
        LabelArea label = new LabelArea(this.resourceRepository().getString("PROBLEM_LOADING_CLASS"));
        JOptionPane.showMessageDialog(this, label, this.resourceRepository().getString("PROBLEM_LOADING_CLASS_TITLE"), 0);
        this.postLoadMethodClassHolder.setValue(null);
    }

    void updatePostLoadMethodChooser(ListChooser listChooser) {
        listChooser.setEnabled(this.postLoadMethodClassHolder.getValue() != null);
    }

    MWMappingDescriptor descriptor() {
        return (MWMappingDescriptor)this.selection();
    }
}

