/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWNullCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.CacheExpiryPanel;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractReadOnlyListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;

public final class CachingPolicyPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel cachingPolicyHolder;
    private PropertyValueModel nonNullCachingPolicyHolder;
    private PropertyValueModel projectDefaultCachingPolicyHolder;

    CachingPolicyPropertiesPage(PropertyValueModel valueModel, WorkbenchContextHolder contextHolder) {
        super(valueModel, contextHolder);
    }

    protected String getHelpTopicId() {
        return "descriptor.identity";
    }

    protected void initialize(PropertyValueModel selectionNodeHolder) {
        super.initialize(selectionNodeHolder);
        this.cachingPolicyHolder = this.buildCachingPolicyHolder();
        this.nonNullCachingPolicyHolder = this.buildNonNullCachingPolicyHolder();
        this.projectDefaultCachingPolicyHolder = this.buildProjectDefaultCachingPolicyHolder();
    }

    private PropertyValueModel buildNonNullCachingPolicyHolder() {
        return new FilteringPropertyValueModel(this.cachingPolicyHolder){

            protected boolean accept(Object value) {
                return !(value instanceof MWNullCachingPolicy);
            }
        };
    }

    private PropertyValueModel buildCachingPolicyHolder() {
        return new PropertyAspectAdapter(this.buildTransactionalPolicyHolder()){

            protected Object getValueFromSubject() {
                return ((MWTransactionalPolicy)this.subject).getCachingPolicy();
            }
        };
    }

    private PropertyValueModel buildTransactionalPolicyHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWTransactionalDescriptor)this.subject).getTransactionalPolicy();
            }
        };
    }

    private PropertyValueModel buildProjectDefaultCachingPolicyHolder() {
        return new PropertyAspectAdapter(this.nonNullCachingPolicyHolder){

            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getProject().getDefaultsPolicy().getCachingPolicy();
            }
        };
    }

    protected Component buildPage() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        PropertyValueModel projectCachingTypeHolder = this.buildProjectDefaultCachingTypeHolder();
        JComponent cacheTypeComboBox = this.buildLabeledComboBox("CACHING_POLICY_CACHE_TYPE_CHOOSER", new ComboBoxModelAdapter(this.buildCacheTypeCollectionHolder(), this.buildCacheTypeHolder()), this.buildCacheTypeOptionRenderer(projectCachingTypeHolder));
        new ComponentEnabler(this.buildCacheTypeHolderBooleanModel(), cacheTypeComboBox);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 5, 0, 5);
        panel.add((Component)cacheTypeComboBox, constraints);
        this.helpManager().addTopicID(cacheTypeComboBox, "descriptor.cacheType");
        projectCachingTypeHolder.addPropertyChangeListener("value", this.buildProjectDefaultListener((JComboBox)cacheTypeComboBox.getComponent(1)));
        PropertyValueModel descriptorCacheSizeHolder = this.buildCacheSizeHolder();
        final NumberSpinnerModelAdapter descriptorCacheSizeModel = new NumberSpinnerModelAdapter(descriptorCacheSizeHolder, 0, 99999, 1);
        JComponent cacheSizeWidgets = this.buildLabeledSpinnerNumber("CACHING_POLICY_CACHE_SIZE_SPINNER", descriptorCacheSizeModel);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 5);
        panel.add((Component)cacheSizeWidgets, constraints);
        this.helpManager().addTopicID(cacheSizeWidgets, "descriptor.cacheSize");
        final JSpinner cacheSizeSpinner = (JSpinner)cacheSizeWidgets.getComponent(1);
        JCheckBox defaultCacheSizeCheckBox = this.buildCheckBox("CACHING_POLICY_CACHE_SIZE_DEFAULT_CHECKBOX", this.buildDefaultCacheSizeCheckBoxAdapter());
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 0);
        panel.add((Component)defaultCacheSizeCheckBox, constraints);
        this.helpManager().addTopicID(defaultCacheSizeCheckBox, "descriptor.cacheSize.default");
        PropertyValueModel projectCacheSizeHolder = this.buildProjectCacheSizeHolder();
        final NumberSpinnerModelAdapter projectCacheSizeModel = new NumberSpinnerModelAdapter(projectCacheSizeHolder, 0, 99999, 1);
        defaultCacheSizeCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    cacheSizeSpinner.setModel(projectCacheSizeModel);
                } else {
                    cacheSizeSpinner.setModel(descriptorCacheSizeModel);
                }
            }
        });
        new ComponentEnabler(this.buildCacheSizeHolderBooleanModel(), new Component[]{cacheSizeWidgets, defaultCacheSizeCheckBox});
        PropertyValueModel cacheIsolationHolder = this.buildCacheIsolationHolder();
        PropertyValueModel projectCachingIsolationHolder = this.buildProjectDefaultCacheIsolationHolder();
        JComponent cacheIsolationComboBox = this.buildLabeledComboBox("CACHING_POLICY_CACHE_ISOLATION_CHOOSER", new ComboBoxModelAdapter(this.buildCacheIsolationCollectionHolder(), cacheIsolationHolder), this.buildCacheIsolationOptionRenderer(projectCachingIsolationHolder));
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 5, 0, 5);
        panel.add((Component)cacheIsolationComboBox, constraints);
        this.helpManager().addTopicID(cacheIsolationComboBox, "descriptor.cacheIsolation");
        projectCachingIsolationHolder.addPropertyChangeListener("value", this.buildProjectDefaultListener((JComboBox)cacheIsolationComboBox.getComponent(1)));
        PropertyValueModel projectCachingCoordinationHolder = this.buildProjectDefaultCacheCoordinationHolder();
        JComponent cacheCoordinationComboBox = this.buildLabeledComboBox("CACHING_POLICY_CACHE_COORDINATION_CHOOSER", new ComboBoxModelAdapter(this.buildCacheCoordinationCollectionHolder(), this.buildCacheCoordinationHolder()), this.buildCacheCoordinationOptionRenderer(projectCachingCoordinationHolder));
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 5, 0, 5);
        panel.add((Component)cacheCoordinationComboBox, constraints);
        this.helpManager().addTopicID(cacheCoordinationComboBox, "descriptor.cacheCoord");
        projectCachingCoordinationHolder.addPropertyChangeListener("value", this.buildProjectDefaultListener((JComboBox)cacheCoordinationComboBox.getComponent(1)));
        cacheIsolationHolder.addPropertyChangeListener("value", this.buildUpdateCacheCoordinationComboBox((JComboBox)cacheCoordinationComboBox.getComponent(1), cacheIsolationHolder, projectCachingIsolationHolder));
        projectCachingIsolationHolder.addPropertyChangeListener("value", this.buildUpdateCacheCoordinationComboBox((JComboBox)cacheCoordinationComboBox.getComponent(1), cacheIsolationHolder, projectCachingIsolationHolder));
        CacheExpiryPanel cacheExpiryPanel = new CacheExpiryPanel(this.getApplicationContext(), this.nonNullCachingPolicyHolder, this.getHelpTopicId() + ".CacheExpiry");
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 5, 5, 5);
        panel.add((Component)cacheExpiryPanel, constraints);
        PropertyValueModel projectCachingExistenceCheckingHolder = this.buildProjectDefaultExistenceCheckingHolder();
        JComponent existenceCheckingComboBox = this.buildLabeledComboBox("CACHING_POLICY_EXISTENCE_CHECKING_CHOOSER", new ComboBoxModelAdapter(this.buildExistenceCheckingCollectionHolder(), this.buildExistenceCheckingHolder()), this.buildExistenceCheckingOptionRenderer(projectCachingExistenceCheckingHolder));
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 5, 0, 5);
        panel.add((Component)existenceCheckingComboBox, constraints);
        this.addHelpTopicId(existenceCheckingComboBox, "descriptor.identity.existenceCheck");
        projectCachingExistenceCheckingHolder.addPropertyChangeListener("value", this.buildProjectDefaultListener((JComboBox)existenceCheckingComboBox.getComponent(1)));
        this.addHelpTopicId(panel, this.getHelpTopicId());
        return panel;
    }

    private ValueModel buildCacheTypeHolderBooleanModel() {
        PropertyAspectAdapter cacheTypeHolderModel = new PropertyAspectAdapter(this.cachingPolicyHolder, "cacheTypeHolder"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorCachingPolicy)this.subject).getCacheTypeHolder();
            }
        };
        return new TransformationPropertyValueModel(cacheTypeHolderModel){

            protected Object transform(Object value) {
                if (value == null) {
                    return Boolean.FALSE;
                }
                return ((MWDescriptorCachingPolicy.CacheTypeHolder)value).typeCanBeSet();
            }
        };
    }

    private ValueModel buildCacheSizeHolderBooleanModel() {
        PropertyAspectAdapter cacheSizeHolderModel = new PropertyAspectAdapter(this.cachingPolicyHolder, "cacheSizeHolder"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorCachingPolicy)this.subject).getCacheSizeHolder();
            }
        };
        return new TransformationPropertyValueModel(cacheSizeHolderModel){

            protected Object transform(Object value) {
                if (value == null) {
                    return Boolean.FALSE;
                }
                return ((MWDescriptorCachingPolicy.CacheSizeHolder)value).sizeCanBeSet();
            }
        };
    }

    private PropertyChangeListener buildProjectDefaultListener(final JComboBox comboBox) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                comboBox.repaint();
            }
        };
    }

    private PropertyChangeListener buildUpdateCacheCoordinationComboBox(final JComboBox comboBox, final PropertyValueModel cacheIsolationHolder, final PropertyValueModel projectCachingIsolationHolder) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                MWCachingPolicy.CacheIsolationOption option = (MWCachingPolicy.CacheIsolationOption)cacheIsolationHolder.getValue();
                if (option != null) {
                    String mwModelOption = option.getMWModelOption();
                    if (mwModelOption == "DEFAULT" && (MWCachingPolicy.CacheIsolationOption)projectCachingIsolationHolder.getValue() != null) {
                        mwModelOption = ((MWCachingPolicy.CacheIsolationOption)projectCachingIsolationHolder.getValue()).getMWModelOption();
                    }
                    if (mwModelOption == "Isolated") {
                        comboBox.setEnabled(false);
                    } else {
                        comboBox.setEnabled(true);
                    }
                }
            }
        };
    }

    private PropertyValueModel buildCacheTypeHolder() {
        return new PropertyAspectAdapter(this.nonNullCachingPolicyHolder, "cacheType", "cacheTypeHolder", "descriptorInheritance"){

            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getCacheType();
            }

            protected void setValueOnSubject(Object value) {
                ((MWCachingPolicy)this.subject).setCacheType((MWCachingPolicy.CacheTypeOption)value);
            }
        };
    }

    private ListValueModel buildCacheTypeCollectionHolder() {
        return new AbstractReadOnlyListValueModel(){

            public Object getValue() {
                return MWDescriptorCachingPolicy.cacheTypeOptions().toplinkOptions();
            }
        };
    }

    private ListCellRenderer buildCacheTypeOptionRenderer(final PropertyValueModel projectCacheTypeHolder) {
        return new SimpleListCellRenderer(){

            protected String buildText(Object value) {
                if (((MWCachingPolicy.CacheTypeOption)value).getMWModelOption() == "DEFAULT") {
                    if (projectCacheTypeHolder.getValue() == null) {
                        return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheTypeOption)value).resourceKey());
                    }
                    return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheTypeOption)value).resourceKey(), CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheTypeOption)projectCacheTypeHolder.getValue()).resourceKey()));
                }
                return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheTypeOption)value).resourceKey());
            }
        };
    }

    private PropertyValueModel buildProjectDefaultCachingTypeHolder() {
        return new PropertyAspectAdapter(this.projectDefaultCachingPolicyHolder, "cacheType"){

            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getCacheType();
            }
        };
    }

    private PropertyValueModel buildCacheSizeHolder() {
        return new PropertyAspectAdapter(this.nonNullCachingPolicyHolder, "cacheSize", "cacheTypeHolder", "descriptorInheritance"){

            protected Object getValueFromSubject() {
                return new Integer(((MWCachingPolicy)this.subject).getCacheSize());
            }

            protected void setValueOnSubject(Object value) {
                ((MWCachingPolicy)this.subject).setCacheSize(((Integer)value).intValue());
            }
        };
    }

    private PropertyValueModel buildProjectCacheSizeHolder() {
        return new PropertyAspectAdapter(this.projectDefaultCachingPolicyHolder, "cacheSize"){

            protected Object getValueFromSubject() {
                return new Integer(((MWCachingPolicy)this.subject).getCacheSize());
            }

            protected void setValueOnSubject(Object value) {
                if (((Integer)value).intValue() != ((MWDescriptorCachingPolicy)CachingPolicyPropertiesPage.this.cachingPolicyHolder.getValue()).getProject().getDefaultsPolicy().getCachingPolicy().getCacheSize()) {
                    ((MWDescriptorCachingPolicy)CachingPolicyPropertiesPage.this.cachingPolicyHolder.getValue()).setDontUseProjectDefaultCacheSize(((Integer)value).intValue());
                }
            }
        };
    }

    private CheckBoxModelAdapter buildDefaultCacheSizeCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildDefaultCacheSizeHolder());
    }

    private PropertyValueModel buildDefaultCacheSizeHolder() {
        return new PropertyAspectAdapter(this.nonNullCachingPolicyHolder, "useProjectDefaultCacheSize", "cacheSizeHolder", "descriptorInheritance"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorCachingPolicy)this.subject).getCacheSizeHolder().usesProjectDefaultCacheSize();
            }

            protected void setValueOnSubject(Object value) {
                ((MWDescriptorCachingPolicy)this.subject).setUseProjectDefaultCacheSize(((Boolean)value).booleanValue());
            }
        };
    }

    private PropertyValueModel buildCacheIsolationHolder() {
        return new PropertyAspectAdapter(this.nonNullCachingPolicyHolder, "cacheIsolation"){

            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getCacheIsolation();
            }

            protected void setValueOnSubject(Object value) {
                ((MWCachingPolicy)this.subject).setCacheIsolation((MWCachingPolicy.CacheIsolationOption)value);
            }
        };
    }

    private ListValueModel buildCacheIsolationCollectionHolder() {
        return new AbstractReadOnlyListValueModel(){

            public Object getValue() {
                return MWDescriptorCachingPolicy.cacheIsolationOptions().toplinkOptions();
            }
        };
    }

    private ListCellRenderer buildCacheIsolationOptionRenderer(final PropertyValueModel projectCacheIsolationHolder) {
        return new SimpleListCellRenderer(){

            protected String buildText(Object value) {
                if (((MWCachingPolicy.CacheIsolationOption)value).getMWModelOption() == "DEFAULT") {
                    if (projectCacheIsolationHolder.getValue() == null) {
                        return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheIsolationOption)value).resourceKey());
                    }
                    return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheIsolationOption)value).resourceKey(), CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheIsolationOption)projectCacheIsolationHolder.getValue()).resourceKey()));
                }
                return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheIsolationOption)value).resourceKey());
            }
        };
    }

    private PropertyValueModel buildProjectDefaultCacheIsolationHolder() {
        return new PropertyAspectAdapter(this.projectDefaultCachingPolicyHolder, "cacheIsolation"){

            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getCacheIsolation();
            }
        };
    }

    private PropertyValueModel buildCacheCoordinationHolder() {
        return new PropertyAspectAdapter(this.nonNullCachingPolicyHolder, "cacheCoordination"){

            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getCacheCoordination();
            }

            protected void setValueOnSubject(Object value) {
                ((MWCachingPolicy)this.subject).setCacheCoordination((MWCachingPolicy.CacheCoordinationOption)value);
            }
        };
    }

    private ListValueModel buildCacheCoordinationCollectionHolder() {
        return new AbstractReadOnlyListValueModel(){

            public Object getValue() {
                return MWDescriptorCachingPolicy.cacheCoordinationOptions().toplinkOptions();
            }
        };
    }

    private ListCellRenderer buildCacheCoordinationOptionRenderer(final PropertyValueModel projectCacheCoordinationHolder) {
        return new SimpleListCellRenderer(){

            protected String buildText(Object value) {
                if (((MWCachingPolicy.CacheCoordinationOption)value).getMWModelOption() == "DEFAULT") {
                    if (projectCacheCoordinationHolder.getValue() == null) {
                        return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheCoordinationOption)value).resourceKey());
                    }
                    return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheCoordinationOption)value).resourceKey(), CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheCoordinationOption)projectCacheCoordinationHolder.getValue()).resourceKey()));
                }
                return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheCoordinationOption)value).resourceKey());
            }
        };
    }

    private PropertyValueModel buildProjectDefaultCacheCoordinationHolder() {
        return new PropertyAspectAdapter(this.projectDefaultCachingPolicyHolder, "cacheCoordination"){

            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getCacheCoordination();
            }
        };
    }

    private PropertyValueModel buildExistenceCheckingHolder() {
        return new PropertyAspectAdapter(this.nonNullCachingPolicyHolder, "existenceChecking"){

            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getExistenceChecking();
            }

            protected void setValueOnSubject(Object value) {
                ((MWCachingPolicy)this.subject).setExistenceChecking((MWCachingPolicy.ExistenceCheckingOption)value);
            }
        };
    }

    private ListValueModel buildExistenceCheckingCollectionHolder() {
        return new AbstractReadOnlyListValueModel(){

            public Object getValue() {
                return MWDescriptorCachingPolicy.existenceCheckingOptions().toplinkOptions();
            }
        };
    }

    private ListCellRenderer buildExistenceCheckingOptionRenderer(final PropertyValueModel projectExistenceCheckingHolder) {
        return new SimpleListCellRenderer(){

            protected String buildText(Object value) {
                if (((MWCachingPolicy.ExistenceCheckingOption)value).getMWModelOption() == "DEFAULT") {
                    if (projectExistenceCheckingHolder.getValue() == null) {
                        return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.ExistenceCheckingOption)value).resourceKey());
                    }
                    return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.ExistenceCheckingOption)value).resourceKey(), CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.ExistenceCheckingOption)projectExistenceCheckingHolder.getValue()).resourceKey()));
                }
                return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.ExistenceCheckingOption)value).resourceKey());
            }
        };
    }

    private PropertyValueModel buildProjectDefaultExistenceCheckingHolder() {
        return new PropertyAspectAdapter(this.projectDefaultCachingPolicyHolder, "existenceChecking"){

            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getExistenceChecking();
            }
        };
    }

    private MWDescriptor rootDescriptor() {
        return ((MWMappingDescriptor)this.getSelectionHolder().getValue()).getInheritancePolicy().getRootDescriptor();
    }
}

