/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWReturningPolicy;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.Model;

public abstract class ReturningUpdateFieldsPanel
extends AbstractSubjectPanel {
    private TableModel tableModel;
    private ListValueModel sortedFieldsAdapter;
    private ObjectListSelectionModel rowSelectionModel;
    private AbstractFrameworkAction removeAction;
    static final String[] EMPTY_STRING_ARRAY = new String[0];

    protected ReturningUpdateFieldsPanel(PropertyValueModel subjectHolder, WorkbenchContextHolder contextHolder) {
        super((ValueModel)subjectHolder, contextHolder);
    }

    protected void initializeLayout() {
        this.sortedFieldsAdapter = this.buildSortedUpdateFieldsHolder();
        this.tableModel = this.buildTableModel();
        this.rowSelectionModel = this.buildRowSelectionModel();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel buttonPanel = this.buildButtonPanel();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 22;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)buttonPanel, constraints);
        JComponent updateTablePane = this.buildUpdatePanel();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)updateTablePane, constraints);
    }

    private JComponent buildUpdatePanel() {
        JTable table = this.buildTable();
        JScrollPane updateTablePane = new JScrollPane(table);
        updateTablePane.getViewport().setBackground(table.getBackground());
        return updateTablePane;
    }

    private JTable buildTable() {
        JTable table = SwingComponentFactory.buildTable(this.tableModel, this.rowSelectionModel);
        int rowHeight = 20;
        table.setRowHeight(rowHeight);
        return table;
    }

    private ObjectListSelectionModel buildRowSelectionModel() {
        ObjectListSelectionModel rowSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(this.sortedFieldsAdapter));
        rowSelectionModel.addListSelectionListener(this.buildRowSelectionListener());
        rowSelectionModel.setSelectionMode(2);
        return rowSelectionModel;
    }

    private ListSelectionListener buildRowSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ReturningUpdateFieldsPanel.this.rowSelectionChanged();
                }
            }
        };
    }

    private void rowSelectionChanged() {
        Object[] selection = this.rowSelectionModel.getSelectedValues();
        boolean fieldSelected = selection.length > 0;
        this.removeAction.setEnabled(fieldSelected);
    }

    private TableModel buildTableModel() {
        return new TableModelAdapter(this.sortedFieldsAdapter, this.buildUpdateColumnAdapter());
    }

    private ColumnAdapter buildUpdateColumnAdapter() {
        return new UpdateFieldColumnAdapter(this.resourceRepository());
    }

    private ListValueModel buildSortedUpdateFieldsHolder() {
        return new SortedListValueModelAdapter(this.buildDatabaseFieldNameAdapter());
    }

    private ListValueModel buildDatabaseFieldNameAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildUpdateFieldsAdapter(), "qualifiedName");
    }

    private CollectionValueModel buildUpdateFieldsAdapter() {
        return new CollectionAspectAdapter(this.getSubjectHolder(), "updateFields"){

            protected Iterator getValueFromSubject() {
                return ((MWReturningPolicy)this.subject).updateFields();
            }

            protected int sizeFromSubject() {
                return ((MWReturningPolicy)this.subject).updateFieldsSize();
            }
        };
    }

    protected MWReturningPolicy returningPolicy() {
        return (MWReturningPolicy)this.getSubjectHolder().getValue();
    }

    private JPanel buildButtonPanel() {
        AccessibleTitledPanel buttonPanel = new AccessibleTitledPanel(new GridLayout(1, 0, 5, 0));
        buttonPanel.add(this.buildAddButton());
        buttonPanel.add(this.buildRemoveButton());
        return buttonPanel;
    }

    private JButton buildAddButton() {
        return new JButton(this.buildAddAction());
    }

    protected String addButtonKey() {
        return "ADD_BUTTON";
    }

    protected String removeButtonKey() {
        return "REMOVE_BUTTON";
    }

    private Action buildAddAction() {
        final AbstractFrameworkAction action = new AbstractFrameworkAction(this.getApplicationContext()){

            public void actionPerformed(ActionEvent event) {
                ReturningUpdateFieldsPanel.this.addField();
            }
        };
        action.setText(this.resourceRepository().getString(this.addButtonKey()));
        action.setMnemonic(this.resourceRepository().getMnemonic(this.addButtonKey()));
        action.setEnabled(true);
        this.getSubjectHolder().addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                action.setEnabled(ReturningUpdateFieldsPanel.this.returningPolicy() != null);
            }
        });
        return action;
    }

    protected abstract void addField();

    private JButton buildRemoveButton() {
        return new JButton(this.buildRemoveAction());
    }

    private Action buildRemoveAction() {
        this.removeAction = new AbstractFrameworkAction(this.getApplicationContext()){

            public void actionPerformed(ActionEvent event) {
                ReturningUpdateFieldsPanel.this.removeField();
            }
        };
        this.removeAction.setText(this.resourceRepository().getString(this.removeButtonKey()));
        this.removeAction.setMnemonic(this.resourceRepository().getMnemonic(this.removeButtonKey()));
        this.removeAction.setEnabled(false);
        return this.removeAction;
    }

    private void removeField() {
        Object[] selectedFields = this.selectedFields();
        int index = selectedFields.length;
        while (--index >= 0) {
            this.returningPolicy().removeUpdateField((MWDataField)selectedFields[index]);
        }
    }

    private Object[] selectedFields() {
        return this.rowSelectionModel.getSelectedValues();
    }

    private static class UpdateFieldColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 1;
        public static final int UPDATE_FIELD_COLUMN = 0;
        private final String[] COLUMN_NAME_KEYS = new String[]{"RETURNING_POLICY_UPDATE_COLUMN_HEADER"};

        protected UpdateFieldColumnAdapter(ResourceRepository repository) {
            this.resourceRepository = repository;
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int index) {
            return this.resourceRepository.getString(this.COLUMN_NAME_KEYS[index]);
        }

        public Class getColumnClass(int index) {
            switch (index) {
                case 0: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        public boolean isColumnEditable(int index) {
            return false;
        }

        public PropertyValueModel[] cellModels(Object subject) {
            PropertyValueModel[] result = new PropertyValueModel[]{this.buildUpdateFieldAdapter((MWDataField)subject)};
            return result;
        }

        private PropertyValueModel buildUpdateFieldAdapter(MWDataField field) {
            return new PropertyAspectAdapter("fieldName", (Model)field){

                protected Object getValueFromSubject() {
                    return ((MWDataField)this.subject).fieldName();
                }
            };
        }
    }
}

