/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.RefreshCachePolicyPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

public class TransactionalDescriptorComponentFactory
extends SwingComponentFactory {
    public static JCheckBox buildReadOnlyCheckBox(ValueModel transactionalDescriptorHolder, ApplicationContext context) {
        JCheckBox readOnlyCheckBox = TransactionalDescriptorComponentFactory.buildCheckBox("READ_ONLY_CHECKBOX_TEXT", TransactionalDescriptorComponentFactory.buildReadOnlyCheckBoxModel(transactionalDescriptorHolder), context.getResourceRepository());
        context.getHelpManager().addTopicID(readOnlyCheckBox, "descriptor.transactional.readOnly");
        return readOnlyCheckBox;
    }

    private static ButtonModel buildReadOnlyCheckBoxModel(ValueModel transactionalDescriptorHolder) {
        return new CheckBoxModelAdapter(TransactionalDescriptorComponentFactory.buildReadOnlyAdapter(transactionalDescriptorHolder));
    }

    private static PropertyValueModel buildReadOnlyAdapter(ValueModel transactionalDescriptorHolder) {
        return new PropertyAspectAdapter(transactionalDescriptorHolder, "readOnly"){

            protected Object getValueFromSubject() {
                return ((MWTransactionalDescriptor)this.subject).getTransactionalPolicy().isReadOnly();
            }

            protected void setValueOnSubject(Object value) {
                ((MWTransactionalDescriptor)this.subject).getTransactionalPolicy().setReadOnly(((Boolean)value).booleanValue());
            }
        };
    }

    public static JCheckBox buildConformResultsInUnitOfWorkCheckBox(PropertyValueModel transactionalDescriptorHolder, ApplicationContext context) {
        JCheckBox checkBox = TransactionalDescriptorComponentFactory.buildCheckBox("CONFORM_RESULTS_CHECKBOX_TEXT", TransactionalDescriptorComponentFactory.buildConformResultsInUnitOfWorkCheckBoxModel(transactionalDescriptorHolder), context.getResourceRepository());
        context.getHelpManager().addTopicID(checkBox, "descriptor.transactional.conform");
        return checkBox;
    }

    private static ButtonModel buildConformResultsInUnitOfWorkCheckBoxModel(PropertyValueModel transactionalDescriptorHolder) {
        return new CheckBoxModelAdapter(TransactionalDescriptorComponentFactory.buildConformResultsInUnitOfWorkAdapter(transactionalDescriptorHolder));
    }

    private static PropertyValueModel buildConformResultsInUnitOfWorkAdapter(PropertyValueModel transactionalDescriptorHolder) {
        return new PropertyAspectAdapter((ValueModel)transactionalDescriptorHolder, "conformResultsInUnitOfWork"){

            protected Object getValueFromSubject() {
                return ((MWTransactionalDescriptor)this.subject).getTransactionalPolicy().isConformResultsInUnitOfWork();
            }

            protected void setValueOnSubject(Object value) {
                ((MWTransactionalDescriptor)this.subject).getTransactionalPolicy().setConformResultsInUnitOfWork(((Boolean)value).booleanValue());
            }
        };
    }

    public static RefreshCachePolicyPanel buildRefreshCachePolicyPanel(PropertyValueModel transactionalDescriptorHolder, ApplicationContext context) {
        return new RefreshCachePolicyPanel(context, TransactionalDescriptorComponentFactory.buildRefreshCachePolicyHolder(transactionalDescriptorHolder));
    }

    private static PropertyValueModel buildRefreshCachePolicyHolder(PropertyValueModel transactionalDescriptorHolder) {
        return new PropertyAspectAdapter(transactionalDescriptorHolder){

            protected Object getValueFromSubject() {
                return ((MWTransactionalDescriptor)this.subject).getTransactionalPolicy().getRefreshCachePolicy();
            }
        };
    }

    public static Document buildDescriptorAliasDocumentAdapter(ValueModel mappingDescriptorHolder) {
        return new DocumentAdapter(TransactionalDescriptorComponentFactory.buildDescriptorAliasHolder(mappingDescriptorHolder));
    }

    private static PropertyValueModel buildDescriptorAliasHolder(ValueModel mappingDescriptorHolder) {
        return new PropertyAspectAdapter((ValueModel)TransactionalDescriptorComponentFactory.buildTransactionalPolicyHolder(mappingDescriptorHolder), "descriptorAlias"){

            protected Object getValueFromSubject() {
                return ((MWTransactionalPolicy)this.subject).getDescriptorAlias();
            }

            protected void setValueOnSubject(Object value) {
                ((MWTransactionalPolicy)this.subject).setDescriptorAlias((String)value);
            }
        };
    }

    private static PropertyValueModel buildTransactionalPolicyHolder(ValueModel mappingDescriptorHolder) {
        return new PropertyAspectAdapter(mappingDescriptorHolder){

            protected Object getValueFromSubject() {
                return ((MWMappingDescriptor)this.subject).getTransactionalPolicy();
            }
        };
    }
}

