/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JRadioButton;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorLockingPolicy;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;

public class VersionTimestampLockingPanel
extends AbstractSubjectPanel {
    private PropertyValueModel optimisticVersionLockingPolicyRetrieveTimeModel;
    private PropertyValueModel optimisticVersionLockingPolicyTypeModel;

    protected VersionTimestampLockingPanel(ValueModel lockingPolicyHolder, WorkbenchContextHolder contextHolder) {
        super(lockingPolicyHolder, contextHolder);
    }

    protected void initialize(ValueModel subjectHolder) {
        super.initialize(subjectHolder);
        this.optimisticVersionLockingPolicyRetrieveTimeModel = this.buildOptimisticVersionLockingPolicyRetrieveTimeValueHolder();
        this.optimisticVersionLockingPolicyTypeModel = this.buildOptimisticVersionLockingPolicyTypeValueHolder();
    }

    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        JRadioButton useServer = this.buildUseServerTimeButton();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.addHelpTopicId(useServer, this.getHelpTopicId() + ".useServer");
        this.add((Component)useServer, constraints);
        JRadioButton useLocal = this.buildUseLocalTimeButton();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.addHelpTopicId(useServer, this.getHelpTopicId() + ".useLocal");
        this.add((Component)useLocal, constraints);
        this.buildVersionTimestampLockingPanelEnabler(new Component[]{useServer, useLocal});
    }

    private PropertyValueModel buildOptimisticVersionLockingPolicyRetrieveTimeValueHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "retrieveTimeFrom"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorLockingPolicy)this.subject).getRetrieveTimeFrom();
            }

            protected void setValueOnSubject(Object value) {
                ((MWDescriptorLockingPolicy)this.subject).setRetrieveTimeFrom((String)value);
            }
        };
    }

    private PropertyValueModel buildOptimisticVersionLockingPolicyTypeValueHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "optimisticVersionLockingType"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorLockingPolicy)this.subject).getOptimisticVersionLockingType();
            }

            protected void setValueOnSubject(Object value) {
                ((MWDescriptorLockingPolicy)this.subject).setOptimisticVersionLockingType((String)value);
            }
        };
    }

    private JRadioButton buildUseServerTimeButton() {
        return this.buildRadioButton("LOCKING_POLICY_SERVER_TIME", new RadioButtonModelAdapter(this.optimisticVersionLockingPolicyRetrieveTimeModel, "Server"));
    }

    private JRadioButton buildUseLocalTimeButton() {
        return this.buildRadioButton("LOCKING_POLICY_LOCAL_TIME", new RadioButtonModelAdapter(this.optimisticVersionLockingPolicyRetrieveTimeModel, "Local"));
    }

    private ComponentEnabler buildVersionTimestampLockingPanelEnabler(Component[] components) {
        TransformationPropertyValueModel booleanHolder = new TransformationPropertyValueModel(this.optimisticVersionLockingPolicyTypeModel){

            protected Object transform(Object value) {
                return value == "Timestamp Locking";
            }
        };
        return new ComponentEnabler((ValueModel)booleanHolder, components);
    }

    protected String getHelpTopicId() {
        return "descriptor.relational.locking.optimistic.version.timestamp";
    }
}

