/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.framework.uitools.Pane;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.MethodCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExtendedComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.IndirectComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

public final class MethodAccessingPanel
extends AbstractSubjectPanel {
    private ListCellRenderer methodListCellRenderer;
    private PropertyValueModel methodAccessingHolder;

    public MethodAccessingPanel(PropertyValueModel mappingHolder, WorkbenchContextHolder contextHolder) {
        super((ValueModel)mappingHolder, contextHolder);
    }

    protected void initialize(ValueModel subjectHolder) {
        super.initialize(subjectHolder);
        this.methodAccessingHolder = this.buildMethodAccessingHolder();
    }

    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        JCheckBox methodAccessingCheckBox = this.buildMethodAccessingCheckBox();
        Pane methodAccessingPanel = new Pane(new GridBagLayout());
        GroupBox groupBox = new GroupBox(methodAccessingCheckBox, (JComponent)methodAccessingPanel);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)groupBox, constraints);
        JComponent getMethodWidgets = this.buildLabeledComponent("GET_METHOD_LABEL", this.buildGetMethodChooser());
        components.add(getMethodWidgets);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        methodAccessingPanel.add((Component)getMethodWidgets, constraints);
        JComponent setMethodWidgets = this.buildLabeledComponent("SET_METHOD_LABEL", this.buildSetMethodChooser());
        components.add(setMethodWidgets);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        methodAccessingPanel.add((Component)setMethodWidgets, constraints);
        this.addHelpTopicId(this, "mapping.methodAccessing");
        new ComponentEnabler((ValueModel)this.methodAccessingHolder, components);
    }

    private JCheckBox buildMethodAccessingCheckBox() {
        JCheckBox checkBox = this.buildCheckBox("USE_METHOD_ACCESSING_CHECK_BOX", new CheckBoxModelAdapter(this.methodAccessingHolder));
        return checkBox;
    }

    private PropertyValueModel buildMethodAccessingHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "usesMethodAccessing"){

            protected Object getValueFromSubject() {
                return ((MWMapping)this.subject).usesMethodAccessing();
            }

            protected void setValueOnSubject(Object value) {
                ((MWMapping)this.subject).setUsesMethodAccessing(((Boolean)value).booleanValue());
            }
        };
    }

    private ListChooser buildGetMethodChooser() {
        DefaultListChooser listChooser = new DefaultListChooser(this.buildGetMethodComboBoxModel(), this.getWorkbenchContextHolder(), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()), this.buildGetMethodChooserDialogBuilder());
        listChooser.setRenderer(this.getMethodListCellRenderer());
        return listChooser;
    }

    private CachingComboBoxModel buildGetMethodComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.buildGetMethodHolder(), this.getSubjectHolder()){

            protected ListIterator listValueFromSubject(Object subject) {
                return MethodAccessingPanel.this.orderedGetMethodChoices((MWMapping)subject);
            }
        });
    }

    private PropertyValueModel buildGetMethodHolder() {
        PropertyAspectAdapter propertyValueModel = new PropertyAspectAdapter(this.getSubjectHolder(), "getMethod"){

            protected Object getValueFromSubject() {
                return ((MWMapping)this.subject).getGetMethod();
            }

            protected void setValueOnSubject(Object value) {
                ((MWMapping)this.subject).setGetMethod((MWMethod)value);
            }
        };
        return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyValueModel, "signature");
    }

    ListIterator orderedGetMethodChoices(MWMapping mapping) {
        return CollectionTools.sort((Iterator)this.getMethodChoices(mapping)).listIterator();
    }

    private Iterator getMethodChoices(MWMapping mapping) {
        return mapping.candidateGetMethods();
    }

    private DefaultListChooserDialog.Builder buildGetMethodChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("GET_METHOD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("GET_METHOD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildMethodStringConverter());
        return builder;
    }

    private ListChooser buildSetMethodChooser() {
        DefaultListChooser listChooser = new DefaultListChooser(this.buildSetMethodComboBoxModel(), this.getWorkbenchContextHolder(), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()), this.buildSetMethodChooserDialogBuilder());
        listChooser.setRenderer(this.getMethodListCellRenderer());
        return listChooser;
    }

    private CachingComboBoxModel buildSetMethodComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.buildSetMethodHolder(), this.getSubjectHolder()){

            protected ListIterator listValueFromSubject(Object subject) {
                return MethodAccessingPanel.this.orderedSetMethodChoices((MWMapping)subject);
            }
        });
    }

    private PropertyValueModel buildSetMethodHolder() {
        PropertyAspectAdapter propertyValueModel = new PropertyAspectAdapter(this.getSubjectHolder(), "setMethod"){

            protected Object getValueFromSubject() {
                return ((MWMapping)this.subject).getSetMethod();
            }

            protected void setValueOnSubject(Object value) {
                ((MWMapping)this.subject).setSetMethod((MWMethod)value);
            }
        };
        return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyValueModel, "signature");
    }

    ListIterator orderedSetMethodChoices(MWMapping mapping) {
        return CollectionTools.sort((Iterator)this.setMethodChoices(mapping)).listIterator();
    }

    private Iterator setMethodChoices(MWMapping mapping) {
        return mapping.candidateSetMethods();
    }

    private DefaultListChooserDialog.Builder buildSetMethodChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("SET_METHOD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("SET_METHOD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildMethodStringConverter());
        return builder;
    }

    private StringConverter buildMethodStringConverter() {
        return new StringConverter(){

            public String convertToString(Object o) {
                return o == null ? "" : ((MWMethod)o).getName();
            }
        };
    }

    private ListCellRenderer getMethodListCellRenderer() {
        if (this.methodListCellRenderer == null) {
            this.methodListCellRenderer = new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository()));
        }
        return this.methodListCellRenderer;
    }
}

