/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational;

import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWOneToOneMapping;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.ColumnPairsPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.AbstractTableReferencePanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.utility.Model;

final class OneToOneTableReferencePanel
extends AbstractTableReferencePanel {
    OneToOneTableReferencePanel(PropertyValueModel oneToOneMappingHolder, WorkbenchContextHolder contextHolder) {
        super(oneToOneMappingHolder, contextHolder);
    }

    protected ColumnPairsPanel buildColumnPairsPanel() {
        return new ExpandedColumnPairsPanel(this.getSubjectHolder(), this.getWorkbenchContextHolder(), this.buildTableReferenceHolder());
    }

    protected MWTable defaultNewReferenceSourceTable() {
        Iterator candidateTables = this.mapping().getParentRelationalDescriptor().candidateTables();
        return candidateTables.hasNext() ? (MWTable)candidateTables.next() : null;
    }

    protected MWTable defaultNewReferenceTargetTable() {
        MWRelationalDescriptor descriptor = (MWRelationalDescriptor)this.mapping().getReferenceDescriptor();
        if (descriptor == null) {
            return null;
        }
        Iterator candidateTables = descriptor.candidateTables();
        return candidateTables.hasNext() ? (MWTable)candidateTables.next() : null;
    }

    private MWOneToOneMapping mapping() {
        return (MWOneToOneMapping)this.subject();
    }

    private static class TargetForeignKeyAdapter
    extends CollectionPropertyValueModelAdapter {
        private ExpandedColumnPairsColumnAdapter columnAdapter;
        private MWColumnPair columnPair;

        public TargetForeignKeyAdapter(CollectionValueModel collectionHolder, ExpandedColumnPairsColumnAdapter columnAdapter, MWColumnPair columnPair) {
            super(collectionHolder);
            this.columnAdapter = columnAdapter;
            this.columnPair = columnPair;
        }

        public Object getValue() {
            Object result = super.getValue();
            return result == null ? Boolean.FALSE : result;
        }

        public void setValue(Object value) {
            if (this.booleanValue()) {
                if (!this.booleanValueOf(value)) {
                    this.mapping().removeTargetForeignKey(this.columnPair);
                }
            } else if (this.booleanValueOf(value)) {
                this.mapping().addTargetForeignKey(this.columnPair);
            }
        }

        protected Object buildValue() {
            return this.columnPairIsTargetForeignKey();
        }

        private boolean booleanValue() {
            return this.booleanValueOf(this.value);
        }

        private boolean booleanValueOf(Object b) {
            return b == null ? false : (Boolean)b;
        }

        private ValueModel mappingHolder() {
            return this.columnAdapter.mappingHolder();
        }

        private MWOneToOneMapping mapping() {
            return (MWOneToOneMapping)this.mappingHolder().getValue();
        }

        private boolean columnPairIsTargetForeignKey() {
            MWOneToOneMapping mapping = this.mapping();
            if (mapping == null) {
                return false;
            }
            return mapping.containsTargetForeignKey(this.columnPair);
        }
    }

    private static class ExpandedColumnPairsColumnAdapter
    implements ColumnAdapter {
        private ExpandedColumnPairsPanel panel;
        private ResourceRepository resourceRepository;
        private static final String[] COLUMN_NAME_KEYS = new String[]{"ONE_TO_ONE_SOURCE_FIELD_COLUMN", "ONE_TO_ONE_TARGET_FIELD_COLUMN", "ONE_TO_ONE_TARGET_FOREIGN_KEY"};
        private static final int COLUMN_COUNT = 3;
        private static final int SOURCE_COLUMN_COLUMN = 0;
        private static final int TARGET_COLUMN_COLUMN = 1;
        private static final int TARGET_FOREIGN_KEY_COLUMN = 2;

        private ExpandedColumnPairsColumnAdapter(ExpandedColumnPairsPanel panel, ResourceRepository resourceRepository) {
            this.panel = panel;
            this.resourceRepository = resourceRepository;
        }

        public PropertyValueModel[] cellModels(Object subject) {
            MWColumnPair columnPair = (MWColumnPair)subject;
            PropertyValueModel[] result = new PropertyValueModel[]{this.buildSourceColumnAdapter(columnPair), this.buildTargetColumnAdapter(columnPair), this.buildTargetForeignKeyAdapter(columnPair)};
            return result;
        }

        public Class getColumnClass(int index) {
            switch (index) {
                case 2: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int index) {
            return this.resourceRepository.getString(COLUMN_NAME_KEYS[index]);
        }

        public boolean isColumnEditable(int index) {
            return true;
        }

        private PropertyValueModel buildSourceColumnAdapter(MWColumnPair columnPair) {
            PropertyAspectAdapter adapter = new PropertyAspectAdapter("sourceColumn", (Model)columnPair){

                protected Object getValueFromSubject() {
                    return ((MWColumnPair)this.subject).getSourceColumn();
                }

                protected void setValueOnSubject(Object value) {
                    ((MWColumnPair)this.subject).setSourceColumn((MWColumn)value);
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)adapter, "name");
        }

        private PropertyValueModel buildTargetColumnAdapter(MWColumnPair columnPair) {
            PropertyAspectAdapter adapter = new PropertyAspectAdapter("targetColumn", (Model)columnPair){

                protected Object getValueFromSubject() {
                    return ((MWColumnPair)this.subject).getTargetColumn();
                }

                protected void setValueOnSubject(Object value) {
                    ((MWColumnPair)this.subject).setTargetColumn((MWColumn)value);
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)adapter, "name");
        }

        ValueModel mappingHolder() {
            return this.panel.getMappingHolder();
        }

        private PropertyValueModel buildTargetForeignKeyAdapter(MWColumnPair columnPair) {
            return new TargetForeignKeyAdapter(this.buildTargetForeignKeysAdapter(), this, columnPair);
        }

        private CollectionValueModel buildTargetForeignKeysAdapter() {
            return new CollectionAspectAdapter(this.mappingHolder(), "targetForeignKeys"){

                protected Iterator getValueFromSubject() {
                    return ((MWOneToOneMapping)this.subject).targetForeignKeys();
                }
            };
        }
    }

    private static class ExpandedColumnPairsPanel
    extends ColumnPairsPanel {
        private ValueModel mappingHolder;

        private ExpandedColumnPairsPanel(ValueModel mappingHolder, WorkbenchContextHolder contextHolder, PropertyValueModel referenceHolder) {
            super(contextHolder, referenceHolder);
            this.mappingHolder = mappingHolder;
        }

        protected ColumnAdapter buildColumnAdapter() {
            return new ExpandedColumnPairsColumnAdapter(this, this.resourceRepository());
        }

        ValueModel getMappingHolder() {
            return this.mappingHolder;
        }
    }
}

