/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational;

import java.awt.Component;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWFieldTransformerAssociation;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalFieldTransformerAssociation;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalTransformationMapping;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.FieldTransformerAssociationEditingDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.RelationalFieldTransformerAssociationEditingPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.BufferedPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.Model;

final class RelationalFieldTransformerAssociationEditingDialog
extends FieldTransformerAssociationEditingDialog {
    static void promptToAddFieldTransformerAssociation(MWRelationalTransformationMapping transformationMapping, WorkbenchContext context) {
        MWRelationalFieldTransformerAssociation association = transformationMapping.buildEmptyFieldTransformerAssociation();
        RelationalFieldTransformerAssociationEditor editor = new RelationalFieldTransformerAssociationEditor(association);
        RelationalFieldTransformerAssociationEditingDialog dialog = new RelationalFieldTransformerAssociationEditingDialog(editor, context);
        dialog.show();
        if (dialog.wasConfirmed()) {
            editor.commit();
            transformationMapping.addFieldTransformerAssociation((MWFieldTransformerAssociation)association);
        }
    }

    static void promptToEditFieldTransformerAssociation(MWRelationalFieldTransformerAssociation association, WorkbenchContext context) {
        RelationalFieldTransformerAssociationEditor editor = new RelationalFieldTransformerAssociationEditor(association);
        RelationalFieldTransformerAssociationEditingDialog dialog = new RelationalFieldTransformerAssociationEditingDialog(editor, context);
        dialog.show();
        if (dialog.wasConfirmed()) {
            editor.commit();
        }
    }

    private RelationalFieldTransformerAssociationEditingDialog(RelationalFieldTransformerAssociationEditor associationEditor, WorkbenchContext context) {
        super(associationEditor, context);
    }

    protected void initialize(FieldTransformerAssociationEditingDialog.FieldTransformerAssociationEditor associationEditor) {
        super.initialize(associationEditor);
        this.associationEditor().fieldHolder().addPropertyChangeListener("value", this.validatingListener);
    }

    protected Component buildMainPanel() {
        return new RelationalFieldTransformerAssociationEditingPanel(this.associationEditor(), this.getWorkbenchContext());
    }

    protected void updateMessage() {
        super.updateMessage();
        if (this.associationEditor().field() == null) {
            this.setErrorMessageKey("FIELD_TRANSFORMER_ASSOCIATION_EDITING_DIALOG.NULL_FIELD_ERROR");
        }
        if (this.associationEditor().fieldIsDuplicate()) {
            this.setWarningMessageKey("FIELD_TRANSFORMER_ASSOCIATION_EDITING_DIALOG.DUPLICATE_FIELD_WARNING");
        }
    }

    protected void prepareToShow() {
        this.pack();
        this.setSize(Math.max(600, this.getWidth()), this.getHeight());
        this.setLocationRelativeTo(this.getParent());
    }

    private RelationalFieldTransformerAssociationEditor associationEditor() {
        return (RelationalFieldTransformerAssociationEditor)this.associationEditor;
    }

    private static class RelationalFieldTransformerAssociationEditor
    extends FieldTransformerAssociationEditingDialog.AbstractFieldTransformerAssociationEditor
    implements RelationalFieldTransformerAssociationEditingPanel.RelationalFieldTransformerAssociationSpec {
        private BufferedPropertyValueModel fieldHolder;
        private BufferedPropertyValueModel.Trigger fieldTrigger = new BufferedPropertyValueModel.Trigger();

        protected RelationalFieldTransformerAssociationEditor(MWRelationalFieldTransformerAssociation association) {
            super((MWFieldTransformerAssociation)association);
        }

        private MWRelationalFieldTransformerAssociation association() {
            return (MWRelationalFieldTransformerAssociation)this.association;
        }

        private MWRelationalTransformationMapping transformationMapping() {
            return (MWRelationalTransformationMapping)this.association().getMapping();
        }

        public PropertyValueModel fieldHolder() {
            if (this.fieldHolder == null) {
                this.fieldHolder = this.buildFieldHolder();
            }
            return this.fieldHolder;
        }

        private BufferedPropertyValueModel buildFieldHolder() {
            return new BufferedPropertyValueModel(this.buildInternalFieldHolder(), this.fieldTrigger);
        }

        private PropertyValueModel buildInternalFieldHolder() {
            return new PropertyAspectAdapter("field", (Model)this.association()){

                protected Object getValueFromSubject() {
                    return ((MWRelationalFieldTransformerAssociation)this.subject).getColumn();
                }

                protected void setValueOnSubject(Object value) {
                    ((MWRelationalFieldTransformerAssociation)this.subject).setColumn((MWColumn)value);
                }
            };
        }

        protected MWColumn field() {
            return (MWColumn)this.fieldHolder().getValue();
        }

        public Iterator candidateFields() {
            return this.transformationMapping().candidateColumns();
        }

        public boolean fieldIsDuplicate() {
            return this.association().duplicateField(this.field());
        }

        public void commit() {
            super.commit();
            this.fieldTrigger.accept();
        }
    }
}

