/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational;

import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWJoinFetchableMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalDirectContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalDirectMapMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWTableReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ColumnCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.MappingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectNode;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractReadOnlyListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ExtendedListValueModelWrapper;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExtendedComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.IndirectComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

public final class RelationalMappingComponentFactory
extends MappingComponentFactory {
    static ListChooser buildColumnChooser(ValueModel relationalDirectMappingHolder, ValueModel parentDescriptorHolder, WorkbenchContextHolder contextHolder) {
        ResourceRepository resourceRepository = contextHolder.getWorkbenchContext().getApplicationContext().getResourceRepository();
        DefaultListChooser listChooser = new DefaultListChooser(RelationalMappingComponentFactory.buildExtendedColumnComboBoxModel(RelationalMappingComponentFactory.buildColumnHolder(relationalDirectMappingHolder), parentDescriptorHolder), contextHolder, RelationalMappingComponentFactory.buildColumnNodeSelector(contextHolder), RelationalMappingComponentFactory.buildColumnChooserDialogBuilder());
        listChooser.setRenderer(RelationalMappingComponentFactory.buildColumnListRenderer(parentDescriptorHolder, resourceRepository));
        return listChooser;
    }

    public static DefaultListChooserDialog.Builder buildColumnChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("DATABASE_FIELD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("DATABASE_FIELD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(RelationalMappingComponentFactory.buildColumnStringConverter());
        return builder;
    }

    private static ListIterator orderedColumns(MWRelationalClassDescriptor descriptor) {
        return CollectionTools.sort((Iterator)descriptor.allAssociatedColumns()).listIterator();
    }

    public static CachingComboBoxModel buildExtendedColumnComboBoxModel(PropertyValueModel databaseFieldHolder, ValueModel parentDescriptorHolder) {
        return new ExtendedComboBoxModel(RelationalMappingComponentFactory.buildColumnComboBoxModel(databaseFieldHolder, parentDescriptorHolder));
    }

    public static CachingComboBoxModel buildColumnComboBoxModel(PropertyValueModel databaseFieldHolder, ValueModel parentDescriptorHolder) {
        return new IndirectComboBoxModel(databaseFieldHolder, parentDescriptorHolder){

            protected ListIterator listValueFromSubject(Object subject) {
                return RelationalMappingComponentFactory.orderedColumns((MWRelationalClassDescriptor)subject);
            }

            protected int listSizeFromSubject(Object subject) {
                return ((MWRelationalClassDescriptor)subject).allAssociatedColumnsSize();
            }
        };
    }

    public static ListCellRenderer buildColumnListRenderer(final ValueModel parentDescriptorHolder, ResourceRepository resourceRepository) {
        return new AdaptableListCellRenderer(new ColumnCellRendererAdapter(resourceRepository){

            protected String buildNullValueText() {
                if (parentDescriptorHolder.getValue() == null) {
                    return super.buildNullValueText();
                }
                if (((MWRelationalDescriptor)parentDescriptorHolder.getValue()).isAggregateDescriptor()) {
                    return " ";
                }
                return super.buildNullValueText();
            }
        });
    }

    public static StringConverter buildColumnStringConverter() {
        return new StringConverter(){

            public String convertToString(Object o) {
                return o == null ? "" : ((MWColumn)o).qualifiedName();
            }
        };
    }

    private static PropertyValueModel buildColumnHolder(ValueModel mappingHolder) {
        PropertyAspectAdapter propertyValueModel = new PropertyAspectAdapter(mappingHolder, "column"){

            protected Object getValueFromSubject() {
                return ((MWRelationalDirectMapping)this.subject).getColumn();
            }

            protected void setValueOnSubject(Object value) {
                ((MWRelationalDirectMapping)this.subject).setColumn((MWColumn)value);
            }
        };
        return new ValuePropertyPropertyValueModelAdapter(propertyValueModel, "qualifiedName", "databaseType");
    }

    public static NodeSelector buildColumnNodeSelector(final WorkbenchContextHolder contextHolder) {
        return new NodeSelector(){

            public void selectNodeFor(Object item) {
                RelationalProjectNode projectNode = (RelationalProjectNode)contextHolder.getWorkbenchContext().getNavigatorSelectionModel().getSelectedProjectNodes()[0];
                projectNode.selectColumn((MWColumn)item, contextHolder.getWorkbenchContext());
            }
        };
    }

    static JCheckBox buildBatchReadingCheckBox(ValueModel tableReferenceMappingHolder, ResourceRepository resourceRepository) {
        return RelationalMappingComponentFactory.buildCheckBox("MAPPING_BATCH_READING_CHECK_BOX", RelationalMappingComponentFactory.buildUseBatchReadingCheckBoxAdapter(tableReferenceMappingHolder), resourceRepository);
    }

    private static ButtonModel buildUseBatchReadingCheckBoxAdapter(ValueModel tableReferenceMappingHolder) {
        return new CheckBoxModelAdapter(RelationalMappingComponentFactory.buildUseBatchReadingHolder(tableReferenceMappingHolder));
    }

    private static PropertyValueModel buildUseBatchReadingHolder(ValueModel tableReferenceMappingHolder) {
        return new PropertyAspectAdapter(tableReferenceMappingHolder, "usesBatchReading"){

            protected Object getValueFromSubject() {
                return ((MWTableReferenceMapping)this.subject).usesBatchReading();
            }

            protected void setValueOnSubject(Object value) {
                ((MWTableReferenceMapping)this.subject).setUsesBatchReading(((Boolean)value).booleanValue());
            }
        };
    }

    private static PropertyValueModel buildJoinFetchingHolder(ValueModel joinFetchableMappingHolder) {
        return new PropertyAspectAdapter(joinFetchableMappingHolder, "joinFetchOption"){

            protected Object getValueFromSubject() {
                return ((MWJoinFetchableMapping)this.subject).getJoinFetchOption();
            }

            protected void setValueOnSubject(Object value) {
                ((MWJoinFetchableMapping)this.subject).setJoinFetchOption((MWJoinFetchableMapping.JoinFetchOption)value);
            }
        };
    }

    public static JComboBox buildJoinFetchingCombobox(ValueModel joinFetchableMappingHolder, WorkbenchContextHolder context) {
        PropertyValueModel joinFetchingHolder = RelationalMappingComponentFactory.buildJoinFetchingHolder(joinFetchableMappingHolder);
        DefaultListChooser fetchChooser = new DefaultListChooser((ComboBoxModel)new ComboBoxModelAdapter(RelationalMappingComponentFactory.buildJoinFetchCollectionHolder(joinFetchableMappingHolder.getValue()), joinFetchingHolder), context);
        fetchChooser.setRenderer(RelationalMappingComponentFactory.buildJoinFetchOptionRenderer(context.getWorkbenchContext().getApplicationContext().getResourceRepository()));
        return fetchChooser;
    }

    private static ListValueModel buildJoinFetchCollectionHolder(Object joinFetchableMapping) {
        return new AbstractReadOnlyListValueModel(){

            public Object getValue() {
                return MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().toplinkOptions();
            }
        };
    }

    private static ListCellRenderer buildJoinFetchOptionRenderer(final ResourceRepository resourceRepository) {
        return new SimpleListCellRenderer(){

            protected String buildText(Object value) {
                return resourceRepository.getString(((MWJoinFetchableMapping.JoinFetchOption)value).resourceKey());
            }
        };
    }

    static ListChooser buildTargetTableChooser(PropertyValueModel directContainerMappingHolder, WorkbenchContextHolder contextHolder) {
        return RelationalProjectComponentFactory.buildTableChooser(directContainerMappingHolder, RelationalMappingComponentFactory.buildTargetTableHolder(directContainerMappingHolder), RelationalMappingComponentFactory.buildTargetTableChooserDialogBuilder(), contextHolder);
    }

    private static DefaultListChooserDialog.Builder buildTargetTableChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("DIRECT_CONTAINER_MAPPING_TARGET_TABLE_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("DIRECT_CONTAINER_MAPPING_TARGET_TABLE_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(RelationalMappingComponentFactory.buildTableStringConverter());
        return builder;
    }

    private static StringConverter buildTableStringConverter() {
        return new StringConverter(){

            public String convertToString(Object o) {
                return o == null ? "" : ((MWTable)o).getName();
            }
        };
    }

    private static ValueModel buildParentDescriptorHolder(ValueModel mappingHolder) {
        return new PropertyAspectAdapter(mappingHolder){

            protected Object getValueFromSubject() {
                return ((MWMapping)this.subject).getParentDescriptor();
            }
        };
    }

    private static PropertyValueModel buildTargetTableHolder(ValueModel directContainerMappingHolder) {
        return new PropertyAspectAdapter(directContainerMappingHolder, "targetTable"){

            protected Object getValueFromSubject() {
                return ((MWRelationalDirectContainerMapping)this.subject).getTargetTable();
            }

            protected void setValueOnSubject(Object value) {
                ((MWRelationalDirectContainerMapping)this.subject).setTargetTable((MWTable)value);
            }
        };
    }

    static ListChooser buildDirectValueColumnChooser(ValueModel directContainerMappingHolder, WorkbenchContextHolder contextHolder) {
        DefaultListChooser listChooser = new DefaultListChooser(RelationalMappingComponentFactory.buildDirectValueColumnComboModel(directContainerMappingHolder), contextHolder, RelationalMappingComponentFactory.buildColumnNodeSelector(contextHolder), RelationalMappingComponentFactory.buildDirectValueColumnChooserDialogBuilder());
        listChooser.setRenderer(RelationalMappingComponentFactory.buildColumnListRenderer(RelationalMappingComponentFactory.buildParentDescriptorHolder(directContainerMappingHolder), contextHolder.getWorkbenchContext().getApplicationContext().getResourceRepository()));
        return listChooser;
    }

    private static DefaultListChooserDialog.Builder buildDirectValueColumnChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("DIRECT_VALUE_FIELD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("DIRECT_VALUE_FIELD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(RelationalMappingComponentFactory.buildColumnStringConverter());
        return builder;
    }

    private static ComboBoxModel buildDirectValueColumnComboModel(ValueModel directContainerMappingHolder) {
        return new ComboBoxModelAdapter(RelationalMappingComponentFactory.buildDirectValueColumnListHolder(directContainerMappingHolder), RelationalMappingComponentFactory.buildDirectValueColumnAdapter(directContainerMappingHolder));
    }

    private static PropertyValueModel buildDirectValueColumnAdapter(ValueModel directContainerMappingHolder) {
        return new PropertyAspectAdapter(directContainerMappingHolder, "directValueColumn"){

            protected Object getValueFromSubject() {
                return ((MWRelationalDirectContainerMapping)this.subject).getDirectValueColumn();
            }

            protected void setValueOnSubject(Object value) {
                ((MWRelationalDirectContainerMapping)this.subject).setDirectValueColumn((MWColumn)value);
            }
        };
    }

    private static ListValueModel buildDirectValueColumnListHolder(ValueModel directContainerMappingHolder) {
        return new ExtendedListValueModelWrapper(new SortedListValueModelAdapter(RelationalMappingComponentFactory.buildDirectValueColumnCollectionHolder(directContainerMappingHolder)));
    }

    private static CollectionValueModel buildDirectValueColumnCollectionHolder(ValueModel directContainerMappingHolder) {
        return new CollectionAspectAdapter(RelationalMappingComponentFactory.buildTargetTableHolder(directContainerMappingHolder), "columns"){

            protected Iterator getValueFromSubject() {
                return ((MWTable)this.subject).columns();
            }

            public int size() {
                return ((MWTable)this.subject).columnsSize();
            }
        };
    }

    static ListChooser buildDirectKeyColumnChooser(ValueModel directContainerMappingHolder, WorkbenchContextHolder contextHolder) {
        DefaultListChooser listChooser = new DefaultListChooser(RelationalMappingComponentFactory.buildDirectKeyColumnComboModel(directContainerMappingHolder), contextHolder, RelationalMappingComponentFactory.buildColumnNodeSelector(contextHolder), RelationalMappingComponentFactory.buildDirectKeyColumnChooserDialogBuilder());
        listChooser.setRenderer(RelationalMappingComponentFactory.buildColumnListRenderer(RelationalMappingComponentFactory.buildParentDescriptorHolder(directContainerMappingHolder), contextHolder.getWorkbenchContext().getApplicationContext().getResourceRepository()));
        return listChooser;
    }

    private static DefaultListChooserDialog.Builder buildDirectKeyColumnChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("DIRECT_KEY_FIELD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("DIRECT_KEY_FIELD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(RelationalMappingComponentFactory.buildColumnStringConverter());
        return builder;
    }

    private static ComboBoxModel buildDirectKeyColumnComboModel(ValueModel directContainerMappingHolder) {
        return new ComboBoxModelAdapter(RelationalMappingComponentFactory.buildDirectValueColumnListHolder(directContainerMappingHolder), RelationalMappingComponentFactory.buildDirectKeyColumnAdapter(directContainerMappingHolder));
    }

    private static PropertyValueModel buildDirectKeyColumnAdapter(ValueModel directContainerMappingHolder) {
        return new PropertyAspectAdapter(directContainerMappingHolder, "directKeyColumn"){

            protected Object getValueFromSubject() {
                return ((MWRelationalDirectMapMapping)this.subject).getDirectKeyColumn();
            }

            protected void setValueOnSubject(Object value) {
                ((MWRelationalDirectMapMapping)this.subject).setDirectKeyColumn((MWColumn)value);
            }
        };
    }
}

