/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWColumnQueryKeyPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWVariableOneToOneMapping;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ColumnCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.RelationalMappingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.ComboBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.utility.Model;

final class VariableOneToOneQueryKeyAssociationsPanel
extends ScrollablePropertiesPage {
    private PropertyValueModel selectedFieldAssociationHolder;
    private ValueModel parentDescriptorHolder;
    private CollectionValueModel fieldQueryKeyAssociationsAdapter;
    private ObjectListSelectionModel rowSelectionModel;
    private ListValueModel queryKeyNamesHolder;
    private Action removeAction;

    VariableOneToOneQueryKeyAssociationsPanel(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
    }

    protected void initialize(PropertyValueModel nodeHolder) {
        super.initialize(nodeHolder);
        this.parentDescriptorHolder = this.buildParentDescriptorHolder();
        this.queryKeyNamesHolder = this.buildSortedQueryKeyNamesHolder();
        this.fieldQueryKeyAssociationsAdapter = this.buildFieldQueryKeyAssociationsAdapter();
        this.selectedFieldAssociationHolder = new SimplePropertyValueModel(null);
        this.rowSelectionModel = this.buildRowSelectionModel();
    }

    private PropertyValueModel buildParentDescriptorHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWVariableOneToOneMapping)this.subject).getParentDescriptor();
            }
        };
    }

    private ListValueModel buildSortedQueryKeyNamesHolder() {
        return new SortedListValueModelAdapter(this.buildQueryKeyNamesHolder());
    }

    private CollectionValueModel buildQueryKeyNamesHolder() {
        return new CollectionAspectAdapter(this.buildReferenceDescriptorHolder()){

            protected Iterator getValueFromSubject() {
                return ((MWRelationalDescriptor)this.subject).allQueryKeyNames();
            }
        };
    }

    private PropertyValueModel buildReferenceDescriptorHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "referenceDescriptor"){

            protected Object getValueFromSubject() {
                return ((MWVariableOneToOneMapping)this.subject).getReferenceDescriptor();
            }
        };
    }

    private CollectionValueModel buildFieldQueryKeyAssociationsAdapter() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), "columnQueryKeyPairs"){

            protected Iterator getValueFromSubject() {
                return ((MWVariableOneToOneMapping)this.subject).columnQueryKeyPairs();
            }

            protected int sizeFromSubject() {
                return ((MWVariableOneToOneMapping)this.subject).columnQueryKeyPairsSize();
            }
        };
    }

    private ObjectListSelectionModel buildRowSelectionModel() {
        ObjectListSelectionModel rowSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(this.fieldQueryKeyAssociationsAdapter));
        rowSelectionModel.addListSelectionListener(this.buildRowSelectionListener());
        rowSelectionModel.setSelectionMode(0);
        return rowSelectionModel;
    }

    private ListSelectionListener buildRowSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    VariableOneToOneQueryKeyAssociationsPanel.this.rowSelectionChanged();
                }
            }
        };
    }

    private void rowSelectionChanged() {
        Object selection = this.rowSelectionModel.getSelectedValue();
        this.selectedFieldAssociationHolder.setValue(selection);
        boolean associationSelected = selection != null;
        this.removeAction.setEnabled(associationSelected);
    }

    protected Component buildPage() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel buttonPanel = this.buildButtonPanel();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)buttonPanel, constraints);
        JTable table = this.buildTable();
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.getViewport().setPreferredSize(new Dimension(50, 50));
        scrollPane.getViewport().setBackground(table.getBackground());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 5, 0);
        panel.add((Component)scrollPane, constraints);
        this.addHelpTopicId(panel, this.helpTopicId());
        return panel;
    }

    private JTable buildTable() {
        JTable table = SwingComponentFactory.buildTable(this.buildTableModel(), this.rowSelectionModel);
        int rowHeight = 20;
        TableColumn fieldColumn = table.getColumnModel().getColumn(0);
        ComboBoxTableCellRenderer sourceFieldRenderer = this.buildFieldComboBoxRenderer();
        fieldColumn.setCellRenderer(sourceFieldRenderer);
        fieldColumn.setCellEditor(new TableCellEditorAdapter(this.buildFieldComboBoxRenderer()));
        rowHeight = Math.max(rowHeight, sourceFieldRenderer.getPreferredHeight());
        TableColumn queryKeyNameColumn = table.getColumnModel().getColumn(1);
        ComboBoxTableCellRenderer queryKeyNameRenderer = this.buildQueryKeyNameComboBoxRenderer();
        queryKeyNameColumn.setCellRenderer(queryKeyNameRenderer);
        queryKeyNameColumn.setCellEditor(new TableCellEditorAdapter(this.buildQueryKeyNameComboBoxRenderer()));
        rowHeight = Math.max(rowHeight, queryKeyNameRenderer.getPreferredHeight());
        table.setRowHeight(rowHeight);
        return table;
    }

    private TableModel buildTableModel() {
        return new TableModelAdapter(this.buildFieldQueryKeyAssociationsAdapter(), this.buildColumnAdapter());
    }

    private ColumnAdapter buildColumnAdapter() {
        return new FieldAssociationsColumnAdapter(this.getSelectionHolder(), this.resourceRepository());
    }

    private ListCellRenderer buildDatabaseFieldListCellRenderer() {
        return new AdaptableListCellRenderer(new ColumnCellRendererAdapter(this.resourceRepository()));
    }

    private ComboBoxTableCellRenderer buildFieldComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildFieldComboBoxModel(), this.buildDatabaseFieldListCellRenderer());
    }

    private ComboBoxModel buildFieldComboBoxModel() {
        return RelationalMappingComponentFactory.buildExtendedColumnComboBoxModel(new SimplePropertyValueModel(), this.parentDescriptorHolder);
    }

    private ComboBoxTableCellRenderer buildQueryKeyNameComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildQueryKeyNameComboBoxModel());
    }

    private ComboBoxModel buildQueryKeyNameComboBoxModel() {
        return new ComboBoxModelAdapter(this.queryKeyNamesHolder, (PropertyValueModel)new SimplePropertyValueModel());
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        buttonPanel.add(this.buildAddButton());
        buttonPanel.add(this.buildRemoveButton());
        return buttonPanel;
    }

    private JButton buildAddButton() {
        return new JButton(this.buildAddAction());
    }

    private Action buildAddAction() {
        AbstractFrameworkAction action = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.initializeText("ADD_ASSOCIATION_BUTTON_TEXT");
                this.initializeMnemonic("ADD_ASSOCIATION_BUTTON_TEXT");
            }

            public void actionPerformed(ActionEvent event) {
                VariableOneToOneQueryKeyAssociationsPanel.this.addFieldQueryKeyNameAssociation();
            }
        };
        return action;
    }

    private void addFieldQueryKeyNameAssociation() {
        MWColumn field = null;
        MWRelationalClassDescriptor descriptor = (MWRelationalClassDescriptor)this.getParentDescriptor();
        if (!descriptor.isAggregateDescriptor() && descriptor.allAssociatedColumns().hasNext()) {
            field = (MWColumn)descriptor.allAssociatedColumns().next();
        }
        String queryKeyName = "";
        if (this.queryKeyNamesHolder.size() > 0) {
            queryKeyName = (String)this.queryKeyNamesHolder.getItem(0);
        }
        this.getVariableOneToOneMapping().addColumnQueryKeyPair(field, queryKeyName);
    }

    private MWVariableOneToOneMapping getVariableOneToOneMapping() {
        return (MWVariableOneToOneMapping)this.selection();
    }

    private JButton buildRemoveButton() {
        return new JButton(this.buildRemoveAction());
    }

    private Action buildRemoveAction() {
        this.removeAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.initializeTextAndMnemonic("REMOVE_ASSOCIATION_BUTTON_TEXT");
            }

            public void actionPerformed(ActionEvent event) {
                VariableOneToOneQueryKeyAssociationsPanel.this.removeFieldQueryKeyNameAssociation();
            }
        };
        this.removeAction.setEnabled(false);
        return this.removeAction;
    }

    private void removeFieldQueryKeyNameAssociation() {
        MWColumnQueryKeyPair association;
        int option = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("REMOVE_FIELD_ASSOCIATIONS_WARNING_DIALOG.message"), this.resourceRepository().getString("REMOVE_FIELD_ASSOCIATIONS_WARNING_DIALOG.title"), 0, 3);
        if (option == 0 && (association = this.selectedAssociation()) != null) {
            this.getVariableOneToOneMapping().removeColumnQueryKeyPair(association);
        }
    }

    private MWColumnQueryKeyPair selectedAssociation() {
        if (this.rowSelectionModel.isSelectionEmpty()) {
            return null;
        }
        return (MWColumnQueryKeyPair)this.rowSelectionModel.getSelectedValue();
    }

    protected String helpTopicId() {
        return "mapping.variableOneToOne.queryKeyAssociations";
    }

    private MWRelationalDescriptor getParentDescriptor() {
        return (MWRelationalDescriptor)((MWVariableOneToOneMapping)this.selection()).getParentDescriptor();
    }

    public static class FieldAssociationsColumnAdapter
    implements ColumnAdapter {
        private PropertyValueModel selectionHolder;
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 2;
        public static final int FIELD_COLUMN = 0;
        public static final int QUERY_KEY_NAME_COLUMN = 1;
        private final String[] COLUMN_NAME_KEYS = new String[]{"FIELD_COLUMN_HEADER", "QUERY_KEY_NAME_COLUMN_HEADER"};

        protected FieldAssociationsColumnAdapter(PropertyValueModel selectionHolder, ResourceRepository resourceRepository) {
            this.selectionHolder = selectionHolder;
            this.resourceRepository = resourceRepository;
        }

        private MWVariableOneToOneMapping mapping() {
            return (MWVariableOneToOneMapping)this.selectionHolder.getValue();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int index) {
            return this.resourceRepository.getString(this.COLUMN_NAME_KEYS[index]);
        }

        public Class getColumnClass(int index) {
            switch (index) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        public boolean isColumnEditable(int index) {
            return index != 0 || !this.mapping().parentDescriptorIsAggregate();
        }

        public PropertyValueModel[] cellModels(Object subject) {
            MWColumnQueryKeyPair association = (MWColumnQueryKeyPair)subject;
            PropertyValueModel[] result = new PropertyValueModel[]{this.buildFieldAdapter(association), this.buildTargetFieldAdapter(association)};
            return result;
        }

        private PropertyValueModel buildFieldAdapter(MWColumnQueryKeyPair association) {
            PropertyAspectAdapter adapter = new PropertyAspectAdapter("column", (Model)association){

                protected Object getValueFromSubject() {
                    return ((MWColumnQueryKeyPair)this.subject).getColumn();
                }

                protected void setValueOnSubject(Object value) {
                    ((MWColumnQueryKeyPair)this.subject).setColumn((MWColumn)value);
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)adapter, "name");
        }

        private PropertyValueModel buildTargetFieldAdapter(MWColumnQueryKeyPair association) {
            return new PropertyAspectAdapter("queryKeyName", (Model)association){

                protected Object getValueFromSubject() {
                    return ((MWColumnQueryKeyPair)this.subject).getQueryKeyName();
                }

                protected void setValueOnSubject(Object value) {
                    ((MWColumnQueryKeyPair)this.subject).setQueryKeyName((String)value);
                }
            };
        }
    }
}

