/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledBorder;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ClassAttributeCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.MethodCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

public class AccessorEditingPanel
extends AbstractPanel {
    private AccessorSpec accessorSpec;

    public AccessorEditingPanel(AccessorSpec accessorSpec, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.accessorSpec = accessorSpec;
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints constraints = new GridBagConstraints();
        JRadioButton methodsButton = this.buildMethodsButton();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)methodsButton, constraints);
        JPanel methodsChooserPanel = this.buildMethodsChooserPanel();
        methodsChooserPanel.setBorder(new AccessibleTitledBorder(methodsButton.getText()));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, SwingTools.checkBoxIconWidth(), 0, 0);
        this.add((Component)methodsChooserPanel, constraints);
        JRadioButton attributeButton = this.buildAttributeButton();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)attributeButton, constraints);
        JPanel attributeChooser = this.buildAttributeChooserPanel();
        attributeChooser.setBorder(new AccessibleTitledBorder(attributeButton.getText()));
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, SwingTools.checkBoxIconWidth(), 0, 0);
        this.add((Component)attributeChooser, constraints);
    }

    private JRadioButton buildMethodsButton() {
        JRadioButton button = new JRadioButton();
        button.setModel(this.buildMethodsButtonModel());
        button.setText(this.resourceRepository().getString("ACCESSOR_PANEL_METHODS_BUTTON"));
        button.setMnemonic(this.resourceRepository().getMnemonic("ACCESSOR_PANEL_METHODS_BUTTON"));
        return button;
    }

    private JRadioButton buildAttributeButton() {
        JRadioButton button = new JRadioButton();
        button.setModel(this.buildAttributeButtonModel());
        button.setText(this.resourceRepository().getString("ACCESSOR_PANEL_ATTRIBUTE_BUTTON"));
        button.setMnemonic(this.resourceRepository().getMnemonic("ACCESSOR_PANEL_ATTRIBUTE_BUTTON"));
        return button;
    }

    private ButtonModel buildAttributeButtonModel() {
        return new RadioButtonModelAdapter(this.accessorSpec.accessorTypeHolder(), "accessorAttribute");
    }

    private ButtonModel buildMethodsButtonModel() {
        return new RadioButtonModelAdapter(this.accessorSpec.accessorTypeHolder(), "accessorMethods");
    }

    private JPanel buildMethodsChooserPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        JLabel getMethodLabel = this.buildGetMethodChooserLabel();
        panel.add(getMethodLabel);
        this.addAlignLeft(getMethodLabel);
        ListChooser getMethodChooser = this.buildGetMethodChooser();
        getMethodLabel.setLabelFor(getMethodChooser);
        panel.add(getMethodChooser);
        panel.add(Box.createRigidArea(new Dimension(10, 0)));
        JLabel setMethodsLabel = this.buildSetMethodChooserLabel();
        panel.add(setMethodsLabel);
        this.addAlignLeft(setMethodsLabel);
        ListChooser setMethodChooser = this.buildSetMethodChooser();
        setMethodsLabel.setLabelFor(setMethodChooser);
        panel.add(setMethodChooser);
        return panel;
    }

    private JLabel buildGetMethodChooserLabel() {
        JLabel label = this.buildLabel("ACCESSOR_PANEL_GET_METHOD_CHOOSER");
        this.accessorSpec.accessorTypeHolder().addPropertyChangeListener("value", this.buildComponentEnablingListener(label, "accessorMethods"));
        label.setEnabled(this.accessorSpec.accessorTypeHolder().getValue() == "accessorMethods");
        return label;
    }

    private ListChooser buildGetMethodChooser() {
        DefaultListChooser chooser = new DefaultListChooser(this.buildGetMethodChooserModel(), this.getWorkbenchContextHolder(), this.buildMethodChooserDialogBuilder());
        chooser.setRenderer(this.buildMethodRenderer());
        this.accessorSpec.accessorTypeHolder().addPropertyChangeListener("value", this.buildComponentEnablingListener(chooser, "accessorMethods"));
        chooser.setEnabled(this.accessorSpec.accessorTypeHolder().getValue() == "accessorMethods");
        return chooser;
    }

    private ComboBoxModel buildGetMethodChooserModel() {
        return new ComboBoxModelAdapter(this.buildMethodChoicesValue(), this.accessorSpec.accessorGetMethodHolder());
    }

    private ListValueModel buildMethodChoicesValue() {
        return new SortedListValueModelAdapter(new ReadOnlyCollectionValueModel(CollectionTools.collection((Iterator)this.accessorSpec.candidateAccessorMethods())));
    }

    private DefaultListChooserDialog.Builder buildMethodChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setStringConverter(this.buildMWMethodStringConverter());
        return builder;
    }

    private StringConverter buildMWMethodStringConverter() {
        return new StringConverter(){

            public String convertToString(Object o) {
                return o == null ? "" : ((MWMethod)o).shortSignatureWithReturnType();
            }
        };
    }

    private ListCellRenderer buildMethodRenderer() {
        return new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository()){

            protected Icon buildNonNullValueIcon(Object value) {
                return null;
            }
        });
    }

    private JLabel buildSetMethodChooserLabel() {
        JLabel label = this.buildLabel("ACCESSOR_PANEL_SET_METHOD_CHOOSER");
        this.accessorSpec.accessorTypeHolder().addPropertyChangeListener("value", this.buildComponentEnablingListener(label, "accessorMethods"));
        label.setEnabled(this.accessorSpec.accessorTypeHolder().getValue() == "accessorMethods");
        return label;
    }

    private ListChooser buildSetMethodChooser() {
        DefaultListChooser chooser = new DefaultListChooser(this.buildSetMethodChooserModel(), this.getWorkbenchContextHolder(), this.buildMethodChooserDialogBuilder());
        chooser.setRenderer(this.buildMethodRenderer());
        this.accessorSpec.accessorTypeHolder().addPropertyChangeListener("value", this.buildComponentEnablingListener(chooser, "accessorMethods"));
        chooser.setEnabled(this.accessorSpec.accessorTypeHolder().getValue() == "accessorMethods");
        return chooser;
    }

    private ComboBoxModel buildSetMethodChooserModel() {
        return new ComboBoxModelAdapter(this.buildMethodChoicesValue(), this.accessorSpec.accessorSetMethodHolder());
    }

    private PropertyChangeListener buildComponentEnablingListener(final Component component, final String enabledValue) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                component.setEnabled(evt.getNewValue() == enabledValue);
            }
        };
    }

    private JPanel buildAttributeChooserPanel() {
        AccessibleTitledPanel panel = new AccessibleTitledPanel(new BorderLayout(5, 0));
        JLabel label = this.buildAttributeChooserLabel();
        panel.add((Component)label, "Before");
        this.addAlignLeft(label);
        ListChooser chooser = this.buildAttributeChooser();
        label.setLabelFor(chooser);
        panel.add((Component)chooser, "Center");
        return panel;
    }

    private JLabel buildAttributeChooserLabel() {
        JLabel label = new JLabel(this.resourceRepository().getString("ACCESSOR_PANEL_ATTRIBUTE_CHOOSER"));
        label.setDisplayedMnemonic(this.resourceRepository().getMnemonic("ACCESSOR_PANEL_ATTRIBUTE_CHOOSER"));
        this.accessorSpec.accessorTypeHolder().addPropertyChangeListener("value", this.buildComponentEnablingListener(label, "accessorAttribute"));
        label.setEnabled(this.accessorSpec.accessorTypeHolder().getValue() == "accessorAttribute");
        return label;
    }

    private ListChooser buildAttributeChooser() {
        DefaultListChooser chooser = new DefaultListChooser(this.buildAttributeChooserModel(), this.getWorkbenchContextHolder(), this.buildAttributeChooserDialogBuilder());
        chooser.setRenderer(this.buildAttributeRenderer());
        this.accessorSpec.accessorTypeHolder().addPropertyChangeListener("value", this.buildComponentEnablingListener(chooser, "accessorAttribute"));
        chooser.setEnabled(this.accessorSpec.accessorTypeHolder().getValue() == "accessorAttribute");
        return chooser;
    }

    private ComboBoxModel buildAttributeChooserModel() {
        return new ComboBoxModelAdapter(this.buildAttributeChoicesValue(), this.accessorSpec.accessorAttributeHolder());
    }

    private ListValueModel buildAttributeChoicesValue() {
        return new SortedListValueModelAdapter(new ReadOnlyCollectionValueModel(CollectionTools.collection((Iterator)this.accessorSpec.candidateAccessorAttributes())));
    }

    private DefaultListChooserDialog.Builder buildAttributeChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setStringConverter(this.buildMWClassAttributeStringConverter());
        return builder;
    }

    private StringConverter buildMWClassAttributeStringConverter() {
        return new StringConverter(){

            public String convertToString(Object o) {
                return o == null ? "" : ((MWClassAttribute)o).getName();
            }
        };
    }

    private ListCellRenderer buildAttributeRenderer() {
        return new AdaptableListCellRenderer(new ClassAttributeCellRendererAdapter(this.resourceRepository()){

            protected Icon buildNonNullValueIcon(Object value) {
                return null;
            }
        });
    }

    public static interface AccessorSpec {
        public static final String ACCESSOR_METHODS = "accessorMethods";
        public static final String ACCESSOR_ATTRIBUTE = "accessorAttribute";
        public static final String NULL_ACCESSOR = "nullAccessor";

        public PropertyValueModel accessorTypeHolder();

        public String accessorType();

        public PropertyValueModel accessorGetMethodHolder();

        public MWMethod accessorGetMethod();

        public PropertyValueModel accessorSetMethodHolder();

        public MWMethod accessorSetMethod();

        public Iterator candidateAccessorMethods();

        public Iterator candidateAccessorAttributes();

        public PropertyValueModel accessorAttributeHolder();

        public MWClassAttribute accessorAttribute();
    }
}

