/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlFieldPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.XmlReferenceMappingFieldPairEditingDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTableCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;

final class XmlReferenceMappingFieldPairsPanel
extends AbstractSubjectPanel {
    private ObjectListSelectionModel fieldPairsSelectionModel;

    XmlReferenceMappingFieldPairsPanel(ValueModel subjectHolder, WorkbenchContextHolder context) {
        super(subjectHolder, context);
        this.addHelpTopicId(this, "mapping.eis.fieldPairs");
    }

    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        JComponent tablePanel = this.buildFieldPairsTablePanel();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)tablePanel, constraints);
        JPanel buttonPanel = this.buildButtonPanel();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)buttonPanel, constraints);
    }

    private JComponent buildFieldPairsTablePanel() {
        JTable table = this.buildFieldPairsTable();
        JScrollPane scrollPane = new JScrollPane(table, 20, 31);
        scrollPane.getViewport().setBackground(table.getBackground());
        scrollPane.getViewport().setMinimumSize(new Dimension(10, 10));
        scrollPane.getViewport().setPreferredSize(new Dimension(10, 10));
        return scrollPane;
    }

    private JTable buildFieldPairsTable() {
        ListValueModel listValue = this.buildFieldPairsValue();
        TableModel tableModel = this.buildFieldPairsTableModel(listValue);
        this.fieldPairsSelectionModel = this.buildFieldPairSelectionModel(listValue);
        JTable table = SwingComponentFactory.buildTable(tableModel, this.fieldPairsSelectionModel);
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setCellRenderer(this.buildXpathColumnCellRenderer());
        column = table.getColumnModel().getColumn(1);
        column.setCellRenderer(this.buildXpathColumnCellRenderer());
        this.addPropertyChangeListener("enabled", this.buildTableEnabler(table));
        return table;
    }

    private ListValueModel buildFieldPairsValue() {
        return new ListAspectAdapter(this.getSubjectHolder(), "xmlFieldPairs"){

            public Object getItem(int index) {
                return ((MWXmlReferenceMapping)this.subject).xmlFieldPairAt(index);
            }

            protected ListIterator getValueFromSubject() {
                return ((MWXmlReferenceMapping)this.subject).xmlFieldPairs();
            }
        };
    }

    private TableModel buildFieldPairsTableModel(ListValueModel fieldPairsValue) {
        return new TableModelAdapter(fieldPairsValue, this.buildFieldPairsTableColumnAdapter());
    }

    private ColumnAdapter buildFieldPairsTableColumnAdapter() {
        return new FieldPairsTableColumnAdapter(this.resourceRepository());
    }

    private ObjectListSelectionModel buildFieldPairSelectionModel(ListValueModel fieldPairsValue) {
        ObjectListSelectionModel selectionModel = new ObjectListSelectionModel(new ListModelAdapter(fieldPairsValue));
        selectionModel.setSelectionMode(2);
        return selectionModel;
    }

    private TableCellRenderer buildXpathColumnCellRenderer() {
        return new SimpleTableCellRenderer(){

            protected String buildText(Object value) {
                if ("".equals(value)) {
                    return XmlReferenceMappingFieldPairsPanel.this.resourceRepository().getString("NONE_SELECTED");
                }
                return (String)value;
            }
        };
    }

    private PropertyChangeListener buildTableEnabler(final JTable table) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                table.setEnabled((Boolean)evt.getNewValue());
            }
        };
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(3, 1, 0, 5));
        JButton addButton = this.buildAddFieldPairButton();
        buttonPanel.add(addButton);
        this.addAlignRight(addButton);
        JButton editButton = this.buildEditFieldPairButton();
        buttonPanel.add(editButton);
        this.addAlignRight(editButton);
        JButton removeButton = this.buildRemoveFieldPairsButton();
        buttonPanel.add(removeButton);
        this.addAlignRight(removeButton);
        return buttonPanel;
    }

    private JButton buildAddFieldPairButton() {
        JButton addButton = this.buildButton("FIELD_PAIR_ADD_BUTTON");
        addButton.addActionListener(this.buildAddFieldPairAction());
        this.addPropertyChangeListener("enabled", this.buildAddButtonEnabler(addButton));
        return addButton;
    }

    private ActionListener buildAddFieldPairAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MWXmlReferenceMapping eisReferenceMapping = (MWXmlReferenceMapping)XmlReferenceMappingFieldPairsPanel.this.getSubjectHolder().getValue();
                WorkbenchContext context = XmlReferenceMappingFieldPairsPanel.this.getWorkbenchContext();
                XmlReferenceMappingFieldPairEditingDialog.promptToAddFieldPair(eisReferenceMapping, context);
            }
        };
    }

    private PropertyChangeListener buildAddButtonEnabler(final JButton button) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                button.setEnabled((Boolean)evt.getNewValue());
            }
        };
    }

    private JButton buildEditFieldPairButton() {
        JButton editButton = this.buildButton("FIELD_PAIR_EDIT_BUTTON");
        editButton.addActionListener(this.buildEditActionListener());
        editButton.setEnabled(false);
        this.buildEditFieldPairButtonEnabler(editButton);
        return editButton;
    }

    private ActionListener buildEditActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MWXmlFieldPair fieldPair = (MWXmlFieldPair)XmlReferenceMappingFieldPairsPanel.this.fieldPairsSelectionModel.getSelectedValue();
                WorkbenchContext context = XmlReferenceMappingFieldPairsPanel.this.getWorkbenchContext();
                XmlReferenceMappingFieldPairEditingDialog.promptToEditFieldPair(fieldPair, context);
            }
        };
    }

    private void buildEditFieldPairButtonEnabler(final JButton editButton) {
        this.fieldPairsSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    editButton.setEnabled(XmlReferenceMappingFieldPairsPanel.this.fieldPairsSelectionModel.getSelectedValues().length == 1);
                }
            }
        });
    }

    private JButton buildRemoveFieldPairsButton() {
        JButton removeButton = this.buildButton("FIELD_PAIR_REMOVE_BUTTON");
        removeButton.addActionListener(this.buildRemoveFieldPairsActionListener());
        removeButton.setEnabled(false);
        this.buildRemoveFieldPairsButtonEnabler(removeButton);
        return removeButton;
    }

    private ActionListener buildRemoveFieldPairsActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XmlReferenceMappingFieldPairsPanel.this.removeSelectedFieldPairs();
            }
        };
    }

    private void removeSelectedFieldPairs() {
        Iterator stream = CollectionTools.iterator((Object[])this.fieldPairsSelectionModel.getSelectedValues());
        while (stream.hasNext()) {
            ((MWXmlReferenceMapping)this.subject()).removeXmlFieldPair((MWXmlFieldPair)stream.next());
        }
    }

    private void buildRemoveFieldPairsButtonEnabler(final JButton removeButton) {
        this.fieldPairsSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    removeButton.setEnabled(!XmlReferenceMappingFieldPairsPanel.this.fieldPairsSelectionModel.isSelectionEmpty());
                }
            }
        });
    }

    private static class FieldPairsTableColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 2;
        public static final int SOURCE_XPATH_COLUMN = 0;
        public static final int TARGET_XPATH_COLUMN = 1;

        public int getColumnCount() {
            return 2;
        }

        FieldPairsTableColumnAdapter(ResourceRepository resourceRepository) {
            this.resourceRepository = resourceRepository;
        }

        public String getColumnName(int index) {
            switch (index) {
                case 0: {
                    return this.resourceRepository.getString("FIELD_PAIR_SOURCE_FIELD_COLUMN");
                }
                case 1: {
                    return this.resourceRepository.getString("FIELD_PAIR_TARGET_FIELD_COLUMN");
                }
            }
            return "";
        }

        public Class getColumnClass(int index) {
            return String.class;
        }

        public boolean isColumnEditable(int index) {
            return false;
        }

        public PropertyValueModel[] cellModels(Object subject) {
            MWXmlFieldPair fieldPair = (MWXmlFieldPair)subject;
            PropertyValueModel[] result = new PropertyValueModel[]{this.buildXpathAdapter(fieldPair.getSourceXmlField()), this.buildXpathAdapter(fieldPair.getTargetXmlField())};
            return result;
        }

        private PropertyValueModel buildXpathAdapter(MWXmlField xmlField) {
            return new PropertyAspectAdapter("xpath", (Model)xmlField){

                protected Object getValueFromSubject() {
                    return ((MWXmlField)this.subject).getXpath();
                }
            };
        }
    }
}

