/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.CheckList;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.FieldAccessingPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

class ProjectDefaultsPropertiesPage
extends ScrollablePropertiesPage {
    private ObjectListSelectionModel advancedPoliciesSelectionModel;
    private List policyHolders;

    ProjectDefaultsPropertiesPage(PropertyValueModel projectNodeHolder, WorkbenchContextHolder contextHolder) {
        super(projectNodeHolder, contextHolder);
    }

    private Comparator buildAdvancedPolicyComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return Collator.getInstance().compare(((UIAdvancedPolicyHolder)o1).displayString(), ((UIAdvancedPolicyHolder)o2).displayString());
            }
        };
    }

    private Component buildAdvancedPolicyDefaultsPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel advancedPolicyDefaultsPanel = new JPanel(new GridBagLayout());
        advancedPolicyDefaultsPanel.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("PROJECT_DEFAULTS_POLICY_DESCRIPTOR_ADVANCED_PROPERTIES"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        advancedPolicyDefaultsPanel.add(this.buildAdvancedPropertiesDefaultsChooser(), constraints);
        this.addHelpTopicId(advancedPolicyDefaultsPanel, this.helpTopicId() + ".descriptorAdvancedProperties");
        return advancedPolicyDefaultsPanel;
    }

    private CellRendererAdapter buildAdvancedPropertiesCellRenderer() {
        return new AbstractCellRendererAdapter(){

            public String buildText(Object value) {
                return ((UIAdvancedPolicyHolder)value).displayString();
            }
        };
    }

    private ListValueModel buildAdvancedPropertiesCollectionModel(List allValues) {
        return new SortedListValueModelAdapter(new ReadOnlyListValueModel(allValues), this.buildAdvancedPolicyComparator());
    }

    protected Component buildAdvancedPropertiesDefaultsChooser() {
        this.policyHolders = this.buildAdvancedPropertyHolders();
        ListValueModel advancedPropertiesCVM = this.buildAdvancedPropertiesCollectionModel(this.policyHolders);
        this.advancedPoliciesSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(advancedPropertiesCVM));
        CheckList checkList = new CheckList(advancedPropertiesCVM, (ListSelectionModel)this.advancedPoliciesSelectionModel, this.buildAdvancedPropertiesCellRenderer());
        JPanel advancedPropertiesPanel = new JPanel(new BorderLayout());
        advancedPropertiesPanel.setBorder(this.buildStandardEmptyBorder());
        advancedPropertiesPanel.add(checkList);
        this.getSelectionHolder().addPropertyChangeListener("value", new ProjectValueChangeListener());
        this.advancedPoliciesSelectionModel.addListSelectionListener(new AdvancedPolicyDataListener(this.policyHolders, this.advancedPoliciesSelectionModel));
        if (this.selection() != null) {
            this.advancedPoliciesSelectionModel.setSelectedValues(this.holderIterator(((MWProject)this.selection()).getDefaultsPolicy().defaultPolicies()));
        }
        return advancedPropertiesPanel;
    }

    protected List buildAdvancedPropertyHolders() {
        ArrayList<UIAdvancedPolicyHolder> propertyHolders = new ArrayList<UIAdvancedPolicyHolder>();
        propertyHolders.add(new UIAdvancedPolicyHolder("After Load", "PROJECT_DEFAULTS_POLICY_AFTER_LOADING_POLICY"));
        propertyHolders.add(new UIAdvancedPolicyHolder("Copy Policy", "PROJECT_DEFAULTS_POLICY_COPYING_POLICY"));
        propertyHolders.add(new UIAdvancedPolicyHolder("Inheritance", "PROJECT_DEFAULTS_POLICY_INHERITANCE_POLICY"));
        propertyHolders.add(new UIAdvancedPolicyHolder("Instantiation", "PROJECT_DEFAULTS_POLICY_INSTANTIATION_POLICY"));
        return propertyHolders;
    }

    protected Component buildCachingDefaultsPanel() {
        return new JPanel();
    }

    private Component buildCreationDefaultsPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel creationDefaultsPanel = new JPanel(new GridBagLayout());
        creationDefaultsPanel.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("PROJECT_DEFAULTS_POLICY_CREATION"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        creationDefaultsPanel.add(this.buildAdvancedPolicyDefaultsPanel(), constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        creationDefaultsPanel.add(this.buildFieldAccessingPanel(), constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        creationDefaultsPanel.add((Component)this.buildNamedQueriesPanel(), constraints);
        return creationDefaultsPanel;
    }

    private Component buildFieldAccessingPanel() {
        FieldAccessingPanel fieldAccessingPanel = new FieldAccessingPanel((ValueModel)this.getSelectionHolder(), this.getApplicationContext());
        this.addHelpTopicId(fieldAccessingPanel, this.helpTopicId() + ".fieldAccessing");
        return fieldAccessingPanel;
    }

    protected JPanel buildNamedQueriesPanel() {
        return new JPanel();
    }

    protected Component buildPage() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add(this.buildCreationDefaultsPanel(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add(this.buildCachingDefaultsPanel(), constraints);
        this.addHelpTopicId(panel, this.helpTopicId());
        return panel;
    }

    protected PropertyValueModel buildSelectionHolder() {
        return new TransformationPropertyValueModel(super.buildSelectionHolder()){

            protected Object transform(Object value) {
                if (value == null) {
                    return null;
                }
                return ((MWProject)value).getDefaultsPolicy();
            }
        };
    }

    private UIAdvancedPolicyHolder getPolicyHolderFor(String policyId) {
        for (UIAdvancedPolicyHolder holder : this.policyHolders) {
            if (!holder.isOfType(policyId)) continue;
            return holder;
        }
        return null;
    }

    protected String helpTopicId() {
        return "project.defaults";
    }

    private Iterator holderIterator(Iterator policyIdIter) {
        return new TransformationIterator(policyIdIter){

            protected Object transform(Object next) {
                return ProjectDefaultsPropertiesPage.this.getPolicyHolderFor((String)next);
            }
        };
    }

    protected MWProjectDefaultsPolicy projectDefaults() {
        return (MWProjectDefaultsPolicy)this.selection();
    }

    public class UIAdvancedPolicyHolder {
        private String policyId;
        private String resourceKey;

        public UIAdvancedPolicyHolder(String advancedPolicyId, String resourceKey) {
            this.policyId = advancedPolicyId;
            this.resourceKey = resourceKey;
        }

        public void addPolicyDefault() {
            if (!ProjectDefaultsPropertiesPage.this.projectDefaults().containsAdvancePolicyDefault(this.policyId)) {
                ProjectDefaultsPropertiesPage.this.projectDefaults().addAdvancedPolicyDefault(this.policyId);
            }
        }

        public String displayString() {
            try {
                return ProjectDefaultsPropertiesPage.this.resourceRepository().getString(this.resourceKey);
            }
            catch (NullPointerException e) {
                return this.resourceKey;
            }
        }

        public boolean isOfType(String policyId) {
            return this.policyId == policyId;
        }

        public void removePolicyDefault() {
            if (ProjectDefaultsPropertiesPage.this.projectDefaults().containsAdvancePolicyDefault(this.policyId)) {
                ProjectDefaultsPropertiesPage.this.projectDefaults().removeAdvancedPolicyDefault(this.policyId);
            }
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    private class ProjectValueChangeListener
    implements PropertyChangeListener {
        private ProjectValueChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (ProjectDefaultsPropertiesPage.this.selection() != null) {
                MWProject project = ProjectDefaultsPropertiesPage.this.projectDefaults().getProject();
                Iterator selectedPolicies = project.getDefaultsPolicy().defaultPolicies();
                ProjectDefaultsPropertiesPage.this.advancedPoliciesSelectionModel.setSelectedValues(ProjectDefaultsPropertiesPage.this.holderIterator(selectedPolicies));
            }
        }
    }

    private class AdvancedPolicyDataListener
    implements ListSelectionListener {
        private List allPolicyHolders;
        private ObjectListSelectionModel selectionModel;

        private AdvancedPolicyDataListener(List allPolicyHolders, ObjectListSelectionModel selectionModel) {
            this.allPolicyHolders = allPolicyHolders;
            this.selectionModel = selectionModel;
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            Object[] selectedValues = this.selectionModel.getSelectedValues();
            ArrayList valuesToRemove = new ArrayList(this.allPolicyHolders);
            CollectionTools.removeAll(valuesToRemove, (Object[])selectedValues);
            for (int i = 0; i < selectedValues.length; ++i) {
                UIAdvancedPolicyHolder holder = (UIAdvancedPolicyHolder)selectedValues[i];
                holder.addPolicyDefault();
            }
            for (UIAdvancedPolicyHolder holder : valuesToRemove) {
                holder.removePolicyDefault();
            }
        }
    }
}

