/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ListIterator;
import javax.swing.tree.DefaultTreeModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBasicExpression;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWCompoundExpression;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWExpression;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.BasicExpressionTreeNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ExpressionTreeNode;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;

final class CompoundExpressionTreeNode
extends ExpressionTreeNode
implements ListChangeListener,
PropertyChangeListener {
    CompoundExpressionTreeNode(MWCompoundExpression compoundExpression) {
        this(compoundExpression, null);
    }

    CompoundExpressionTreeNode(MWCompoundExpression compoundExpression, DefaultTreeModel model) {
        super((MWExpression)compoundExpression, true, model);
    }

    MWCompoundExpression getCompoundExpression() {
        return (MWCompoundExpression)this.getUserObject();
    }

    private ExpressionTreeNode addNodeForExpression(MWExpression expression) {
        ExpressionTreeNode node = MWBasicExpression.class.isAssignableFrom(expression.getClass()) ? new BasicExpressionTreeNode((MWBasicExpression)expression, this.getModel()) : new CompoundExpressionTreeNode((MWCompoundExpression)expression, this.getModel());
        this.getModel().insertNodeInto(node, this, this.getChildCount());
        return node;
    }

    public void initializeChildren() {
        ListIterator expressions = this.getCompoundExpression().expressions();
        while (expressions.hasNext()) {
            MWExpression expression = (MWExpression)expressions.next();
            ExpressionTreeNode node = this.addNodeForExpression(expression);
            node.initializeChildren();
        }
    }

    protected void engageListeners() {
        this.getCompoundExpression().addListChangeListener((ListChangeListener)this);
        this.getCompoundExpression().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void itemsReplaced(ListChangeEvent event) {
    }

    public void itemsAdded(ListChangeEvent event) {
        ListIterator stream = event.items();
        while (stream.hasNext()) {
            this.addNodeForExpression((MWExpression)stream.next());
        }
    }

    public void itemsRemoved(ListChangeEvent event) {
        ExpressionTreeNode node = (ExpressionTreeNode)this.getChildAt(event.getIndex());
        node.disengageListeners();
        this.getModel().removeNodeFromParent(node);
    }

    public void listChanged(ListChangeEvent event) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName == "operatorType") {
            this.getModel().nodeChanged(this);
        }
    }

    protected void disengageListeners() {
        this.getCompoundExpression().removeListChangeListener((ListChangeListener)this);
        this.getCompoundExpression().removePropertyChangeListener((PropertyChangeListener)this);
        while (this.getChildCount() > 0) {
            ExpressionTreeNode node = (ExpressionTreeNode)this.getFirstChild();
            node.disengageListeners();
            this.getModel().removeNodeFromParent(node);
        }
        this.setUserObject(null);
    }
}

