/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentDetail;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentNode;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractReadOnlyPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.Model;

final class SchemaComponentDetailsPanel
extends AbstractPanel {
    private PropertyValueModel schemaComponentNodeHolder;

    SchemaComponentDetailsPanel(ApplicationContext context, PropertyValueModel schemaComponentNodeHolder) {
        super((LayoutManager)new BorderLayout(), context);
        this.initialize(schemaComponentNodeHolder);
        this.initializeLayout();
    }

    private void initialize(PropertyValueModel schemaComponentNodeHolder) {
        this.schemaComponentNodeHolder = schemaComponentNodeHolder;
    }

    private void initializeLayout() {
        JLabel detailsLabel = this.buildDetailsLabel();
        JTable detailsTable = this.buildDetailsTable();
        detailsLabel.setLabelFor(detailsTable);
        this.add((Component)detailsLabel, "First");
        this.add((Component)detailsTable, "Center");
    }

    private JLabel buildDetailsLabel() {
        JLabel label = new JLabel(this.resourceRepository().getString("DETAILS_TABLE_LABEL"));
        label.setDisplayedMnemonic(this.resourceRepository().getMnemonic("DETAILS_TABLE_LABEL"));
        Color background = label.getBackground() != null ? label.getBackground() : UIManager.getColor("Panel.background");
        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, background.darker()), BorderFactory.createEmptyBorder(2, 4, 2, 2)));
        JTableHeader header = new JTableHeader();
        label.setBackground(header.getBackground());
        label.setForeground(header.getForeground());
        label.setFont(header.getFont());
        return label;
    }

    private JTable buildDetailsTable() {
        JTable table = SwingComponentFactory.buildTable(this.buildDetailsTableModel());
        table.setBorder(BorderFactory.createEmptyBorder());
        table.setPreferredSize(new Dimension(200, 300));
        return table;
    }

    private TableModelAdapter buildDetailsTableModel() {
        return new TableModelAdapter(this.buildDetailsAdapter(), this.buildDetailsTableColumnModelAdapter());
    }

    private ListValueModel buildDetailsAdapter() {
        return new ListAspectAdapter(this.schemaComponentNodeHolder){

            protected ListIterator getValueFromSubject() {
                return ((SchemaComponentNode)this.subject).details();
            }
        };
    }

    private ColumnAdapter buildDetailsTableColumnModelAdapter() {
        return new DetailsColumnAdapter();
    }

    private static class DetailsColumnAdapter
    implements ColumnAdapter {
        private static final int COLUMN_COUNT = 2;
        private static final int DETAIL_NAME_COLUMN = 0;
        private static final int DETAIL_VALUE_COLUMN = 1;

        private DetailsColumnAdapter() {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int index) {
            return "";
        }

        public Class getColumnClass(int index) {
            return String.class;
        }

        public boolean isColumnEditable(int index) {
            return false;
        }

        public PropertyValueModel[] cellModels(Object subject) {
            SchemaComponentDetail detail = (SchemaComponentDetail)((Object)subject);
            PropertyValueModel[] cellModels = new PropertyValueModel[]{this.buildDetailNameAdapter(detail), this.buildDetailValueAdapter(detail)};
            return cellModels;
        }

        private PropertyValueModel buildDetailNameAdapter(final SchemaComponentDetail detail) {
            return new AbstractReadOnlyPropertyValueModel(){

                public Object getValue() {
                    return detail.getName();
                }
            };
        }

        private PropertyValueModel buildDetailValueAdapter(SchemaComponentDetail detail) {
            return new PropertyAspectAdapter("value", (Model)detail){

                protected Object getValueFromSubject() {
                    return ((SchemaComponentDetail)((Object)this.subject)).getValue();
                }
            };
        }
    }
}

