/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamespace;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaRootElementChooserDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaValue;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModelWrapper;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public final class SchemaRootElementChooser
extends AbstractPanel {
    private SchemaValue schemaValue;
    private PropertyValueModel rootElementHolder;
    private RootElementDisplayStringValueModel rootElementDisplayStringHolder;

    public SchemaRootElementChooser(WorkbenchContextHolder contextHolder, SchemaValue schemaValue, PropertyValueModel rootElementHolder, JLabel label) {
        super(contextHolder);
        this.initialize(schemaValue, rootElementHolder, label);
    }

    private void initialize(SchemaValue schemaValue, PropertyValueModel rootElementHolder, JLabel label) {
        this.schemaValue = schemaValue;
        this.rootElementHolder = rootElementHolder;
        this.rootElementDisplayStringHolder = this.buildRootElementDisplayStringHolder();
        this.initializeLayout(label);
    }

    private RootElementDisplayStringValueModel buildRootElementDisplayStringHolder() {
        return new RootElementDisplayStringValueModel(this.rootElementHolder);
    }

    private void initializeLayout(JLabel label) {
        GridBagConstraints constraints = new GridBagConstraints();
        JTextField textField = this.buildTextField();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)textField, constraints);
        textField.putClientProperty("labeledBy", label);
        JButton button = this.buildButton();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.addAlignRight(button);
        label.setLabelFor(button);
        SwingComponentFactory.updateButtonAccessibleName(label, button);
        this.add((Component)button, constraints);
    }

    private JTextField buildTextField() {
        JTextField textField = new JTextField(this.buildRootElementDisplayStringDocument(), null, 1);
        textField.setEditable(false);
        textField.setEnabled(true);
        return textField;
    }

    private DocumentAdapter buildRootElementDisplayStringDocument() {
        return new DocumentAdapter(this.rootElementDisplayStringHolder);
    }

    private JButton buildButton() {
        JButton button = this.buildButton("SCHEMA_ROOT_ELEMENT_CHOOSER_BROWSE_BUTTON");
        button.addActionListener(this.buildBrowseAction());
        return button;
    }

    private ActionListener buildBrowseAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SchemaRootElementChooser.this.promptToSelectRootElement();
            }
        };
    }

    private void promptToSelectRootElement() {
        SchemaRootElementChooserDialog dialog = new SchemaRootElementChooserDialog(this.getWorkbenchContext(), this.schemaValue.schema(), this.rootElementHolder);
        dialog.show();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Iterator stream = CollectionTools.iterator((Object[])this.getComponents());
        while (stream.hasNext()) {
            ((Component)stream.next()).setEnabled(enabled);
        }
    }

    private class RootElementDisplayStringValueModel
    extends PropertyValueModelWrapper {
        private String displayString;
        private PropertyChangeListener propertyChangeListener;
        private MWNamespace namespace;

        private RootElementDisplayStringValueModel(PropertyValueModel rootElementHolder) {
            super(rootElementHolder);
        }

        protected void initialize() {
            super.initialize();
            this.propertyChangeListener = this.buildPropertyChangeListener();
        }

        private PropertyChangeListener buildPropertyChangeListener() {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    RootElementDisplayStringValueModel.this.displayStringChanged();
                }
            };
        }

        private MWElementDeclaration element() {
            return (MWElementDeclaration)this.valueHolder.getValue();
        }

        private void displayStringChanged() {
            Object oldValue = this.getValue();
            this.synchronizeDisplayString();
            Object newValue = this.getValue();
            this.firePropertyChanged("value", oldValue, newValue);
        }

        private void synchronizeDisplayString() {
            this.displayString = this.element() == null ? SchemaRootElementChooser.this.resourceRepository().getString("SCHEMA_ROOT_ELEMENT_CHOOSER_NONE_SELECTED_TEXT") : this.buildDisplayString(this.element());
        }

        private String buildDisplayString(MWElementDeclaration element) {
            return element.qName();
        }

        private void engageNewElement() {
            if (this.element() != null) {
                this.namespace = this.element().getTargetNamespace();
                this.namespace.addPropertyChangeListener("namespacePrefix", this.propertyChangeListener);
            }
        }

        private void disengageOldElement() {
            if (this.namespace != null) {
                this.namespace.removePropertyChangeListener("namespacePrefix", this.propertyChangeListener);
                this.namespace = null;
            }
        }

        public Object getValue() {
            return this.displayString;
        }

        public void setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        protected void engageValueHolder() {
            super.engageValueHolder();
            this.engageNewElement();
            this.synchronizeDisplayString();
        }

        protected void disengageValueHolder() {
            this.disengageOldElement();
            super.disengageValueHolder();
            this.synchronizeDisplayString();
        }

        protected void valueChanged(PropertyChangeEvent e) {
            this.disengageOldElement();
            this.engageNewElement();
            this.displayStringChanged();
        }
    }
}

