/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform;

import java.awt.Cursor;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform.DatabasePlatformNode;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

final class AddDatabaseTypeAction
extends AbstractFrameworkAction {
    public AddDatabaseTypeAction(WorkbenchContext context) {
        super(context);
    }

    protected void initialize() {
        this.initializeTextAndMnemonic("ADD_DATABASE_TYPE");
        this.initializeIcon("ADD_DATABASE_TYPE");
        this.initializeToolTipText("ADD_DATABASE_TYPE.TOOL_TIP");
    }

    protected void execute() {
        this.currentWindow().setCursor(Cursor.getDefaultCursor());
        NewNameDialog.Builder builder = this.buildNewNameDialogBuilder();
        ApplicationNode[] nodes = this.selectedNodes();
        AbstractApplicationNode lastNode = null;
        DatabaseType lastType = null;
        int i = nodes.length;
        while (i-- > 0) {
            DatabasePlatformNode node = (DatabasePlatformNode)nodes[i];
            DatabaseType type = this.execute(node.getDatabasePlatform(), builder);
            if (type == null) continue;
            lastNode = node;
            lastType = type;
        }
        if (lastNode != null) {
            lastNode.selectDescendantNodeForValue((Node)lastType, this.navigatorSelectionModel());
        }
    }

    private NewNameDialog.Builder buildNewNameDialogBuilder() {
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setTitle(this.resourceRepository().getString("ADD_DATABASE_TYPE_DIALOG_TITLE"));
        builder.setTextFieldDescription(this.resourceRepository().getString("ADD_DATABASE_TYPE_DIALOG_DESCRIPTION"));
        builder.setHelpTopicId("dialog.dbTypeAdd");
        builder.setComparisonIsCaseSensitive(true);
        return builder;
    }

    protected DatabaseType execute(DatabasePlatform dbPlatform, NewNameDialog.Builder builder) {
        builder.setExistingNames(this.existingTypeNames(dbPlatform));
        NewNameDialog dialog = builder.buildDialog(this.getWorkbenchContext());
        dialog.show();
        if (dialog.wasConfirmed()) {
            return dbPlatform.addDatabaseType(dialog.getNewName());
        }
        return null;
    }

    private Iterator existingTypeNames(DatabasePlatform platform) {
        return new TransformationIterator(platform.databaseTypes()){

            protected Object transform(Object next) {
                return ((DatabaseType)next).getName();
            }
        };
    }
}

